/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class NewThreadAction
implements PrivilegedAction {
    static final ThreadGroup systemThreadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            ThreadGroup parent;
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            while ((parent = group.getParent()) != null) {
                group = parent;
            }
            return group;
        }
    });
    static final ThreadGroup userThreadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new ThreadGroup(systemThreadGroup, "RMI Runtime");
        }
    });
    private final ThreadGroup group;
    private final Runnable runnable;
    private final String name;
    private final boolean daemon;

    NewThreadAction(ThreadGroup group, Runnable runnable, String name, boolean daemon) {
        this.group = group;
        this.runnable = runnable;
        this.name = name;
        this.daemon = daemon;
    }

    public NewThreadAction(Runnable runnable, String name, boolean daemon) {
        this(systemThreadGroup, runnable, name, daemon);
    }

    public NewThreadAction(Runnable runnable, String name, boolean daemon, boolean user) {
        this(user ? userThreadGroup : systemThreadGroup, runnable, name, daemon);
    }

    public Object run() {
        Thread t = new Thread(this.group, this.runnable, "RMI " + this.name);
        t.setContextClassLoader(ClassLoader.getSystemClassLoader());
        t.setDaemon(this.daemon);
        return t;
    }
}

