/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.server;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jeus.rmi.impl.transport.ObjectTable;
import jeus.rmi.impl.transport.Target;
import jeus.rmi.impl.transport.tcp.TCPConnectionFactory;
import jeus.rmi.spec.server.RMIClassLoader;
import jeus.rmi.spec.server.RemoteStub;

public final class MarshalOutputStream
extends ObjectOutputStream {
    public MarshalOutputStream(OutputStream out) throws IOException {
        this(out, 1);
    }

    public MarshalOutputStream(OutputStream out, int protocolVersion) throws IOException {
        super(out);
        this.useProtocolVersion(protocolVersion);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MarshalOutputStream.this.enableReplaceObject(true);
                return null;
            }
        });
    }

    protected final Object replaceObject(Object obj) throws IOException {
        Target target;
        if (obj instanceof Remote && !(obj instanceof RemoteStub) && (target = ObjectTable.getTarget((Remote)obj)) != null) {
            obj = target.getStub();
        }
        return obj;
    }

    protected final void annotateClass(Class cl) throws IOException {
        this.writeLocation(TCPConnectionFactory.ignoreClassAnnotation ? null : RMIClassLoader.getClassAnnotation(cl));
    }

    protected final void annotateProxyClass(Class cl) throws IOException {
        this.annotateClass(TCPConnectionFactory.ignoreClassAnnotation ? null : cl);
    }

    protected final void writeLocation(String location) throws IOException {
        if (location == null) {
            this.writeByte(0);
        } else {
            this.writeByte(1);
            this.writeUTF(location);
        }
    }
}

