/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.net;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import jeus.net.SocketStream;
import jeus.rmi.impl.transport.net.JeusConnection;
import jeus.rmi.impl.transport.net.MultiThreadAcessJeusServerConnection;
import jeus.util.properties.JeusRMIProperties;

public class JeusServerConnection
extends JeusConnection {
    private static final HashMap activeSocketStreamToConnectionMap = new HashMap(3);
    private static final HashMap passiveSocketStreamToConnectionMap = new HashMap(3);
    private static final Vector streamProtocolSocketStream = new Vector();

    public JeusServerConnection(SocketStream socektStream) {
        super(socektStream);
        JeusServerConnection.addConnectionToMap(activeSocketStreamToConnectionMap, socektStream, this);
    }

    private static synchronized void addConnectionToMap(HashMap map, SocketStream socektStream, JeusServerConnection conn) {
        Vector<JeusServerConnection> connections = (Vector<JeusServerConnection>)map.get(socektStream);
        if (connections == null) {
            connections = new Vector<JeusServerConnection>();
            map.put(socektStream, connections);
        }
        connections.add(conn);
    }

    private static synchronized void removeConnectionToMap(HashMap map, SocketStream socektStream, JeusServerConnection conn) {
        Vector connections = (Vector)map.get(socektStream);
        if (connections != null) {
            connections.remove(conn);
            if (connections.isEmpty()) {
                map.remove(socektStream);
            }
        }
    }

    private static synchronized JeusServerConnection removeFirstConnectionToMap(HashMap map, SocketStream socektStream) {
        Vector connections = (Vector)map.get(socektStream);
        if (connections != null && !connections.isEmpty()) {
            JeusServerConnection conn = (JeusServerConnection)connections.get(0);
            connections.removeElementAt(0);
            return conn;
        }
        return null;
    }

    public static synchronized JeusServerConnection getConnection(SocketStream ss) {
        JeusServerConnection conn = JeusServerConnection.removeFirstConnectionToMap(passiveSocketStreamToConnectionMap, ss);
        if (conn == null) {
            conn = JeusRMIProperties.SINGLE_THREAD_CLIENT ? new JeusServerConnection(ss) : new MultiThreadAcessJeusServerConnection(ss);
        } else {
            JeusServerConnection.addConnectionToMap(activeSocketStreamToConnectionMap, ss, conn);
        }
        return conn;
    }

    public static void setProtocol(SocketStream ss, byte streamProtocol) {
        if (streamProtocol == 75) {
            streamProtocolSocketStream.add(ss);
        }
    }

    public static synchronized void free(SocketStream sockStream, JeusServerConnection conn) throws IOException {
        if (streamProtocolSocketStream.contains(sockStream)) {
            conn.resetOutputStream();
            JeusServerConnection.removeConnectionToMap(activeSocketStreamToConnectionMap, sockStream, conn);
            JeusServerConnection.addConnectionToMap(passiveSocketStreamToConnectionMap, sockStream, conn);
        } else {
            conn.close();
        }
    }

    public static synchronized Vector getConnections(SocketStream ss) {
        return (Vector)activeSocketStreamToConnectionMap.get(ss);
    }
}

