/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.net.help;

import java.net.Socket;
import java.rmi.ConnectIOException;
import java.util.logging.Level;
import jeus.net.ConnectionListenerSupport;
import jeus.net.SocketStream;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.proxy.RMISocketInfo;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.properties.JeusRMIProperties;
import sun.rmi.runtime.Log;

public class RMIConnectionListener
extends ConnectionListenerSupport {
    private static final int handshakeTimeout = JeusRMIProperties.CLIENT_HANDSHAKE_TO;
    private static final int responseTimeout = JeusRMIProperties.CLIENT_READ_TO;
    private byte protocol;
    private static Executor executor;

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) throws ConnectIOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "rmi jeus connection from {0} is accepted", (Object)sockStream);
        }
        if (this.protocol == 75) {
            byte[] ack = (byte[])piggybackedData;
            Socket sock = sockStream.getSocket();
            int originalSoTimeout = 0;
            try {
                originalSoTimeout = sock.getSoTimeout();
                sock.setSoTimeout(handshakeTimeout);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ack[0] != 78) {
                throw new ConnectIOException(ack[0] == 79 ? "JRMP StreamProtocol not supported by server" : "non-JRMP server at remote endpoint");
            }
            if (Transport.transportLog.isLoggable(Log.VERBOSE)) {
                Transport.transportLog.log(Log.VERBOSE, "using " + sock.getInetAddress().getHostName() + ":" + sock.getPort());
            }
            try {
                sock.setSoTimeout(originalSoTimeout != 0 ? originalSoTimeout : responseTimeout);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public boolean isReusable(Socket socket) {
        if (socket != null && socket instanceof RMISocketInfo) {
            return ((RMISocketInfo)((Object)socket)).isReusable();
        }
        return true;
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        if (JeusRMIProperties.ENABLE_CLIENT_PROCESS_POOL) {
            executor.execute(messageProcessor);
        } else {
            messageProcessor.run();
        }
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        if (msgType == 1) {
            this.protocol = this.isReusable(sockStream.getSocket()) ? (byte)75 : (byte)76;
            ((byte[])piggybackedData)[6] = this.protocol;
        }
        return piggybackedData;
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "rmi jeus connection from {0} is closed", (Object)socketStream);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) {
    }

    static {
        if (JeusRMIProperties.ENABLE_CLIENT_PROCESS_POOL) {
            executor = PooledExecutorFactory.createPooledExecutor((String)"RMIConnectionListener", (int)JeusRMIProperties.CLIENT_PROCESS_POOL_SIZE);
        }
    }
}

