/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.spec.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import jeus.rmi.impl.server.UnicastRef;
import jeus.rmi.impl.server.UnicastRef2;
import jeus.rmi.impl.transport.ObjectTable;
import jeus.rmi.spec.server.RemoteRef;
import jeus.rmi.spec.server.RemoteStub;

public abstract class RemoteObject
implements Remote,
Serializable {
    protected transient RemoteRef ref;
    private static final long serialVersionUID = -2621222103658317017L;

    protected RemoteObject() {
        this.ref = null;
    }

    protected RemoteObject(RemoteRef newref) {
        this.ref = newref;
    }

    public RemoteRef getRef() {
        return this.ref;
    }

    public static Remote toStub(Remote obj) throws NoSuchObjectException {
        if (obj instanceof RemoteStub) {
            return (RemoteStub)obj;
        }
        return ObjectTable.getStub(obj);
    }

    public int hashCode() {
        return this.ref == null ? super.hashCode() : this.ref.remoteHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteObject) {
            if (this.ref == null) {
                return obj == this;
            }
            return this.ref.remoteEquals(((RemoteObject)obj).ref);
        }
        if (obj != null) {
            return obj.equals(this);
        }
        return false;
    }

    public String toString() {
        String classname = this.getClass().getName();
        return this.ref == null ? classname : classname + "[" + this.ref.remoteToString() + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.ref == null) {
            throw new MarshalException("Invalid remote object");
        }
        RemoteObject.writeRemoteRef(out, this.ref);
    }

    public static void writeRemoteRef(ObjectOutputStream out, RemoteRef ref) throws IOException {
        if (ref instanceof UnicastRef2) {
            out.writeByte(1);
            ref.writeExternal(out);
        } else if (ref instanceof UnicastRef) {
            out.writeByte(2);
            ref.writeExternal(out);
        } else {
            out.writeByte(0);
            out.writeObject(ref);
        }
    }

    public static RemoteRef readRemoteRef(ObjectInputStream in) throws IOException, ClassNotFoundException {
        RemoteRef ref;
        byte _type = in.readByte();
        switch (_type) {
            case 1: {
                ref = new UnicastRef2();
                ref.readExternal(in);
                break;
            }
            case 2: {
                ref = new UnicastRef();
                ref.readExternal(in);
                break;
            }
            default: {
                ref = (RemoteRef)in.readObject();
            }
        }
        return ref;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.ref = RemoteObject.readRemoteRef(in);
    }
}

