/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.security.Permission;
import java.util.Map;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Policy;
import jeus.security.resource.RoleImpl;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.util.Constants;
import jeus.security.util.PermissionMaker;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class AssignResourceCommand
extends Command {
    jeus.util.console.Argument role_name;
    jeus.util.console.Argument resource_name;
    ArgumentedOption action_list;
    ArgumentedOption context_id;
    ArgumentedOption class_name;
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public AssignResourceCommand() {
        super("assignresource", "Assign a resource to a role (role-to-resource mapping)");
        this.role_name = new Argument("role", "The name of the role", String.class, false);
        this.resource_name = new Argument("resource", "The name of the resource", String.class, false);
        this.action_list = new ArgumentedOption("actions", "actions", "The actions of the RolePermission", "action is null", true);
        this.context_id = new ArgumentedOption("contextid", "contextid", "Policy context id for mapping", "default contextid is \"default\"", true);
        this.class_name = new ArgumentedOption("classname", "classname", "The classname of the Permission", "default domain name is SYSTEM_DOMAIN", true);
        this.registerArgument(this.resource_name);
        this.registerArgument(this.role_name);
        this.registerArgument((jeus.util.console.Argument)this.action_list);
        this.registerArgument((jeus.util.console.Argument)this.context_id);
        this.registerArgument((jeus.util.console.Argument)this.class_name);
        this.registerArgument((jeus.util.console.Argument)this.domain);
        this.addArgument(new Argument("role", "The name of a role to be mapped to the resource ", String.class, false));
        this.addArgument(new Argument("resource", "The name of the resource", String.class, false));
        this.addArgument(new Argument("actions", "The actions of the resource", String.class, true));
        this.addArgument(new Argument("contextid", "Policy context id for mapping", String.class, true));
        this.addArgument(new Argument("classname", "The classname of the Permission", String.class, true));
    }

    public Object run(Map args) throws Exception {
        String classname;
        String role = (String)args.get("role");
        String resource = (String)args.get("resource");
        String actions = (String)args.get("actions");
        String contextid = (String)args.get("contextid");
        if (contextid == null) {
            contextid = "default";
        }
        if ((classname = (String)args.get("classname")) == null) {
            classname = Constants.DEFAULT_RR_PERMISSION_CLASSNAME;
        }
        Permission p = PermissionMaker.makePermission((String)classname, (String)resource, (String)actions);
        Policy policy = new Policy();
        policy.getResourcePolicy(contextid, true).addPermission(p, new Object[]{new RoleImpl(role)}, false, false);
        AuthorizationRepositoryService.addPolicy(policy);
        return "Assigned resource \"" + resource + "\" to role \"" + role + "\"";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String classname;
        String role = this.role_name.getValue();
        String resource = this.resource_name.getValue();
        String actions = this.action_list.getValue();
        String contextid = this.context_id.getValue();
        if (contextid == null) {
            contextid = "default";
        }
        if ((classname = this.class_name.getValue()) == null) {
            classname = Constants.DEFAULT_RR_PERMISSION_CLASSNAME;
        }
        Permission p = PermissionMaker.makePermission((String)classname, (String)resource, (String)actions);
        Policy policy = new Policy();
        policy.getResourcePolicy(contextid, true).addPermission(p, new Object[]{new RoleImpl(role)}, false, false);
        String domainname = this.domain.getValue();
        PolicyMoMBean policyMoMBean = SecurityGroup.getPolicyMoMBean(domainname);
        if (policyMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        policyMoMBean.addPolicy(policy);
        out.println("Assigned resource \"" + resource + "\" to role \"" + role + "\"");
    }
}

