/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Subject;
import jeus.security.resource.ExpiryTimeFactory;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.util.SetUtil;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class ClearSubjectExpirationCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public ClearSubjectExpirationCommand() {
        super("clearsubjectexpiration", "Remove the expiration time for Subject with the given user name");
        this.addArgument(new Argument("username", "Subject username", String.class, false));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        Subject sub = AuthenticationRepositoryService.getSubject((String)args.get("username"));
        Set s = SetUtil.getMembers(ExpiryTimeFactory.class, sub.getCredentialFactories());
        Subject sub3 = Subject.makeSubject((String)args.get("username"));
        sub3.getCredentialFactories().addAll(s);
        AuthenticationRepositoryService.removeSubject(sub3);
        return "Expiration time removed for Subject " + (String)args.get("username");
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        Subject sub = subjectMoMBean.getSubject(username);
        Set s = SetUtil.getMembers(ExpiryTimeFactory.class, sub.getCredentialFactories());
        Subject sub3 = Subject.makeSubject(username);
        sub3.getCredentialFactories().addAll(s);
        subjectMoMBean.removeSubject(sub3);
        out.println("Expiration time removed for Subject " + sub3);
    }
}

