/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Command;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.util.Constants;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class GetSubjectNamesCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public GetSubjectNamesCommand() {
        super("getsubjectnames", "Get the names for all Subjects in the current security domain");
        this.registerArgument((Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        Iterator names = AuthenticationRepositoryService.getSubjectNames().iterator();
        int i = 1;
        StringBuffer result = new StringBuffer();
        while (names.hasNext()) {
            result.append(i + ". ");
            result.append((String)names.next());
            result.append(Constants.NEWLINE);
            ++i;
        }
        result.append("Got " + (i - 1) + " Subject names");
        return result.toString();
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        Iterator names = subjectMoMBean.getSubjectNames().iterator();
        int i = 1;
        StringBuffer result = new StringBuffer();
        while (names.hasNext()) {
            result.append(i + ". ");
            result.append((String)names.next());
            result.append(Constants.NEWLINE);
            ++i;
        }
        result.append("Got " + (i - 1) + " Subject names");
        out.println(result.toString());
    }
}

