/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.ServiceException;
import jeus.security.resource.PrincipalImpl;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class RemoveUserFromGroupCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public RemoveUserFromGroupCommand() {
        super("removeuserfromgroup", "Remove a user from the Group with the given group name and user name");
        this.addArgument(new Argument("groupname", "Group name", String.class, false));
        this.addArgument(new Argument("username", "User name", String.class, false));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String groupname = (String)args.get("groupname");
        String username = (String)args.get("username");
        try {
            AuthenticationRepositoryService.removeUserFromGroup(groupname, new PrincipalImpl(username));
        }
        catch (ServiceException s) {
            s.printStackTrace();
            throw new Exception("fail to removed user to Group (" + groupname + ":" + username + ")");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("fail to removed user to Group (" + groupname + ":" + username + ")");
        }
        return "Removed user " + username + " from Group " + groupname;
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String groupname = this.getArgument("groupname").getValue();
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        try {
            subjectMoMBean.removeUserFromGroup(groupname, new PrincipalImpl(username));
        }
        catch (ServiceException s) {
            s.printStackTrace();
            throw new Exception("fail to removed user to Group (" + groupname + ":" + username + ")");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("fail to removed user to Group (" + groupname + ":" + username + ")");
        }
        out.println("Removed user " + username + " from Group " + groupname);
    }
}

