/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.AuthorizationRepositoryService;

public class RepositoryServiceRefreshCommand
extends Command {
    public RepositoryServiceRefreshCommand() {
        super("refresh", "refresh repository service in the current security domain");
        this.addArgument(new Argument("repositoryType", "subject or policy", String.class, false));
    }

    public Object run(Map args) throws Exception {
        String repositoryType = (String)args.get("repositoryType");
        if (repositoryType.equals("policy")) {
            AuthorizationRepositoryService.refresh();
        } else {
            AuthenticationRepositoryService.refresh();
        }
        return "repository service refresh";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String repositoryType = this.getArgument("repositoryType").getValue();
        if (repositoryType.equals("policy")) {
            AuthorizationRepositoryService.refresh();
        } else {
            AuthenticationRepositoryService.refresh();
        }
        out.println("repository service refresh");
    }
}

