/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import jeus.net.impl.NodeInfo;
import jeus.security.util.Arrays;
import jeus.security.util.Constants;
import jeus.security.util.NameAndPathUtil;
import jeus.util.EnvironmentCall;

public class Environment
implements Serializable {
    private static final long serialVersionUID = 2460725173895968763L;
    public static final String DEFAULT_DOMAIN_NAME_PROPERTY_KEY = "jeus.security.default.domainName";
    public static final String DEFAULT_CONFIGURATION_DIRECTORY_PROPERTY_KEY = "jeus.security.default.configDir";
    public static final String DEFAULT_CONFIGURATION_FILENAME_PROPERTY_KEY = "jeus.security.default.configFile";
    private static String theLocalHostName;
    private static String theLocalNodeName;
    private static String theDefaultDomainName;
    private static String theConfigurationDirectory;
    private static String enableAtnValue;
    private static String enableAznValue;
    private static String retriesValue;
    private boolean enableClientAtnCache = enableAtnValue == null || Boolean.getBoolean(enableAtnValue.trim());
    private boolean enableClientAznCache = enableAznValue == null || Boolean.getBoolean(enableAznValue.trim());
    private int retries = retriesValue != null ? Integer.parseInt(retriesValue.trim()) : 1;
    public boolean enableNIO = true;
    public int SECURITY_PROTOCOL_VERSION = 2;
    public boolean securitySwitch = true;
    public boolean master = false;
    public boolean slave = false;
    public boolean client = false;
    public long startTime = -1L;
    public String[] hostNames = new String[]{"localhost"};
    public int baseSecurityPort = EnvironmentCall.getJeusBasePort();
    public int[] remoteBaseSecurityPorts = new int[0];
    public final String id = NameAndPathUtil.getUniqueVMId();
    public String[] domains = new String[]{theDefaultDomainName};
    public String defaultDomainName = theDefaultDomainName;
    public boolean requiresLocalAuthentication = false;
    public boolean requiresSecurityManagement = false;
    public boolean requiresSecureConnection = false;
    public String baseSecurityConfigurationDirectory = theConfigurationDirectory;
    public String vmName = "unknown";
    public final String localHostName = theLocalHostName;
    public final String localNodeName = theLocalNodeName;
    public String[] clientSubjectFactoryServiceClassnames;
    public String jaasCallbackHandler = "jeus.security.impl.callback.CommandLineCallbackHandler";
    private Map domainsInfoMap = new Hashtable();
    private NodeInfo nodeInfo;

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        buf.append("SECURITY ENVIRONMENT");
        buf.append(Constants.NEWLINE + "ID: ");
        buf.append(this.id);
        buf.append(Constants.NEWLINE + "START TIME: ");
        if (this.startTime > 0L) {
            buf.append(new Date(this.startTime));
        } else {
            buf.append("Not Started");
        }
        buf.append(Constants.NEWLINE + "VM NAME: ");
        buf.append(this.vmName);
        buf.append(Constants.NEWLINE + "SECURITY NETWORK PROTOCOL VERSION: ");
        buf.append(this.SECURITY_PROTOCOL_VERSION);
        buf.append(Constants.NEWLINE + "LOCAL HOST NAME: ");
        buf.append(this.localHostName);
        buf.append(Constants.NEWLINE + "LOCAL NODE NAME: ");
        buf.append(this.localNodeName);
        buf.append(Constants.NEWLINE + "IS MASTER: ");
        buf.append(this.master);
        buf.append(Constants.NEWLINE + "IS SLAVE: ");
        buf.append(this.slave);
        buf.append(Constants.NEWLINE + "IS CLIENT: ");
        buf.append(this.client);
        buf.append(Constants.NEWLINE + "DEFAULT DOMAIN NAME: ");
        buf.append(this.defaultDomainName);
        buf.append(Constants.NEWLINE + "DOMAIN LISH: ");
        for (int i = 0; i < this.domains.length; ++i) {
            buf.append(Constants.NEWLINE + this.domains[i]);
        }
        buf.append(Constants.NEWLINE + "BASE SECURITY PORT: ");
        buf.append(this.baseSecurityPort);
        buf.append(Constants.NEWLINE + "REMOTE HOSTS: ");
        buf.append(Arrays.toString(this.hostNames));
        buf.append(Constants.NEWLINE + "REMOTE SECURITY PORTS: ");
        buf.append(Arrays.toString(this.remoteBaseSecurityPorts));
        buf.append(Constants.NEWLINE + "BASE SECURITY CONFIGURATION DIR: ");
        buf.append(this.baseSecurityConfigurationDirectory);
        buf.append(Constants.NEWLINE + "JAAS CALLBACK HANDLER CLASSNAME: ");
        buf.append(this.jaasCallbackHandler);
        buf.append(Constants.NEWLINE + "REQUIRES LOCAL AUTHENTICATION: ");
        buf.append(this.requiresLocalAuthentication);
        buf.append(Constants.NEWLINE + "REQUIRES SECURE CONNECTION: ");
        buf.append(this.requiresSecureConnection);
        buf.append(Constants.NEWLINE + "REQUIRES SECURITY MANAGEMENT: ");
        buf.append(this.requiresSecurityManagement);
        return buf.toString();
    }

    public static Environment getMasterConfiguration() {
        Environment sc = new Environment();
        sc.master = true;
        return sc;
    }

    public static Environment getSlaveConfiguration() {
        Environment sc = new Environment();
        sc.slave = true;
        return sc;
    }

    public static Environment getSecurityManagementClientConfiguration() {
        Environment sc = new Environment();
        sc.client = true;
        sc.requiresLocalAuthentication = true;
        sc.requiresSecurityManagement = true;
        return sc;
    }

    public static Environment getBasicLocalAuthClientConfiguration() {
        Environment sc = new Environment();
        sc.client = true;
        sc.requiresLocalAuthentication = true;
        return sc;
    }

    public static Environment getBasicNoLocalAuthClientConfiguration() {
        Environment sc = new Environment();
        sc.client = true;
        return sc;
    }

    public void setNodeInfo(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean isEnableClientAtnCache() {
        return this.enableClientAtnCache;
    }

    public boolean isEnableClientAznCache() {
        return this.enableClientAznCache;
    }

    public Map getDomainsInfoMap() {
        return this.domainsInfoMap;
    }

    public void setDomainsInfoMap(Map domainsInfoMap) {
        this.domainsInfoMap = domainsInfoMap;
    }

    private void readObject(ObjectInputStream is) throws IOException {
        ObjectInputStream.GetField field;
        try {
            field = is.readFields();
        }
        catch (ClassNotFoundException e) {
            throw new IOException();
        }
        this.enableClientAtnCache = field.get("enableClientAtnCache", true);
        this.enableClientAznCache = field.get("enableClientAznCache", true);
        this.enableNIO = field.get("enableNIO", true);
        this.retries = field.get("retries", 10);
        this.securitySwitch = field.get("securitySwitch", false);
        this.master = field.get("master", false);
        this.slave = field.get("slave", false);
        this.client = field.get("client", false);
        this.startTime = field.get("startTime", -1L);
        this.hostNames = (String[])field.get("hostNames", new String[]{"localhost"});
        this.baseSecurityPort = field.get("baseSecurityPort", EnvironmentCall.getJeusBasePort());
        this.SECURITY_PROTOCOL_VERSION = field.get("SECURITY_PROTOCOL_VERSION", 1);
        this.remoteBaseSecurityPorts = (int[])field.get("remoteBaseSecurityPorts", new int[0]);
        this.domains = (String[])field.get("domains", new String[]{theDefaultDomainName});
        this.defaultDomainName = (String)field.get("defaultDomainName", theDefaultDomainName);
        this.requiresLocalAuthentication = field.get("requiresLocalAuthentication", false);
        this.requiresSecurityManagement = field.get("requiresSecurityManagement", false);
        this.requiresSecureConnection = field.get("requiresSecureConnection", false);
        this.baseSecurityConfigurationDirectory = (String)field.get("baseSecurityConfigurationDirectory", theConfigurationDirectory);
        this.vmName = (String)field.get("vmName", "unknown");
        this.clientSubjectFactoryServiceClassnames = (String[])field.get("clientSubjectFactoryServiceClassnames", null);
        this.jaasCallbackHandler = (String)field.get("jaasCallbackHandler", "jeus.security.impl.callback.CommandLineCallbackHandler");
        this.nodeInfo = (NodeInfo)field.get("nodeInfo", null);
        this.domainsInfoMap = null;
    }

    static {
        File theFile;
        theLocalHostName = NameAndPathUtil.getHostName();
        theLocalNodeName = NameAndPathUtil.getNodeName();
        theConfigurationDirectory = System.getProperty(DEFAULT_CONFIGURATION_DIRECTORY_PROPERTY_KEY);
        if (theConfigurationDirectory == null) {
            String jeusConfigHome = EnvironmentCall.getJeusConfigHome();
            theConfigurationDirectory = jeusConfigHome == null ? "./" : jeusConfigHome + File.separator + EnvironmentCall.getLocalVirutalName() + File.separator + "security";
        }
        if ((theDefaultDomainName = System.getProperty(DEFAULT_DOMAIN_NAME_PROPERTY_KEY)) == null) {
            theDefaultDomainName = "DEFAULT_APPLICATION_DOMAIN";
        }
        if (!(theFile = new File(NameAndPathUtil.getPathWithEndingSeparator(theConfigurationDirectory) + theDefaultDomainName)).exists()) {
            theDefaultDomainName = "SYSTEM_DOMAIN";
        }
        enableAtnValue = System.getProperty("jeus.security.atnrep.enable.cache");
        enableAznValue = System.getProperty("jeus.security.aznrep.enable.cache");
        retriesValue = System.getProperty("jeus.security.connect.retries");
    }
}

