/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import jeus.security.base.Role;
import jeus.security.container.web.HTTPMethod;
import jeus.security.resource.RoleImpl;
import jeus.security.util.ConcurrentHashSetReadOnlyIterator;
import jeus.security.util.CopyOnWriteHashSet;
import jeus.security.util.OneToManyMap;

public class PermissionMap
implements Cloneable,
Serializable {
    public static final CheckResult EXCLUDED = new CheckResult("Permission denied since it is excluded", false);
    public static final CheckResult UNCHECKED = new CheckResult("Permission granted since it is unchecked", true);
    public static final CheckResult GRANTED = new CheckResult("Permission granted to principal", true);
    public static final CheckResult DENIED = new CheckResult("Permission denied to principal", false);
    private Set excludedPermissions;
    private OneToManyMap checkedPermissions;
    private OneToManyMap checkedReversePermissions;
    private transient OneToManyMap unspecifiedMethods;
    private Set uncheckedPermissions;
    private boolean isResourcePolicy;

    public PermissionMap() {
        this.excludedPermissions = new CopyOnWriteHashSet();
        this.checkedPermissions = new OneToManyMap(CopyOnWriteHashSet.class);
        this.uncheckedPermissions = new CopyOnWriteHashSet();
        this.unspecifiedMethods = new OneToManyMap(CopyOnWriteHashSet.class);
    }

    public PermissionMap(boolean resource) {
        this.isResourcePolicy = resource;
        this.excludedPermissions = new CopyOnWriteHashSet();
        this.checkedPermissions = new OneToManyMap(CopyOnWriteHashSet.class);
        this.checkedReversePermissions = new OneToManyMap(CopyOnWriteHashSet.class);
        this.uncheckedPermissions = new CopyOnWriteHashSet();
        this.unspecifiedMethods = new OneToManyMap(CopyOnWriteHashSet.class);
    }

    public boolean isEmpty() {
        return this.excludedPermissions.isEmpty() && this.uncheckedPermissions.isEmpty() && this.checkedPermissions.isEmpty();
    }

    public void addPermission(Permission permission, Object[] owners, boolean excluded, boolean unchecked) {
        if (permission == null) {
            return;
        }
        if (owners != null) {
            for (int i = 0; i < owners.length; ++i) {
                this.checkedPermissions.put(owners[i], permission);
                if (!this.isResourcePolicy) continue;
                this.checkedReversePermissions.put(permission, owners[i]);
            }
        }
        if (excluded) {
            this.excludedPermissions.add(permission);
        }
        if (unchecked) {
            this.uncheckedPermissions.add(permission);
        }
    }

    public void removePermission(Permission permission) {
        this.uncheckedPermissions.remove(permission);
        this.excludedPermissions.remove(permission);
        for (Object o : this.checkedPermissions.keys()) {
            this.checkedPermissions.removeValue(o, permission);
        }
        if (this.isResourcePolicy) {
            this.checkedReversePermissions.remove(permission);
        }
    }

    public void updateCheckedPermission(Permission newPermission, RoleImpl owner) {
        if (owner != null) {
            Set perms = (Set)this.checkedPermissions.get(owner);
            if (this.checkImplies(perms, newPermission)) {
                this.checkedPermissions.removeValue(owner, perms);
                this.checkedReversePermissions.removeValue(perms, owner);
            }
            this.checkedPermissions.put(owner, newPermission);
            this.checkedReversePermissions.put(newPermission, owner);
        }
    }

    public CheckResult checkPermission(Permission permission) {
        return this.checkUncheckedExcludedPermission(permission);
    }

    public CheckResult checkPermission(Object owner, Permission permission) {
        if (owner != null) {
            Set perms = (Set)this.checkedPermissions.get(owner);
            if (this.checkImplies(perms, permission)) {
                return GRANTED;
            }
            return DENIED;
        }
        return DENIED;
    }

    private CheckResult checkUncheckedExcludedPermission(Permission permission) {
        if (this.checkImplies(this.excludedPermissions, permission)) {
            return EXCLUDED;
        }
        if (this.checkImplies(this.uncheckedPermissions, permission)) {
            return UNCHECKED;
        }
        return DENIED;
    }

    private boolean checkImplies(Set permissions, Permission permission) {
        if (permissions == null) {
            return false;
        }
        for (Object o : permissions) {
            Permission temp;
            if (!(o instanceof Permission) || !(temp = (Permission)o).implies(permission)) continue;
            return true;
        }
        return false;
    }

    public PermissionMap add(PermissionMap mapToAdd) {
        if (mapToAdd != null && mapToAdd != this) {
            this.excludedPermissions.addAll(mapToAdd.excludedPermissions);
            this.checkedPermissions.merge(mapToAdd.checkedPermissions);
            if (this.isResourcePolicy) {
                this.checkedReversePermissions.merge(mapToAdd.checkedReversePermissions);
            }
            this.uncheckedPermissions.addAll(mapToAdd.uncheckedPermissions);
            this.unspecifiedMethods.merge(mapToAdd.unspecifiedMethods);
        }
        return this;
    }

    public PermissionMap remove(PermissionMap mapToRemove) {
        if (mapToRemove == this) {
            this.clear();
        } else if (mapToRemove != null) {
            this.excludedPermissions.removeAll(mapToRemove.excludedPermissions);
            this.checkedPermissions.remove(mapToRemove.checkedPermissions);
            if (this.isResourcePolicy) {
                this.checkedReversePermissions.remove(mapToRemove.checkedReversePermissions);
            }
            this.uncheckedPermissions.removeAll(mapToRemove.uncheckedPermissions);
        }
        return this;
    }

    public void clear() {
        this.excludedPermissions.clear();
        this.uncheckedPermissions.clear();
        this.checkedPermissions.clear();
        if (this.isResourcePolicy) {
            this.checkedReversePermissions.clear();
        }
    }

    public void removeUnspecifiedMethods(String beanName) {
        this.unspecifiedMethods.remove(beanName);
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("  PERMISSION MAP\n  --------------\n\n");
        strBuf.append("  Excluded permissions:\n");
        Iterator iter = this.excludedPermissions.iterator();
        if (!iter.hasNext()) {
            strBuf.append("    (none)\n");
        } else {
            while (iter.hasNext()) {
                strBuf.append("    ");
                strBuf.append(iter.next());
                strBuf.append("\n");
            }
        }
        strBuf.append("\n");
        strBuf.append("  Unchecked permissions:\n");
        iter = this.uncheckedPermissions.iterator();
        if (!iter.hasNext()) {
            strBuf.append("    (none)\n");
        } else {
            while (iter.hasNext()) {
                strBuf.append("    ");
                strBuf.append(iter.next());
                strBuf.append("\n");
            }
        }
        strBuf.append("\n");
        strBuf.append("  Checked permissions:\n");
        for (Object owner : this.checkedPermissions.keys()) {
            strBuf.append("    Permission owner:\n");
            strBuf.append("    ");
            strBuf.append(owner);
            strBuf.append("\n");
            strBuf.append("    Permissions of owner:\n");
            for (Object permission : this.checkedPermissions.get(owner)) {
                strBuf.append("    ");
                strBuf.append(permission);
                strBuf.append("\n");
            }
            strBuf.append("\n");
        }
        strBuf.append("\n");
        return strBuf.toString();
    }

    public Object clone() {
        PermissionMap newPC = this.isResourcePolicy ? new PermissionMap(true) : new PermissionMap();
        newPC.add(this);
        return newPC;
    }

    public boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (anotherObject == null) {
            return false;
        }
        if (anotherObject instanceof PermissionMap) {
            PermissionMap pc = (PermissionMap)anotherObject;
            return this.checkedPermissions.equals(pc.checkedPermissions) && ((Object)this.excludedPermissions).equals(pc.excludedPermissions) && ((Object)this.uncheckedPermissions).equals(pc.uncheckedPermissions);
        }
        return false;
    }

    public int hashCode() {
        return this.checkedPermissions.hashCode() + ((Object)this.excludedPermissions).hashCode() + ((Object)this.uncheckedPermissions).hashCode();
    }

    public Collection getAllPermissions() {
        HashSet result = new HashSet();
        result.addAll(this.excludedPermissions);
        result.addAll(this.uncheckedPermissions);
        result.addAll(this.checkedPermissions.values());
        return new ConcurrentHashSetReadOnlyIterator(Permission.class, result);
    }

    public Collection getExcludedPermissions() {
        return this.excludedPermissions;
    }

    public Collection getUncheckedPermissions() {
        return this.uncheckedPermissions;
    }

    public void updateWebUncheckedPermission(String qualification, HTTPMethod inverse, String httpMethods) {
        Set permissions = this.uncheckedPermissions;
        this.checkWebImplies(permissions, qualification, inverse, httpMethods);
    }

    private void checkWebImplies(Set permissions, String qualification, HTTPMethod inverse, String httpMethods) {
        if (permissions == null) {
            return;
        }
        Iterator iter = permissions.iterator();
        boolean isUpdateWebUserDataPermission = false;
        boolean isUpdateWebResourcePermission = false;
        while (iter.hasNext()) {
            WebResourcePermission webResourcePerm;
            HTTPMethod methods;
            String action;
            Object obj = iter.next();
            if (obj instanceof WebUserDataPermission) {
                WebUserDataPermission webUserPerm = (WebUserDataPermission)obj;
                if (!webUserPerm.getName().equals(qualification) || (action = webUserPerm.getActions()) != null && action.indexOf(":") > 0 || (methods = inverse.merge(new HTTPMethod((Permission)webUserPerm))).size() != 7) continue;
                WebUserDataPermission perm2 = new WebUserDataPermission(qualification, null);
                this.uncheckedPermissions.remove(webUserPerm);
                this.uncheckedPermissions.add(perm2);
                isUpdateWebUserDataPermission = true;
                continue;
            }
            if (!(obj instanceof WebResourcePermission) || !(webResourcePerm = (WebResourcePermission)obj).getName().equals(qualification) || (action = webResourcePerm.getActions()) != null && action.indexOf(":") > 0 || (methods = inverse.merge(new HTTPMethod((Permission)webResourcePerm))).size() != 7) continue;
            WebResourcePermission perm1 = new WebResourcePermission(qualification, (String)null);
            this.uncheckedPermissions.remove(webResourcePerm);
            this.uncheckedPermissions.add(perm1);
            isUpdateWebResourcePermission = true;
        }
        if (!isUpdateWebResourcePermission) {
            WebResourcePermission perm1 = new WebResourcePermission(qualification, httpMethods);
            this.uncheckedPermissions.add(perm1);
        }
        if (!isUpdateWebUserDataPermission) {
            WebUserDataPermission perm2 = new WebUserDataPermission(qualification, httpMethods);
            this.uncheckedPermissions.add(perm2);
        }
    }

    public Collection getCheckedPermissions(Object owner) {
        return this.checkedPermissions.get(owner);
    }

    public Collection getCheckedReversePermissions(Object owner) {
        return this.checkedReversePermissions.get(owner);
    }

    public OneToManyMap getCheckedPermissions() {
        return this.checkedPermissions;
    }

    public OneToManyMap getCheckedReversePermissions() {
        return this.checkedReversePermissions;
    }

    public Collection getCheckedPermissionOwners() {
        return this.checkedPermissions.keys();
    }

    public Collection getCheckedReversePermissionOwners() {
        return this.checkedReversePermissions.keys();
    }

    public Collection getCheckedPermissionOwners(Permission p) {
        return this.checkedPermissions.keys(p);
    }

    public Collection getCheckedReversePermissionImplies(Permission p) {
        Iterator allOwners = this.getCheckedReversePermissionOwners().iterator();
        HashSet result = new HashSet();
        while (allOwners.hasNext()) {
            Permission op = (Permission)allOwners.next();
            if (!op.implies(p)) continue;
            result.addAll(this.getCheckedReversePermissions(op));
        }
        return new ConcurrentHashSetReadOnlyIterator(Role.class, result);
    }

    public Collection getUnspecifiedMethodInfo(String beanName) {
        return this.unspecifiedMethods.get(beanName);
    }

    public void addUnspecifiedMethodInfo(String beanName, Method unspecifiedMethod) {
        this.unspecifiedMethods.put(beanName, unspecifiedMethod);
    }

    public static class CheckResult {
        private String message;
        private boolean granted;

        public CheckResult(String message, boolean granted) {
            this.message = message;
            this.granted = granted;
        }

        public String toString() {
            return this.getMessage();
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isGranted() {
            return this.granted;
        }

        public boolean equals(Object another) {
            if (another == null) {
                return false;
            }
            if (another == this) {
                return true;
            }
            if (another instanceof CheckResult) {
                CheckResult cr = (CheckResult)another;
                return this.message.equals(cr.message) && this.granted == cr.granted;
            }
            return false;
        }

        public int hashCode() {
            return this.message.hashCode();
        }
    }
}

