/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import jeus.security.base.Domain;
import jeus.security.base.PropertyHolder;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.util.GenericMBean;

public abstract class Service
extends Properties
implements PropertyHolder {
    private static final int DESTROYED_STATE = 1;
    private static final int CREATED_STATE = 2;
    private static int idCounter = 0;
    private int state = 1;
    private Object bean;
    private int id = idCounter++;
    private Domain domain;
    private String description = "No description available";

    public Service() {
        MBeanInfo info = this.getMBeanInfo();
        if (info != null) {
            this.bean = new GenericMBean(this, info);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        String s = this.getType().getName();
        return s.substring(s.lastIndexOf(46) + 1) + "(" + this.id + ")";
    }

    void setDomain(Domain d) {
        this.domain = d;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public String getState() {
        if (this.isCreated()) {
            return "Created";
        }
        if (this.isDestroyed()) {
            return "Destroyed";
        }
        return "Invalid state";
    }

    public final boolean isCreated() {
        return this.state == 2;
    }

    public final synchronized void create() throws ServiceException, SecurityException {
        this.create(false);
    }

    public final synchronized void create(boolean force) throws ServiceException, SecurityException {
        if (force || this.isDestroyed()) {
            this.doCreate();
            this.state = 2;
        }
    }

    public final synchronized void destroy() {
        if (this.isCreated()) {
            this.doDestroy();
            this.state = 1;
        }
    }

    public final boolean isDestroyed() {
        return this.state == 1;
    }

    public Object getMBean() {
        return this.bean;
    }

    protected MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo state = new MBeanAttributeInfo("State", String.class.getName(), "The current state of this service", true, false, false);
        return new MBeanInfo(Service.class.getName(), this.getDescription(), new MBeanAttributeInfo[]{state}, null, null, null);
    }

    public abstract Class getType();

    protected abstract void doCreate() throws ServiceException, SecurityException;

    protected abstract void doDestroy();

    public abstract void doRegisterMBean(ObjectName var1);

    private void dump(StringBuffer buf, int indent) {
        this.indent(buf, indent);
        buf.append("SERVICE:\n");
        this.indent(buf, indent);
        buf.append("  Description: " + this.getDescription() + "\n");
        this.indent(buf, indent);
        buf.append("  Classname: " + this.getClass().getName() + "\n");
        this.indent(buf, indent);
        buf.append("  Type.....: " + this.getType().getName() + "\n");
        this.indent(buf, indent);
        buf.append("  State....: " + this.getState() + "\n");
        this.indent(buf, indent);
        buf.append("  Id....: " + this.id + "\n");
        this.indent(buf, indent);
    }

    private void indent(StringBuffer buf, int indent) {
        for (int i = 0; i < indent; ++i) {
            buf.append(" ");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.dump(buf, 0);
        return buf.toString();
    }
}

