/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.CredentialFactory;
import jeus.security.base.CredentialFactoryException;
import jeus.security.base.Domain;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.resource.DefaultPasswordFactory;
import jeus.security.resource.Password;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.SystemPassword;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.Constants;
import jeus.security.util.CopyOnWriteHashSet;
import jeus.security.util.CopyOnWriteLinkedHashSet;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.NetworkUtil;
import jeus.util.Serializer;

public class Subject
implements Serializable {
    static final long serialVersionUID = 8477832514007533428L;
    public static SubjectNameComparator SUBJECT_NAME_COMPARATOR = new SubjectNameComparator();
    private String description = "No description";
    private String domainName;
    private Principal mainPrincipal;
    private Set principals = new CopyOnWriteLinkedHashSet();
    private Set publicCredentials = new CopyOnWriteHashSet();
    private Set privateCredentials = new CopyOnWriteHashSet();
    private Set credentialFactories = new CopyOnWriteHashSet();
    private String trace;
    private Set passwordInfos = null;

    public Subject(String domainName) {
        this(domainName, null);
    }

    public Subject(Principal principal) {
        this(null, principal);
    }

    public Subject(String domainName, Principal principal) {
        if (domainName != null) {
            this.domainName = domainName;
        } else {
            try {
                this.domainName = Domain.getCurrentDomain().getName();
            }
            catch (Exception e) {
                try {
                    this.domainName = SecurityInstaller.getEnvironment().defaultDomainName;
                }
                catch (Exception e2) {
                    this.domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
                }
            }
        }
        if (principal != null) {
            this.mainPrincipal = principal;
            this.principals.add(principal);
        }
    }

    public Subject(String domainName, Principal principal, boolean isUser) {
        if (domainName != null) {
            this.domainName = domainName;
        } else {
            try {
                this.domainName = Domain.getCurrentDomain().getName();
            }
            catch (Exception e) {
                try {
                    this.domainName = SecurityInstaller.getEnvironment().defaultDomainName;
                }
                catch (Exception e2) {
                    this.domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
                }
            }
        }
        if (principal != null) {
            if (isUser) {
                this.mainPrincipal = principal;
            }
            this.principals.add(principal);
        }
    }

    public Subject(Subject subject) {
        this.description = subject.getDescription();
        this.domainName = subject.getDomainName();
        this.mainPrincipal = subject.getPrincipal();
        this.principals = (CopyOnWriteLinkedHashSet)((CopyOnWriteLinkedHashSet)subject.getPrincipals()).clone();
        this.publicCredentials = (CopyOnWriteHashSet)((CopyOnWriteHashSet)subject.getPublicCredentials()).clone();
        this.privateCredentials = (CopyOnWriteHashSet)((CopyOnWriteHashSet)subject.getPrivateCredentials()).clone();
        this.credentialFactories = (CopyOnWriteHashSet)((CopyOnWriteHashSet)subject.getCredentialFactories()).clone();
        if (subject.getPasswordInfos() != null) {
            this.passwordInfos = (CopyOnWriteHashSet)((CopyOnWriteHashSet)subject.getPasswordInfos()).clone();
        }
    }

    public Principal getPrincipal() {
        return this.mainPrincipal;
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public Set getPrincipals(Class c) {
        if (c == null) {
            throw new NullPointerException("invalid null Class provided");
        }
        HashSet principalSet = new HashSet();
        for (Object next : this.principals) {
            if (next.getClass().equals(c)) continue;
            principalSet.add(next);
        }
        return principalSet;
    }

    public Set getCredentials() {
        HashSet result = this.getPrivateCredentials();
        if (this.getPublicCredentials().size() > 0) {
            result = new HashSet();
            result.addAll(this.getPrivateCredentials());
            result.addAll(this.getPublicCredentials());
        }
        return result;
    }

    public Set getCredentials(Class type) {
        Iterator creds = this.getCredentials().iterator();
        HashSet result = new HashSet();
        while (creds.hasNext()) {
            Object cred = creds.next();
            if (!type.isAssignableFrom(cred.getClass())) continue;
            result.add(cred);
        }
        return result;
    }

    public String getPassword() {
        Iterator iter = this.getPrivateCredentials(Password.class).iterator();
        if (iter.hasNext()) {
            Password password = (Password)iter.next();
            return password.getPassword();
        }
        return "no_pass";
    }

    public Password getPasswordObject() {
        Iterator iter = this.getPrivateCredentials(Password.class).iterator();
        if (iter.hasNext()) {
            return (Password)iter.next();
        }
        Iterator credFactories = this.credentialFactories.iterator();
        if (credFactories.hasNext()) {
            CredentialFactory factory = (CredentialFactory)credFactories.next();
            try {
                return (Password)factory.getCredential();
            }
            catch (CredentialFactoryException e) {
                return new Password("no_pass");
            }
        }
        return new Password("no_pass");
    }

    public String getOriginPassword() throws CredentialFactoryException {
        Iterator credFactories = this.credentialFactories.iterator();
        if (credFactories.hasNext()) {
            CredentialFactory factory = (CredentialFactory)credFactories.next();
            Password password = (Password)factory.getCredential();
            String algorithm = password.getAlgorithm();
            if (algorithm != null) {
                return "{" + algorithm + "}" + password.getPassword();
            }
            return password.getPassword();
        }
        return "no_pass";
    }

    public synchronized void add(Subject subjectToAdd) {
        Set tempSet;
        if (subjectToAdd == null || subjectToAdd == this) {
            return;
        }
        if (subjectToAdd.getPrincipal() != null) {
            this.mainPrincipal = subjectToAdd.getPrincipal();
        }
        if (!subjectToAdd.getDescription().equals("No description")) {
            this.setDescription(subjectToAdd.getDescription());
        }
        if (subjectToAdd.getPrincipals().size() > 0) {
            this.getPrincipals().addAll((CopyOnWriteLinkedHashSet)((CopyOnWriteLinkedHashSet)subjectToAdd.getPrincipals()).clone());
        }
        if (subjectToAdd.getPublicCredentials().size() > 0) {
            this.getPublicCredentials().addAll((CopyOnWriteHashSet)((CopyOnWriteHashSet)subjectToAdd.getPublicCredentials()).clone());
        }
        if (subjectToAdd.getPrivateCredentials().size() > 0) {
            this.getPrivateCredentials().addAll((CopyOnWriteHashSet)((CopyOnWriteHashSet)subjectToAdd.getPrivateCredentials()).clone());
        }
        if (subjectToAdd.getCredentialFactories().size() > 0) {
            this.getCredentialFactories().addAll((CopyOnWriteHashSet)((CopyOnWriteHashSet)subjectToAdd.getCredentialFactories()).clone());
        }
        if ((tempSet = subjectToAdd.getPasswordInfos()) != null && tempSet.size() > 0) {
            if (this.passwordInfos == null) {
                this.passwordInfos = new CopyOnWriteHashSet();
            }
            this.passwordInfos.addAll((CopyOnWriteHashSet)((CopyOnWriteHashSet)tempSet).clone());
        }
    }

    public synchronized void remove(Subject subjectToRemove) {
        if (subjectToRemove == null) {
            return;
        }
        if (subjectToRemove == this) {
            this.principals.clear();
            this.privateCredentials.clear();
            this.publicCredentials.clear();
            this.credentialFactories.clear();
            this.mainPrincipal = null;
            this.description = "No description";
            this.clearPasswordInfos();
        } else {
            this.description = subjectToRemove.getDescription();
            if (this.principals.size() > 1) {
                this.getPrincipals().removeAll((CopyOnWriteLinkedHashSet)((CopyOnWriteLinkedHashSet)subjectToRemove.getPrincipals()).clone());
            }
            this.getPublicCredentials().removeAll((CopyOnWriteHashSet)((CopyOnWriteHashSet)subjectToRemove.getPublicCredentials()).clone());
            this.getPrivateCredentials().removeAll((CopyOnWriteHashSet)((CopyOnWriteHashSet)subjectToRemove.getPrivateCredentials()).clone());
            this.getCredentialFactories().removeAll((CopyOnWriteHashSet)((CopyOnWriteHashSet)subjectToRemove.getCredentialFactories()).clone());
            Set tempSet = subjectToRemove.getPasswordInfos();
            if (tempSet != null && tempSet.size() > 0 && this.passwordInfos != null) {
                this.passwordInfos.removeAll((CopyOnWriteHashSet)((CopyOnWriteHashSet)tempSet).clone());
                if (this.passwordInfos.isEmpty()) {
                    this.passwordInfos = null;
                }
            }
        }
    }

    public void setDescription(String desc) {
        if (desc != null) {
            this.description = desc;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Set getPrivateCredentials() {
        return this.privateCredentials;
    }

    public Set getPublicCredentials() {
        return this.publicCredentials;
    }

    public javax.security.auth.Subject toJAASSubject() throws SecurityException {
        javax.security.auth.Subject sub = new javax.security.auth.Subject();
        SerializedSubjectPrincipal p = new SerializedSubjectPrincipal(this.serialize());
        sub.getPrincipals().add(p);
        sub.getPrincipals().addAll((CopyOnWriteLinkedHashSet)((CopyOnWriteLinkedHashSet)this.getPrincipals()).clone());
        sub.getPrivateCredentials().addAll((CopyOnWriteHashSet)((CopyOnWriteHashSet)this.getPrivateCredentials()).clone());
        sub.getPublicCredentials().addAll((CopyOnWriteHashSet)((CopyOnWriteHashSet)this.getPublicCredentials()).clone());
        return sub;
    }

    public static Subject fromJAASSubject(javax.security.auth.Subject jaasSubject) throws ServiceException {
        if (SecurityInstaller.isSecurityOff()) {
            return AnonymousSubject.singleton;
        }
        return Subject.fromJAASSubject(jaasSubject, null);
    }

    public static Subject fromJAASSubject(javax.security.auth.Subject jaasSubject, String domainName) throws ServiceException {
        if (SecurityInstaller.isSecurityOff()) {
            return AnonymousSubject.singleton;
        }
        Subject subject = null;
        Set<SerializedSubjectPrincipal> serSubjects = jaasSubject.getPrincipals(SerializedSubjectPrincipal.class);
        if (serSubjects != null && serSubjects.size() > 0) {
            SerializedSubjectPrincipal ssp = serSubjects.iterator().next();
            subject = Subject.deserialize(ssp.getBytes());
        }
        if (subject == null) {
            subject = jaasSubject.getPrincipals().size() > 0 ? new Subject(domainName, jaasSubject.getPrincipals().iterator().next()) : new Subject(domainName);
        }
        subject.getPrincipals().addAll(jaasSubject.getPrincipals());
        subject.getPrivateCredentials().addAll(jaasSubject.getPrivateCredentials());
        subject.getPublicCredentials().addAll(jaasSubject.getPublicCredentials());
        return subject;
    }

    public Object clone() {
        return new Subject(this);
    }

    public void clear() {
        this.remove(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof Subject) {
            Subject si = (Subject)o;
            Set thisPrincipals = this.getPrincipals(SerializedSubjectPrincipal.class);
            Set otherPrincipals = si.getPrincipals(SerializedSubjectPrincipal.class);
            return this.getDomainName().equals(si.getDomainName()) && this.getDescription().equals(si.getDescription()) && ((Object)thisPrincipals).equals(otherPrincipals) && ((Object)this.getCredentialFactories()).equals(si.getCredentialFactories()) && ((Object)this.getPrivateCredentials()).equals(si.getPrivateCredentials()) && ((Object)this.getPublicCredentials()).equals(si.getPublicCredentials()) && (this.getPrincipal() != null && ((Object)this.getPrincipal()).equals(si.getPrincipal()) || this.getPrincipal() == null && si.getPrincipal() == null);
        }
        return false;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        if (domainName == null) {
            return;
        }
        this.domainName = domainName;
    }

    public int hashCode() {
        if (this.getPrincipal() != null) {
            return this.getDomainName().hashCode() + ((Object)this.getPrincipal()).hashCode();
        }
        return this.getDomainName().hashCode();
    }

    public Set getCredentialFactories() {
        return this.credentialFactories;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[SUBJECT]");
        buf.append(Constants.NEWLINE);
        buf.append("Description: ");
        buf.append(this.getDescription());
        buf.append(Constants.NEWLINE);
        buf.append("Domain: ");
        buf.append(this.getDomainName());
        buf.append(Constants.NEWLINE);
        buf.append("Main principal: ");
        buf.append(this.getPrincipal());
        buf.append(Constants.NEWLINE);
        buf.append("Principals: ");
        this.setToStringBuffer(this.getPrincipals(), buf);
        buf.append(Constants.NEWLINE);
        buf.append("Public credentials: ");
        this.setToStringBuffer(this.getPublicCredentials(), buf);
        buf.append(Constants.NEWLINE);
        buf.append("Private credentials: ");
        this.setToStringBuffer(this.getPrivateCredentials(), buf);
        buf.append(Constants.NEWLINE);
        buf.append("Credential factories: ");
        this.setToStringBuffer(this.getCredentialFactories(), buf);
        buf.append(Constants.NEWLINE);
        return buf.toString();
    }

    private void setToStringBuffer(Set set, StringBuffer buf) {
        buf.append("[");
        Object[] obj = set.toArray();
        for (int i = 0; i < obj.length; ++i) {
            buf.append(obj[i]);
            buf.append(",");
        }
        int j = buf.toString().lastIndexOf(",");
        if (obj.length > 0 && j > 0) {
            buf.deleteCharAt(j);
        }
        buf.append("]");
    }

    public synchronized void refresh() throws Exception {
        Iterator credFactories = this.credentialFactories.iterator();
        this.privateCredentials.clear();
        this.publicCredentials.clear();
        while (credFactories.hasNext()) {
            CredentialFactory factory = (CredentialFactory)credFactories.next();
            if (factory.isPublicCredential()) {
                this.getPublicCredentials().add(factory.getCredential());
                continue;
            }
            this.getPrivateCredentials().add(factory.getCredential());
        }
    }

    public synchronized void addPasswordToPrivateCredentials() {
        Iterator refs = this.getPasswordInfos().iterator();
        while (refs.hasNext()) {
            String password;
            String onlyPassword = password = (String)refs.next();
            String algorithm = null;
            if (password.startsWith("{")) {
                int endIdx = password.indexOf("}");
                try {
                    algorithm = password.substring(1, endIdx);
                    if (EncryptionUtil.checkAlgorithm(algorithm)) {
                        onlyPassword = password.substring(endIdx + 1);
                    }
                }
                catch (StringIndexOutOfBoundsException se) {
                    se.printStackTrace();
                }
            }
            this.getPrivateCredentials().add(new Password(algorithm, onlyPassword));
        }
    }

    public static Subject makeSubject(String username) {
        if (SecurityInstaller.isSecurityOff()) {
            return AnonymousSubject.singleton;
        }
        return Subject.makeSubject(username, null, false);
    }

    public static Subject makeSubject(String username, String password) {
        if (SecurityInstaller.isSecurityOff()) {
            return AnonymousSubject.singleton;
        }
        return Subject.makeSubject(username, password, false);
    }

    public static Subject makeAnonymousSubject() {
        return new AnonymousSubject();
    }

    public static Subject makeSubject(String domainName, String username, String password) {
        if (SecurityInstaller.isSecurityOff()) {
            return AnonymousSubject.singleton;
        }
        return Subject.makeSubject(domainName, username, password, false);
    }

    public static Subject makeSubject(String username, String password, boolean factory) {
        if (SecurityInstaller.isSecurityOff()) {
            return AnonymousSubject.singleton;
        }
        return Subject.makeSubject(null, username, password, factory);
    }

    public static Subject makeSubject(String domainName, String username, String password, boolean factory) {
        if (SecurityInstaller.isSecurityOff()) {
            return AnonymousSubject.singleton;
        }
        Subject sub = new Subject(domainName, new PrincipalImpl(username));
        if (password != null) {
            DefaultPasswordFactory fact;
            block5: {
                fact = new DefaultPasswordFactory(password);
                try {
                    sub.getPrivateCredentials().add(fact.getCredential());
                }
                catch (Exception e) {
                    if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._9_LEVEL)) break block5;
                    LoggerUtil.logger.log(JeusMessage_Security._9_LEVEL, JeusMessage_Security._9, (Throwable)e);
                }
            }
            if (factory) {
                sub.getCredentialFactories().add(fact);
            }
        }
        return sub;
    }

    public static Subject makeSubject(String domainName, String username, String password, String algorithm) {
        if (!EncryptionUtil.checkAlgorithm(algorithm)) {
            return Subject.makeSubject(domainName, username, password, true);
        }
        if (SecurityInstaller.isSecurityOff()) {
            return AnonymousSubject.singleton;
        }
        Subject sub = new Subject(domainName, new PrincipalImpl(username));
        if (password != null) {
            DefaultPasswordFactory fact;
            block5: {
                fact = new DefaultPasswordFactory(algorithm, password);
                try {
                    sub.getPrivateCredentials().add(fact.getCredential());
                }
                catch (Exception e) {
                    if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._9_LEVEL)) break block5;
                    LoggerUtil.logger.log(JeusMessage_Security._9_LEVEL, JeusMessage_Security._9, (Throwable)e);
                }
            }
            sub.getCredentialFactories().add(fact);
        }
        return sub;
    }

    public byte[] serialize() throws SecurityException {
        try {
            ByteArrayOutputStream bytesOutput = new ByteArrayOutputStream(4096);
            DataOutputStream output = new DataOutputStream(bytesOutput);
            if (this.getPublicCredentials().isEmpty()) {
                output.write(3);
                String domain = this.getDomainName();
                String principal = this.getPrincipal().getName();
                Password passwordObj = this.getPasswordObject();
                String password = passwordObj.getPassword();
                String algorithm = passwordObj.getAlgorithm();
                output.writeInt(domain.length());
                output.writeBytes(domain);
                output.writeInt(principal.length());
                output.writeBytes(principal);
                output.write(NetworkUtil.getAlgorithmType(algorithm));
                output.writeInt(password.length());
                output.writeBytes(password);
                if (SystemPassword.getSystemPassword().equals(password)) {
                    output.writeBoolean(true);
                } else {
                    output.writeBoolean(false);
                }
            } else {
                output.writeByte(4);
                byte[] subjectSer = Serializer.serializeStatic((Object)this);
                output.writeInt(subjectSer.length);
                output.write(subjectSer);
            }
            return bytesOutput.toByteArray();
        }
        catch (Throwable e) {
            throw new SecurityException("Exception occurred during serialization", e);
        }
    }

    public static Subject deserialize(byte[] bytes) throws ServiceException {
        if (bytes == null || bytes.length == 0) {
            return AnonymousSubject.singleton;
        }
        Subject subj = null;
        try {
            ByteArrayInputStream bytesInput = new ByteArrayInputStream(bytes);
            DataInputStream input = new DataInputStream(bytesInput);
            byte subjectType = input.readByte();
            if (subjectType == 1) {
                subj = Domain.getAnonymousSubject();
            } else if (subjectType == 2) {
                int size = input.readInt();
                byte[] domain = new byte[size];
                input.readFully(domain);
                subj = Domain.getCodeSubject(new String(domain));
            } else if (subjectType == 3) {
                int size = input.readInt();
                byte[] domain = new byte[size];
                input.readFully(domain);
                size = input.readInt();
                byte[] username = new byte[size];
                input.readFully(username);
                byte algorithmType = input.readByte();
                size = input.readInt();
                byte[] password = new byte[size];
                input.readFully(password);
                boolean systemPasswordFlag = input.readBoolean();
                subj = new Subject(new String(domain), new PrincipalImpl(new String(username)));
                if (systemPasswordFlag) {
                    SystemPassword.initialSystemPassword(subj);
                } else {
                    subj.getPrivateCredentials().add(new Password(NetworkUtil.getAlgorithmType(algorithmType), new String(password)));
                }
            } else if (subjectType == 4) {
                int size = input.readInt();
                byte[] subject = new byte[size];
                input.readFully(subject);
                subj = (Subject)Serializer.deserializeStatic((byte[])subject);
            }
        }
        catch (IOException e) {
            throw new ServiceException("Exception occurred during deserialization", e);
        }
        return subj;
    }

    public String getLoginTrace() {
        return this.trace;
    }

    public void setMainPrincipal(Principal jeusPrincipal) {
        this.mainPrincipal = jeusPrincipal;
    }

    public void setLoginTrace(String trace) {
        this.trace = trace;
    }

    public void addPasswordInfo(String password) {
        if (this.passwordInfos == null) {
            this.passwordInfos = new CopyOnWriteHashSet();
        }
        this.passwordInfos.add(password);
    }

    public Set getPasswordInfos() {
        return this.passwordInfos;
    }

    public void clearPasswordInfos() {
        if (this.passwordInfos != null) {
            this.passwordInfos.clear();
            this.passwordInfos = null;
        }
    }

    public synchronized boolean isEmpty() {
        return this.publicCredentials.isEmpty() && this.privateCredentials.isEmpty() && this.credentialFactories.isEmpty() && this.passwordInfos == null;
    }

    public synchronized void removePrincipal(Principal principal) {
        this.principals.remove(principal);
    }

    public Set getPrivateCredentials(Class type) {
        Iterator creds = this.getPrivateCredentials().iterator();
        HashSet result = new HashSet();
        while (creds.hasNext()) {
            Object cred = creds.next();
            if (!type.isAssignableFrom(cred.getClass())) continue;
            result.add(cred);
        }
        return result;
    }

    public Set getPublicCredentials(Class type) {
        Iterator creds = this.getPublicCredentials().iterator();
        HashSet result = new HashSet();
        while (creds.hasNext()) {
            Object cred = creds.next();
            if (!type.isAssignableFrom(cred.getClass())) continue;
            result.add(cred);
        }
        return result;
    }

    private static class SerializedSubjectPrincipal
    implements Principal,
    Serializable {
        private byte[] bytes;

        private SerializedSubjectPrincipal(byte[] bytes) {
            this.bytes = bytes;
        }

        private byte[] getBytes() {
            return this.bytes;
        }

        public String getName() {
            return "SerializedSubject";
        }
    }

    private static class SubjectNameComparator
    implements Comparator {
        private SubjectNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                Subject s1 = (Subject)o1;
                Subject s2 = (Subject)o2;
                return s1.getPrincipal().getName().compareTo(s2.getPrincipal().getName());
            }
            catch (Exception e) {
                return -1;
            }
        }
    }
}

