/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.container.ejb;

import java.io.File;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.xml.soap.SOAPMessage;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.Domain;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.container.shared.J2EESecurityUtil;
import jeus.security.container.shared.SecurityContext;
import jeus.security.impl.atnrep.XMLAccountConverter;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.RoleImpl;
import jeus.security.resource.RolePermission;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.AuthenticationService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JACCUtil;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.xml.binding.j2ee.EjbJarType;
import jeus.xml.binding.j2ee.EjbNameType;
import jeus.xml.binding.j2ee.EnterpriseBeansType;
import jeus.xml.binding.j2ee.EntityBeanType;
import jeus.xml.binding.j2ee.FullyQualifiedClassType;
import jeus.xml.binding.j2ee.HomeType;
import jeus.xml.binding.j2ee.LocalHomeType;
import jeus.xml.binding.j2ee.LocalType;
import jeus.xml.binding.j2ee.RemoteType;
import jeus.xml.binding.j2ee.SessionBeanType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;
import jeus.xml.binding.jeusDD.UnspecifiedMethodPermissionType;

public class EJBSecurity {
    private static Map subjectsTableForRemove = new Hashtable();

    public static void setEJBSecurityContext(String policyId, Object ejbBean, Object[] ejbArgs, SOAPMessage soapMessage) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        SecurityContext sc = J2EESecurityUtil.getSecurityContext();
        sc.put("jeus.security.policyid", policyId);
        if (ejbBean != null) {
            sc.put("javax.ejb.EnterpriseBean", ejbBean);
        }
        if (ejbArgs != null) {
            sc.put("javax.ejb.arguments", ejbArgs);
        } else if (soapMessage != null) {
            sc.put("javax.xml.soap.SOAPMessage", soapMessage);
        }
        EJBSecurity.setCallerIdentity(sc);
        J2EESecurityUtil.pushSecurityContext(sc);
    }

    private static void setCallerIdentity(SecurityContext sc) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        Subject callerSubject = LoginService.getCurrentSubject();
        Principal callerPrincipal = callerSubject.getPrincipal();
        sc.put("jeus.security.caller.subject", callerSubject);
        sc.put("jeus.security.caller.principal", callerPrincipal);
    }

    public static void clearEJBSecurityContext() {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        J2EESecurityUtil.popSecurityContext();
    }

    public static void checkEJBMethodPermission(EJBMethodPermission perm) throws ServiceException, SecurityException {
        LoginService.checkPermission((String)J2EESecurityUtil.peekSecurityContext().get("jeus.security.policyid"), (Permission)perm);
    }

    public static void checkEJBRolePermission(String policyId, String domainName, String principalName, String roleName) throws ServiceException, SecurityException {
        try {
            LoginService.login(new Subject(domainName, new PrincipalImpl(principalName)), true);
            LoginService.checkPermission(policyId, new RolePermission(roleName));
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (SecurityException se) {
            throw se;
        }
        finally {
            LoginService.logout();
        }
    }

    public static void checkEJBRolePermission(String policyId, Subject subject, String roleName) throws ServiceException, SecurityException {
        try {
            LoginService.login(subject, true);
            LoginService.checkPermission(policyId, new RolePermission(roleName));
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (SecurityException se) {
            throw se;
        }
        finally {
            LoginService.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkEJBCallerInRole(EJBRoleRefPermission perm) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        boolean loggedIn = false;
        try {
            SecurityContext sc = J2EESecurityUtil.peekSecurityContext();
            Subject caller = (Subject)sc.get("jeus.security.caller.subject");
            LoginService.login(caller);
            loggedIn = true;
            LoginService.checkPermission((String)sc.get("jeus.security.policyid"), (Permission)perm);
        }
        finally {
            if (loggedIn) {
                LoginService.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkEJBRunasCallerInRole(EJBRoleRefPermission perm) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        boolean loggedIn = false;
        try {
            SecurityContext sc = J2EESecurityUtil.peekRunasSecurityContext();
            Subject caller = (Subject)sc.get("jeus.security.caller.subject");
            LoginService.login(caller);
            loggedIn = true;
            LoginService.checkPermission((String)sc.get("jeus.security.policyid"), (Permission)perm);
        }
        finally {
            if (loggedIn) {
                LoginService.logout();
            }
        }
    }

    public static Principal getEJBCallerPrincipal() {
        try {
            SecurityContext sc = J2EESecurityUtil.peekSecurityContext();
            if (sc == null) {
                return AnonymousSubject.ANONYMOUS_PRINCIPAL;
            }
            return (Principal)sc.get("jeus.security.caller.principal");
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._10_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._10_LEVEL, JeusMessage_Security._10, (Throwable)e);
            }
            return null;
        }
    }

    public static Principal getEJBRunasCallerPrincipal() {
        try {
            SecurityContext sc = J2EESecurityUtil.peekRunasSecurityContext();
            if (sc == null) {
                return AnonymousSubject.ANONYMOUS_PRINCIPAL;
            }
            return (Principal)sc.get("jeus.security.caller.principal");
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._10_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._10_LEVEL, JeusMessage_Security._10, (Throwable)e);
            }
            e.printStackTrace();
            return null;
        }
    }

    public static void setEJBRunAsIdentity(String name) throws ServiceException, SecurityException {
        Subject subject = new Subject(new PrincipalImpl(name));
        EJBSecurity.setEJBRunAsIdentity(subject);
    }

    public static void setEJBRunAsIdentity(String domainName, String name) throws ServiceException, SecurityException {
        Subject subject = new Subject(domainName, new PrincipalImpl(name));
        EJBSecurity.setEJBRunAsIdentity(subject);
    }

    public static void setEJBRunAsIdentity(Subject sub) throws ServiceException, SecurityException {
        LoginService.login(sub, true);
    }

    public static void clearEJBRunAsIdentity() throws ServiceException, SecurityException {
        LoginService.logout();
    }

    public static Object runEJBBusinessCode(Object instance, Method m, Object[] args) throws Throwable {
        return J2EESecurityUtil.runCode(instance, m, args);
    }

    public static void addEJBPolicy(ModuleInfo moduleInfo, String domainName) throws Exception {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        Policy ejbDPC = J2EESecurityUtil.makePolicy(moduleInfo, domainName);
        PermissionMap pc = ejbDPC.getResourcePolicy(moduleInfo.getAppName());
        EJBSecurity.completePolicyContext(pc, moduleInfo);
        J2EESecurityUtil.addPolicy(ejbDPC, domainName);
    }

    public static void addEJBPolicyToApp(ModuleInfo moduleInfo, Policy appDPC) throws Exception {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        Policy ejbDPC = J2EESecurityUtil.makePolicy(moduleInfo, moduleInfo.getSecurityDomain());
        PermissionMap pc = ejbDPC.getResourcePolicy(moduleInfo.getAppName());
        EJBSecurity.completePolicyContext(pc, moduleInfo);
        appDPC.add(ejbDPC);
    }

    private static void completePolicyContext(PermissionMap pc, ModuleInfo moduleInfo) {
        boolean unchecked;
        JeusEjbDdType jeusJaxbTree = moduleInfo.getRuntimeDD();
        String[] roles = EJBSecurity.getDefaultRoles(jeusJaxbTree);
        boolean excluded = EJBSecurity.getDefaultExcluded(jeusJaxbTree);
        if (!excluded & !(unchecked = EJBSecurity.getDefaultUnchecked(jeusJaxbTree)) && (roles == null || roles.length == 0)) {
            EJBSecurity.completePolicyContext(pc, null, false, true, moduleInfo);
        } else {
            EJBSecurity.completePolicyContext(pc, roles, excluded, unchecked, moduleInfo);
        }
    }

    public static void removeEJBPolicy(String policyId, String domainName) throws Exception {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        J2EESecurityUtil.removePolicy(policyId, domainName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEJBSubjectsToApp(String domainName, String key, String path) throws ServiceException {
        Subject[] subjects;
        XMLAccountConverter conv;
        File theFile = new File(path + File.separator + "accounts.xml");
        if (!theFile.exists()) {
            return;
        }
        if (domainName == null) {
            domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
        } else if (domainName.equals("SYSTEM_DOMAIN")) {
            return;
        }
        try {
            conv = new XMLAccountConverter(domainName);
        }
        catch (Exception e) {
            return;
        }
        try {
            subjects = (Subject[])conv.unmarshal(theFile);
        }
        catch (Exception e) {
            throw new ServiceException(e.toString());
        }
        try {
            LoginService.loginCodeSubject(domainName);
            AuthenticationRepositoryService.addSubjects(domainName, subjects, false);
        }
        catch (SecurityException se) {
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (Exception e) {}
        }
        subjectsTableForRemove.put(domainName + ":" + key, subjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEJBSubjectsFromApp(String domainName, String key) throws ServiceException {
        if (domainName == null) {
            domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
        } else if (domainName.equals("SYSTEM_DOMAIN")) {
            return;
        }
        Subject[] subjects = (Subject[])subjectsTableForRemove.remove(domainName + ":" + key);
        if (subjects == null) {
            return;
        }
        try {
            LoginService.loginCodeSubject(domainName);
            AuthenticationRepositoryService.removeSubjects(domainName, subjects, false);
        }
        catch (SecurityException se) {
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (Exception e) {}
        }
    }

    public static Subject logoutEJBSubject() throws ServiceException, SecurityException {
        return LoginService.logout();
    }

    public static void loginEJBSubject(Subject subject) throws ServiceException, SecurityException {
        LoginService.login(subject);
    }

    public static void loginEJBSubject(String domainName, byte[] subject) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        if (domainName == null) {
            domainName = SecurityInstaller.getEnvironment().defaultDomainName;
        }
        Subject sub = Subject.deserialize(subject);
        sub.setDomainName(domainName);
        LoginService.login(sub);
    }

    public static void loginEJBCaller(String username, String password) throws ServiceException, SecurityException {
        EJBSecurity.loginEJBCaller(null, username, password);
    }

    public static void loginEJBCaller(String domainName, String username, String password) throws ServiceException, SecurityException {
        Subject sub;
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        if (domainName == null) {
            domainName = SecurityInstaller.getEnvironment().defaultDomainName;
        }
        try {
            sub = Subject.makeSubject(domainName, username, password);
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating Subject in loginEJBCaller", e);
        }
        LoginService.login(sub);
    }

    public static void loginEJBSubject(byte[] subject) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        Subject s = Subject.deserialize(subject);
        LoginService.login(s);
    }

    public static Subject getCurrentEJBSubject() throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return AnonymousSubject.singleton;
        }
        return LoginService.getLatestUserSubject();
    }

    public static Principal getCurrentEJBPrincipal() throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return AnonymousSubject.ANONYMOUS_PRINCIPAL;
        }
        return LoginService.getCurrentPrincipal();
    }

    public static void authenticate(Subject subject, boolean trusted) throws ServiceException, SecurityException {
        AuthenticationService.authenticate(subject, trusted);
    }

    private static boolean implies(Collection permissionCollection, Permission p) {
        for (Permission collectionP : permissionCollection) {
            if (!collectionP.implies(p)) continue;
            return true;
        }
        return false;
    }

    private static void completePolicyContext(PermissionMap pc, EjbJarType j2eeJaxbTree, JeusEjbDdType jeusJaxbTree, ClassLoader ejbClassLoader) {
        boolean unchecked;
        String[] roles = EJBSecurity.getDefaultRoles(jeusJaxbTree);
        boolean excluded = EJBSecurity.getDefaultExcluded(jeusJaxbTree);
        if (!excluded & !(unchecked = EJBSecurity.getDefaultUnchecked(jeusJaxbTree)) && (roles == null || roles.length == 0)) {
            EJBSecurity.completePolicyContext(pc, j2eeJaxbTree, null, false, true, ejbClassLoader);
        } else {
            EJBSecurity.completePolicyContext(pc, j2eeJaxbTree, roles, excluded, unchecked, ejbClassLoader);
        }
    }

    private static void completePolicyContext(PermissionMap pc, String[] roles, boolean excluded, boolean unchecked, ModuleInfo moduleInfo) {
        List<BeanInfo> beanInfos = moduleInfo.getAllModule();
        for (int i = 0; i < beanInfos.size(); ++i) {
            EJBSecurity.completePolicyContext(pc, beanInfos.get(i), roles, excluded, unchecked, moduleInfo.getLoader());
        }
    }

    private static void completePolicyContext(PermissionMap pc, EjbJarType j2eeJaxbTree, String[] roles, boolean excluded, boolean unchecked, ClassLoader ejbClassLoader) {
        if (j2eeJaxbTree == null) {
            return;
        }
        EnterpriseBeansType enterpriseBeans = j2eeJaxbTree.getEnterpriseBeans();
        if (enterpriseBeans != null) {
            List obj = enterpriseBeans.getSessionOrEntityOrMessageDriven();
            for (int i = 0; i < obj.size(); ++i) {
                LocalType local;
                RemoteType remote;
                LocalHomeType localHome;
                HomeType home;
                EjbNameType name;
                EntityBeanType bean;
                Object o = obj.get(i);
                if (o instanceof EntityBeanType) {
                    bean = (EntityBeanType)o;
                    name = bean.getEjbName();
                    home = bean.getHome();
                    localHome = bean.getLocalHome();
                    remote = bean.getRemote();
                    local = bean.getLocal();
                    EJBSecurity.completePolicyContext(pc, name, home, localHome, remote, local, null, roles, excluded, unchecked, ejbClassLoader);
                    continue;
                }
                if (!(o instanceof SessionBeanType)) continue;
                bean = (SessionBeanType)o;
                name = bean.getEjbName();
                home = bean.getHome();
                localHome = bean.getLocalHome();
                remote = bean.getRemote();
                local = bean.getLocal();
                EJBSecurity.completePolicyContext(pc, name, home, localHome, remote, local, bean.getServiceEndpoint(), roles, excluded, unchecked, ejbClassLoader);
            }
        }
    }

    private static void completePolicyContext(PermissionMap pc, BeanInfo beanInfo, String[] roles, boolean excluded, boolean unchecked, ClassLoader ejbClassLoader) {
        String name = beanInfo.getBeanName();
        if (name != null) {
            String serviceEndpoint;
            SessionBeanInfo sessionBeanInfo;
            String local;
            String remote;
            String localHome;
            EJBSecurity.completePolicyContextWithUnspecifiedMethodInfo(pc, name, roles, excluded, unchecked);
            String home = beanInfo.getEJBHomeClassName();
            if (home != null) {
                EJBSecurity.completePolicyContext(pc, name, "Home", home, roles, excluded, unchecked, ejbClassLoader);
            }
            if ((localHome = beanInfo.getEJBLocalHomeClassName()) != null) {
                EJBSecurity.completePolicyContext(pc, name, "LocalHome", localHome, roles, excluded, unchecked, ejbClassLoader);
            }
            if ((remote = beanInfo.getEJBObjectClassName()) != null) {
                EJBSecurity.completePolicyContext(pc, name, "Remote", remote, roles, excluded, unchecked, ejbClassLoader);
            }
            if ((local = beanInfo.getEJBLocalObjectClassName()) != null) {
                EJBSecurity.completePolicyContext(pc, name, "Local", local, roles, excluded, unchecked, ejbClassLoader);
            }
            if (beanInfo instanceof SessionBeanInfo) {
                sessionBeanInfo = (SessionBeanInfo)beanInfo;
                Class[] localIntfs = sessionBeanInfo.getLocalBusinessInterfaces();
                for (int i = 0; i < localIntfs.length; ++i) {
                    EJBSecurity.completePolicyContext(pc, name, "Local", localIntfs[i], roles, excluded, unchecked);
                }
                Class[] remoteIntfs = sessionBeanInfo.getRemoteBusinessInterfaces();
                for (int j = 0; j < remoteIntfs.length; ++j) {
                    EJBSecurity.completePolicyContext(pc, name, "Remote", remoteIntfs[j], roles, excluded, unchecked);
                }
            }
            if (beanInfo instanceof SessionBeanInfo && (serviceEndpoint = (sessionBeanInfo = (SessionBeanInfo)beanInfo).getServiceEndpointClassName()) != null) {
                EJBSecurity.completePolicyContext(pc, name, "ServiceEndpoint", serviceEndpoint, roles, excluded, unchecked, ejbClassLoader);
            }
        }
    }

    private static void completePolicyContext(PermissionMap pc, EjbNameType name, HomeType home, LocalHomeType localHome, RemoteType remote, LocalType local, FullyQualifiedClassType serviceEndpoint, String[] roles, boolean excluded, boolean unchecked, ClassLoader ejbClassLoader) {
        if (name != null) {
            String theName = name.getValue();
            EJBSecurity.completePolicyContextWithUnspecifiedMethodInfo(pc, theName, roles, excluded, unchecked);
            if (home != null) {
                EJBSecurity.completePolicyContext(pc, theName, "Home", home.getValue(), roles, excluded, unchecked, ejbClassLoader);
            }
            if (localHome != null) {
                EJBSecurity.completePolicyContext(pc, theName, "LocalHome", localHome.getValue(), roles, excluded, unchecked, ejbClassLoader);
            }
            if (remote != null) {
                EJBSecurity.completePolicyContext(pc, theName, "Remote", remote.getValue(), roles, excluded, unchecked, ejbClassLoader);
            }
            if (local != null) {
                EJBSecurity.completePolicyContext(pc, theName, "Local", local.getValue(), roles, excluded, unchecked, ejbClassLoader);
            }
            if (serviceEndpoint != null) {
                EJBSecurity.completePolicyContext(pc, theName, "ServiceEndpoint", serviceEndpoint.getValue(), roles, excluded, unchecked, ejbClassLoader);
            }
        }
    }

    private static void completePolicyContextWithUnspecifiedMethodInfo(PermissionMap pc, String beanName, String[] roles, boolean excluded, boolean unchecked) {
        block8: {
            try {
                Permissions perms = new Permissions();
                for (Method method : pc.getUnspecifiedMethodInfo(beanName)) {
                    EJBMethodPermission perm;
                    if (method.getParameterTypes().length == 0 && JACCUtil.isRunningJACCCTS()) {
                        perm = new EJBMethodPermission(beanName, method.getName() + "," + "Local");
                        perms.add((Permission)perm);
                        perm = new EJBMethodPermission(beanName, method.getName() + "," + "LocalHome");
                        perms.add((Permission)perm);
                        perm = new EJBMethodPermission(beanName, method.getName() + "," + "Remote");
                        perms.add((Permission)perm);
                        perm = new EJBMethodPermission(beanName, method.getName() + "," + "Home");
                        perms.add((Permission)perm);
                        perm = new EJBMethodPermission(beanName, method.getName() + "," + "ServiceEndpoint");
                        perms.add((Permission)perm);
                        continue;
                    }
                    perm = new EJBMethodPermission(beanName, "Local", method);
                    perms.add((Permission)perm);
                    perm = new EJBMethodPermission(beanName, "LocalHome", method);
                    perms.add((Permission)perm);
                    perm = new EJBMethodPermission(beanName, "Remote", method);
                    perms.add((Permission)perm);
                    perm = new EJBMethodPermission(beanName, "Home", method);
                    perms.add((Permission)perm);
                    perm = new EJBMethodPermission(beanName, "ServiceEndpoint", method);
                    perms.add((Permission)perm);
                }
                pc.removeUnspecifiedMethods(beanName);
                Enumeration<Permission> unchkPerms = perms.elements();
                Object[] owners = new Object[]{};
                if (roles != null) {
                    owners = new Object[roles.length];
                    for (int i = 0; i < roles.length; ++i) {
                        owners[i] = new RoleImpl(roles[i]);
                    }
                }
                if (unchkPerms.hasMoreElements()) {
                    Collection allPCPerms = pc.getAllPermissions();
                    while (unchkPerms.hasMoreElements()) {
                        Permission p = unchkPerms.nextElement();
                        if (EJBSecurity.implies(allPCPerms, p)) continue;
                        pc.addPermission(p, owners, excluded, unchecked);
                    }
                }
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._11_LEVEL)) break block8;
                LoggerUtil.logger.log(JeusMessage_Security._11_LEVEL, JeusMessage_Security._11, (Throwable)e);
            }
        }
    }

    private static void completePolicyContext(PermissionMap pc, String beanName, String intfType, Class c, String[] roles, boolean excluded, boolean unchecked) {
        block6: {
            try {
                Permissions perms = new Permissions();
                Enumeration<Permission> unchkPerms = EJBSecurity.makeEJBMethodPermissions(perms, beanName, intfType, c).elements();
                Object[] owners = new Object[]{};
                if (roles != null) {
                    owners = new Object[roles.length];
                    for (int i = 0; i < roles.length; ++i) {
                        owners[i] = new RoleImpl(roles[i]);
                    }
                }
                if (unchkPerms.hasMoreElements()) {
                    Collection allPCPerms = pc.getAllPermissions();
                    while (unchkPerms.hasMoreElements()) {
                        Permission p = unchkPerms.nextElement();
                        if (EJBSecurity.implies(allPCPerms, p)) continue;
                        pc.addPermission(p, owners, excluded, unchecked);
                    }
                }
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._11_LEVEL)) break block6;
                LoggerUtil.logger.log(JeusMessage_Security._11_LEVEL, JeusMessage_Security._11, (Throwable)e);
            }
        }
    }

    private static void completePolicyContext(PermissionMap pc, String beanName, String intfType, String intfName, String[] roles, boolean excluded, boolean unchecked, ClassLoader ejbClassLoader) {
        block6: {
            try {
                Permissions perms = new Permissions();
                Class<?> c = ejbClassLoader.loadClass(intfName);
                Enumeration<Permission> unchkPerms = EJBSecurity.makeEJBMethodPermissions(perms, beanName, intfType, c).elements();
                Object[] owners = new Object[]{};
                if (roles != null) {
                    owners = new Object[roles.length];
                    for (int i = 0; i < roles.length; ++i) {
                        owners[i] = new RoleImpl(roles[i]);
                    }
                }
                if (unchkPerms.hasMoreElements()) {
                    Collection allPCPerms = pc.getAllPermissions();
                    while (unchkPerms.hasMoreElements()) {
                        Permission p = unchkPerms.nextElement();
                        if (EJBSecurity.implies(allPCPerms, p)) continue;
                        pc.addPermission(p, owners, excluded, unchecked);
                    }
                }
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._11_LEVEL)) break block6;
                LoggerUtil.logger.log(JeusMessage_Security._11_LEVEL, JeusMessage_Security._11, (Throwable)e);
            }
        }
    }

    private static Permissions makeEJBMethodPermissions(Permissions perms, String beanName, String intfType, Class ejbIntf) {
        try {
            Method[] methods = ejbIntf.getMethods();
            if (methods == null) {
                return perms;
            }
            for (int i = 0; i < methods.length; ++i) {
                EJBMethodPermission perm;
                Method method = methods[i];
                if (method.getParameterTypes().length == 0 && JACCUtil.isRunningJACCCTS()) {
                    perm = new EJBMethodPermission(beanName, method.getName() + "," + intfType);
                    perms.add((Permission)perm);
                    continue;
                }
                perm = new EJBMethodPermission(beanName, intfType, method);
                perms.add((Permission)perm);
            }
            return perms;
        }
        catch (Throwable t) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._37_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._37_LEVEL, JeusMessage_Security._37, t);
            }
            throw new RuntimeException(t);
        }
    }

    private static String[] getDefaultRoles(JeusEjbDdType jeusJaxbTree) {
        if (jeusJaxbTree.getModuleInfo() != null && jeusJaxbTree.getModuleInfo().getUnspecifiedMethodPermission() != null) {
            UnspecifiedMethodPermissionType umpt = jeusJaxbTree.getModuleInfo().getUnspecifiedMethodPermission();
            List roleList = umpt.getRole();
            String[] roles = new String[roleList.size()];
            for (int i = 0; i < roles.length; ++i) {
                roles[i] = (String)roleList.get(i);
            }
            return roles;
        }
        return null;
    }

    private static boolean getDefaultUnchecked(JeusEjbDdType jeusJaxbTree) {
        if (jeusJaxbTree.getModuleInfo() != null && jeusJaxbTree.getModuleInfo().getUnspecifiedMethodPermission() != null) {
            return jeusJaxbTree.getModuleInfo().getUnspecifiedMethodPermission().getUnchecked() != null;
        }
        return false;
    }

    private static boolean getDefaultExcluded(JeusEjbDdType jeusJaxbTree) {
        if (jeusJaxbTree.getModuleInfo() != null && jeusJaxbTree.getModuleInfo().getUnspecifiedMethodPermission() != null) {
            return jeusJaxbTree.getModuleInfo().getUnspecifiedMethodPermission().getExcluded() != null;
        }
        return false;
    }
}

