/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.container.ejb;

import java.security.Permission;
import java.util.Iterator;
import java.util.List;
import jeus.security.base.PermissionMap;
import jeus.security.resource.PrincipalImpl;
import jeus.security.util.Constants;
import jeus.security.util.PermissionMaker;
import jeus.security.util.XMLConverter;
import jeus.xml.binding.jeusDD.EjbModuleInfoType;
import jeus.xml.binding.jeusDD.EmptyType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;
import jeus.xml.binding.jeusDD.RolePermissionType;

public class XMLJEUSEJBDDConverter
extends XMLConverter {
    public XMLJEUSEJBDDConverter() throws Exception {
        super("jeus.xml.binding.jeusDD");
    }

    protected Object fromXMLTree(Object contentTree) throws Exception {
        JeusEjbDdType dd = (JeusEjbDdType)contentTree;
        EjbModuleInfoType modInfo = dd.getModuleInfo();
        return this.getRolePermissionsPC(modInfo);
    }

    private PermissionMap getRolePermissionsPC(EjbModuleInfoType contentTree) throws Exception {
        Iterator rps = contentTree.getRolePermission().iterator();
        PermissionMap pc = new PermissionMap();
        while (rps.hasNext()) {
            RolePermissionType rpt = (RolePermissionType)rps.next();
            String className = rpt.getClassname() == null ? Constants.DEFAULT_PR_PERMISSION_CLASSNAME : rpt.getClassname();
            String role = rpt.getRole();
            String actions = rpt.getActions();
            EmptyType ex = rpt.getExcluded();
            EmptyType un = rpt.getUnchecked();
            Permission p = PermissionMaker.makePermission((String)className, (String)role, (String)actions);
            boolean excluded = false;
            boolean unchecked = false;
            if (ex != null) {
                excluded = true;
            }
            if (un != null) {
                unchecked = true;
            }
            List princeList = rpt.getPrincipal();
            Object[] ps = new Object[princeList.size()];
            Iterator principals = princeList.iterator();
            int i = 0;
            while (principals.hasNext()) {
                String pp = (String)principals.next();
                ps[i++] = new PrincipalImpl(pp);
            }
            pc.addPermission(p, ps, excluded, unchecked);
        }
        return pc;
    }

    protected Object toXMLTree(Object object, Object tree) {
        return null;
    }
}

