/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.container.web;

import java.io.File;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.CodeSubject;
import jeus.security.base.CredentialFactoryException;
import jeus.security.base.Domain;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.container.shared.J2EESecurityUtil;
import jeus.security.container.shared.SecurityContext;
import jeus.security.container.web.XMLJ2EEWebDDConverter;
import jeus.security.container.web.XMLJEUSWebDDConverter;
import jeus.security.impl.atn.DefaultIdentityAssertionService;
import jeus.security.impl.atnrep.XMLAccountConverter;
import jeus.security.impl.verification.PasswordWithMD5VerificationService;
import jeus.security.impl.verification.X509CertificateVerificationService;
import jeus.security.resource.PasswordWithMD5Factory;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.RolePermission;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.xml.binding.j2ee.WebAppType;
import jeus.xml.binding.jeusDD.ContextType;

public class ServletSecurity {
    private static Map subjectsTableForRemove = new Hashtable();

    public static void setServletSecurityContext(String policyId, HttpServletRequest servletRequest) {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        SecurityContext sc = J2EESecurityUtil.getSecurityContext();
        sc.put("jeus.security.policyid", policyId);
        sc.put("javax.servlet.http.HttpServletRequest", servletRequest);
        Subject callerSubject = null;
        try {
            callerSubject = LoginService.getCurrentSubject();
            Principal callerPrincipal = callerSubject.getPrincipal();
            sc.put("jeus.security.caller.subject", callerSubject);
            sc.put("jeus.security.caller.principal", callerPrincipal);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        J2EESecurityUtil.pushSecurityContext(sc);
    }

    public static void clearServletSecurityContext() {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        J2EESecurityUtil.popSecurityContext();
    }

    public static void setServletRunAsIdentity(String name) throws ServiceException, SecurityException {
        Subject subject = new Subject(new PrincipalImpl(name));
        ServletSecurity.setServletRunAsIdentity(subject);
    }

    public static void setServletRunAsIdentity(String domainName, String name) throws ServiceException, SecurityException {
        Subject subject = new Subject(domainName, new PrincipalImpl(name));
        ServletSecurity.setServletRunAsIdentity(subject);
    }

    public static void setServletRunAsIdentity(Subject sub) throws ServiceException, SecurityException {
        LoginService.login(sub, true);
    }

    public static void clearServletRunAsIdentity() throws ServiceException, SecurityException {
        LoginService.logout();
    }

    public static void checkServletAccessPermission(WebResourcePermission perm) throws ServiceException, SecurityException {
        String id = (String)J2EESecurityUtil.peekSecurityContext().get("jeus.security.policyid");
        LoginService.checkPermission(id, (Permission)perm);
    }

    public static void checkServletUserDataPermission(WebUserDataPermission perm) throws ServiceException, SecurityException {
        LoginService.checkPermission((String)J2EESecurityUtil.peekSecurityContext().get("jeus.security.policyid"), (Permission)perm);
    }

    public static void checkServletRolePermission(String policyId, String domainName, String principalName, String roleName) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        try {
            LoginService.login(new Subject(domainName, new PrincipalImpl(principalName)), true);
            LoginService.checkPermission(policyId, new RolePermission(roleName));
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (SecurityException se) {
            throw se;
        }
        finally {
            LoginService.logout();
        }
    }

    public static Principal getServletUserPrincipal() throws ServiceException, SecurityException {
        Subject sub = LoginService.getCurrentSubject();
        if (AnonymousSubject.isAnonymous(sub)) {
            return null;
        }
        return sub.getPrincipal();
    }

    public static Principal getServletRunasUserPrincipal() {
        SecurityContext sc = J2EESecurityUtil.peekRunasSecurityContext();
        if (sc == null) {
            return null;
        }
        return (Principal)sc.get("jeus.security.caller.principal");
    }

    public static void checkServletUserInRole(Permission perm) throws ServiceException, SecurityException {
        LoginService.checkPermission((String)J2EESecurityUtil.peekSecurityContext().get("jeus.security.policyid"), perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkServletRunasUserInRole(Permission perm) throws ServiceException, SecurityException {
        boolean loggedIn = false;
        try {
            SecurityContext sc = J2EESecurityUtil.peekRunasSecurityContext();
            Subject caller = (Subject)sc.get("jeus.security.caller.subject");
            LoginService.login(caller);
            loggedIn = true;
            LoginService.checkPermission((String)sc.get("jeus.security.policyid"), perm);
        }
        finally {
            if (loggedIn) {
                LoginService.logout();
            }
        }
    }

    public static Object runServletBusinessCode(Object servletInstance, Method servletMethod, Object[] methodArgs) throws Throwable {
        return J2EESecurityUtil.runCode(servletInstance, servletMethod, methodArgs);
    }

    public static void addServletPolicy(String policyId, WebAppType j2eeJaxbTree, ContextType jeusJaxbTree, String domainName) throws Exception {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        Policy webDPC = J2EESecurityUtil.makePolicy(policyId, j2eeJaxbTree, jeusJaxbTree, new XMLJ2EEWebDDConverter(), new XMLJEUSWebDDConverter(), domainName);
        J2EESecurityUtil.addPolicy(webDPC, domainName);
    }

    public static void addServletPolicyToApp(String policyId, WebAppType j2eeJaxbTree, ContextType jeusJaxbTree, Policy appDPC, String domainName) throws Exception {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        Policy servletDPC = J2EESecurityUtil.makePolicy(policyId, j2eeJaxbTree, jeusJaxbTree, new XMLJ2EEWebDDConverter(), new XMLJEUSWebDDConverter(), domainName);
        appDPC.add(servletDPC);
    }

    public static void removeServletPolicy(String policyId, String domainName) throws Exception {
        J2EESecurityUtil.removePolicy(policyId, domainName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServletSubjectsToApp(String domainName, String key, String path) throws ServiceException {
        XMLAccountConverter conv = null;
        Subject[] subjects = null;
        File theFile = new File(path + File.separator + "accounts.xml");
        if (!theFile.exists()) {
            return;
        }
        if (domainName == null) {
            domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
        } else if (domainName.equals("SYSTEM_DOMAIN")) {
            return;
        }
        try {
            conv = new XMLAccountConverter(domainName);
        }
        catch (Exception e) {
            return;
        }
        try {
            subjects = (Subject[])conv.unmarshal(theFile);
        }
        catch (Exception e) {
            throw new ServiceException(e.toString());
        }
        try {
            LoginService.loginCodeSubject(domainName);
            AuthenticationRepositoryService.addSubjects(domainName, subjects, false);
        }
        catch (SecurityException se) {
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (Exception e) {}
        }
        subjectsTableForRemove.put(domainName + ":" + key, subjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeServletSubjectsFromApp(String domainName, String key) throws ServiceException {
        if (domainName == null) {
            domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
        } else if (domainName.equals("SYSTEM_DOMAIN")) {
            return;
        }
        Subject[] subjects = (Subject[])subjectsTableForRemove.remove(domainName + ":" + key);
        if (subjects == null) {
            return;
        }
        try {
            LoginService.loginCodeSubject(domainName);
            AuthenticationRepositoryService.removeSubjects(domainName, subjects, false);
        }
        catch (SecurityException se) {
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (Exception e) {}
        }
    }

    public static Subject logoutServletCaller() throws ServiceException, SecurityException {
        return LoginService.logout();
    }

    public static void loginServletCaller(String username, String password) throws ServiceException, SecurityException {
        ServletSecurity.loginServletCaller(null, username, password);
    }

    public static void loginServletCaller(String domainName, String username, String password) throws ServiceException, SecurityException {
        Subject sub;
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        if (domainName == null) {
            domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
        }
        try {
            sub = Subject.makeSubject(domainName, username, password);
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating Subject in loginServletCaller", e);
        }
        LoginService.login(sub);
    }

    public static void loginServletCaller(Subject caller) throws ServiceException, SecurityException {
        LoginService.login(caller);
    }

    public static void loginServletCaller(String domainName, String username, String clientDigest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) throws ServiceException, SecurityException {
        Subject loginUser;
        if (domainName == null) {
            domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
        }
        if (!ServletSecurity.checkDigestService(domainName)) {
            throw new ServiceException("Failed to create or check services associated with the digest");
        }
        try {
            loginUser = Subject.makeSubject(domainName, username, null);
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating Subject in loginServletCaller", e);
        }
        PasswordWithMD5Factory factory = null;
        try {
            factory = new PasswordWithMD5Factory();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        factory.setProperty("password", clientDigest);
        factory.setProperty("nonce", nonce);
        factory.setProperty("nc", nc);
        factory.setProperty("cnonce", cnonce);
        factory.setProperty("qop", qop);
        factory.setProperty("realm", realm);
        factory.setProperty("md5a2", md5a2);
        loginUser.getCredentialFactories().add(factory);
        try {
            loginUser.getPrivateCredentials().add(factory.getCredential());
        }
        catch (CredentialFactoryException e) {
            e.printStackTrace();
            throw new SecurityException("failed to add credentials(" + username + ")");
        }
        loginUser.setDomainName(domainName);
        LoginService.login(loginUser);
    }

    public static void loginServletCaller(String domainName, X509Certificate[] certs) throws ServiceException, SecurityException {
        if (domainName == null) {
            domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
        }
        if (!ServletSecurity.checkClientCertService(domainName)) {
            throw new ServiceException("Failed to create or check services associated with the certificate");
        }
        Subject loginUser = new Subject(domainName, null);
        loginUser.getPublicCredentials().addAll(Arrays.asList(certs));
        loginUser.setDomainName(domainName);
        LoginService.login(loginUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkDigestService(String domainName) {
        Domain domain = null;
        try {
            domain = Domain.getDomain(domainName);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        if (domain.isEnableDigistService()) {
            return true;
        }
        Domain domain2 = domain;
        synchronized (domain2) {
            if (domain.isEnableDigistService()) {
                return true;
            }
            PasswordWithMD5VerificationService service = new PasswordWithMD5VerificationService();
            domain.addService(service);
            try {
                service.create(true);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                domain.removeService(service);
                return false;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                domain.removeService(service);
                return false;
            }
            domain.setEnableDigistService(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkClientCertService(String domainName) {
        Domain domain = null;
        try {
            domain = Domain.getDomain(domainName);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        if (domain.isEnableClientCertService()) {
            return true;
        }
        Domain domain2 = domain;
        synchronized (domain2) {
            if (domain.isEnableClientCertService()) {
                return true;
            }
            X509CertificateVerificationService service = new X509CertificateVerificationService();
            domain.addService(service);
            try {
                service.create(true);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                domain.removeService(service);
                return false;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                domain.removeService(service);
                return false;
            }
            DefaultIdentityAssertionService service2 = new DefaultIdentityAssertionService();
            domain.addService(service2);
            try {
                service2.create(true);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                domain.removeService(service2);
                service.destroy();
                domain.removeService(service);
                return false;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                domain.removeService(service2);
                service.destroy();
                domain.removeService(service);
                return false;
            }
            domain.setEnableClientCertService(true);
        }
        return true;
    }

    public static boolean isCodeSubject() throws SecurityException, ServiceException {
        Subject subject = LoginService.getCurrentSubject();
        return CodeSubject.isCode(subject);
    }

    public static boolean isAnonymousSubject() throws SecurityException, ServiceException {
        return LoginService.getCurrentSubject() instanceof AnonymousSubject;
    }

    public static Subject getCurrentSubject() {
        try {
            return LoginService.getCurrentSubject();
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }
}

