/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.container.web;

import java.security.Permission;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.xml.bind.JAXBElement;
import jeus.security.base.PermissionMap;
import jeus.security.base.Role;
import jeus.security.container.web.HTTPMethod;
import jeus.security.container.web.URLPattern;
import jeus.security.resource.RoleImpl;
import jeus.security.util.XMLConverter;
import jeus.xml.binding.j2ee.AuthConstraintType;
import jeus.xml.binding.j2ee.RoleNameType;
import jeus.xml.binding.j2ee.SecurityConstraintType;
import jeus.xml.binding.j2ee.SecurityRoleRefType;
import jeus.xml.binding.j2ee.SecurityRoleType;
import jeus.xml.binding.j2ee.ServletType;
import jeus.xml.binding.j2ee.TransportGuaranteeType;
import jeus.xml.binding.j2ee.UrlPatternType;
import jeus.xml.binding.j2ee.UserDataConstraintType;
import jeus.xml.binding.j2ee.WebResourceCollectionType;

public class XMLJ2EEWebDDConverter
extends XMLConverter {
    public XMLJ2EEWebDDConverter() throws Exception {
        super("jeus.xml.binding.j2ee");
    }

    protected Object fromXMLTree(Object contentTree) throws Exception {
        jeus.xml.binding.j2ee.WebAppType dd = (jeus.xml.binding.j2ee.WebAppType)contentTree;
        WebAppType app = this.getWebApp(dd);
        PermissionMap pc = new PermissionMap(true);
        this.processWebApp(app, pc);
        return pc;
    }

    protected Object toXMLTree(Object object, Object tree) {
        return null;
    }

    private WebAppType getWebApp(jeus.xml.binding.j2ee.WebAppType app) {
        List items = app.getDescriptionAndDisplayNameAndIcon();
        WebAppType webApp = new WebAppType();
        for (int i = 0; i < items.size(); ++i) {
            Object o = ((JAXBElement)items.get(i)).getValue();
            if (o instanceof ServletType) {
                webApp.addServlet(this.getServlet((ServletType)o));
                continue;
            }
            if (o instanceof SecurityConstraintType) {
                webApp.addSecurityConstraint(this.getSecurityConstraint((SecurityConstraintType)o, webApp));
                continue;
            }
            if (!(o instanceof SecurityRoleType)) continue;
            SecurityRoleType srt = (SecurityRoleType)o;
            RoleNameType rnt = srt.getRoleName();
            webApp.addRole(new RoleImpl(rnt.getValue()));
        }
        return webApp;
    }

    private SecurityConstraint getSecurityConstraint(SecurityConstraintType sct, WebAppType app) {
        UserDataConstraintType udct;
        SecurityConstraint sc = new SecurityConstraint();
        AuthConstraintType act = sct.getAuthConstraint();
        if (act != null) {
            Iterator roles = act.getRoleName().iterator();
            if (!roles.hasNext()) {
                sc.addRole(null);
            } else {
                while (roles.hasNext()) {
                    RoleNameType rnt = (RoleNameType)roles.next();
                    sc.addRole(new RoleImpl(rnt.getValue()));
                }
            }
        }
        if ((udct = sct.getUserDataConstraint()) != null) {
            TransportGuaranteeType tgt = udct.getTransportGuarantee();
            sc.transportGuarantee = tgt.getValue();
        }
        for (WebResourceCollectionType wrct : sct.getWebResourceCollection()) {
            sc.addCollection(this.getWebResourceCollection(wrct, app));
        }
        return sc;
    }

    private WebResourceCollection getWebResourceCollection(WebResourceCollectionType wrct, WebAppType app) {
        Iterator urls = wrct.getUrlPattern().iterator();
        WebResourceCollection wrc = new WebResourceCollection();
        while (urls.hasNext()) {
            UrlPatternType upt = (UrlPatternType)urls.next();
            wrc.addPattern(new URLPattern(upt.getValue()));
            app.addPattern(new URLPattern(upt.getValue()));
        }
        Iterator methods = wrct.getHttpMethod().iterator();
        while (methods.hasNext()) {
            wrc.addMethod(new HTTPMethod((String)methods.next()));
        }
        return wrc;
    }

    private Servlet getServlet(ServletType st) {
        Iterator roleRefs = st.getSecurityRoleRef().iterator();
        Servlet servlet = new Servlet();
        servlet.servletName = st.getServletName().getValue();
        while (roleRefs.hasNext()) {
            SecurityRoleRefType srrt = (SecurityRoleRefType)roleRefs.next();
            SecurityRoleRef srr = new SecurityRoleRef();
            srr.refName = srrt.getRoleName().getValue();
            RoleNameType rnt = srrt.getRoleLink();
            if (rnt != null) {
                srr.role = new RoleImpl(rnt.getValue());
            }
            servlet.addSecurityRoleRef(srr);
        }
        return servlet;
    }

    private void processWebApp(WebAppType webApp, PermissionMap pc) {
        if (webApp == null) {
            return;
        }
        for (SecurityConstraint sc : webApp.securityConstraints) {
            sc.expandRoles(webApp.roles.iterator());
        }
        Iterator servlets = webApp.servlets.iterator();
        HashSet rolesToAddTable = (HashSet)webApp.roles.clone();
        while (servlets.hasNext()) {
            WebRoleRefPermission perm;
            Servlet servlet = (Servlet)servlets.next();
            for (SecurityRoleRef srr : servlet.securityRoleRefs) {
                RoleImpl roleRef = new RoleImpl(srr.refName);
                if (srr.role != null) {
                    perm = new WebRoleRefPermission(servlet.servletName, srr.refName);
                    pc.addPermission((Permission)perm, new Object[]{srr.role}, false, false);
                } else if (webApp.roles.contains(roleRef)) {
                    perm = new WebRoleRefPermission(servlet.servletName, srr.refName);
                    pc.addPermission((Permission)perm, new Object[]{roleRef}, false, false);
                }
                rolesToAddTable.remove(roleRef);
            }
            for (Role role : rolesToAddTable) {
                perm = new WebRoleRefPermission(servlet.servletName, role.getName());
                pc.addPermission((Permission)perm, new Object[]{role}, false, false);
            }
        }
        for (Role role : rolesToAddTable) {
            WebRoleRefPermission perm = new WebRoleRefPermission("", role.getName());
            pc.addPermission((Permission)perm, new Object[]{role}, false, false);
        }
        Hashtable excluded = webApp.getMethodsAndPatterns(0);
        for (URLPattern pattern : excluded.keySet()) {
            Iterator allPatterns = webApp.patterns.iterator();
            String qualification = pattern.getQualifiedPattern(allPatterns);
            String httpMethods = null;
            Object o = excluded.get(pattern);
            if (o != null) {
                httpMethods = ((HTTPMethod)o).getHTTPMethods();
            }
            try {
                WebResourcePermission perm1 = new WebResourcePermission(qualification, httpMethods);
                pc.addPermission((Permission)perm1, null, true, false);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                WebUserDataPermission perm2 = new WebUserDataPermission(qualification, httpMethods);
                pc.addPermission((Permission)perm2, null, true, false);
            }
            catch (Exception e) {}
        }
        Hashtable checked = webApp.getMethodsAndPatterns(2);
        for (Role role : checked.keySet()) {
            Object o = checked.get(role);
            if (o == null) continue;
            Hashtable pattMeth = (Hashtable)o;
            for (URLPattern pattern : pattMeth.keySet()) {
                Iterator allPatterns = webApp.patterns.iterator();
                String qualification = pattern.getQualifiedPattern(allPatterns);
                String httpMethods = null;
                Object o2 = pattMeth.get(pattern);
                if (o2 != null) {
                    httpMethods = ((HTTPMethod)o2).getHTTPMethods();
                }
                try {
                    WebResourcePermission perm = new WebResourcePermission(qualification, httpMethods);
                    pc.addPermission((Permission)perm, new Object[]{role}, false, false);
                }
                catch (Exception e) {}
            }
        }
        Hashtable unchecked = webApp.getMethodsAndPatterns(1);
        for (URLPattern pattern : unchecked.keySet()) {
            Iterator allPatterns = webApp.patterns.iterator();
            String qualification = pattern.getQualifiedPattern(allPatterns);
            String httpMethods = null;
            Object o = unchecked.get(pattern);
            if (o != null) {
                httpMethods = ((HTTPMethod)o).getHTTPMethods();
            }
            try {
                WebResourcePermission perm = new WebResourcePermission(qualification, httpMethods);
                pc.addPermission((Permission)perm, null, false, true);
            }
            catch (Exception e) {}
        }
        Hashtable transportTable = webApp.getMethodsAndPatterns(3);
        for (String transport : transportTable.keySet()) {
            Object o = transportTable.get(transport);
            if (o == null) continue;
            Hashtable pattMeth = (Hashtable)o;
            for (URLPattern pattern : pattMeth.keySet()) {
                Iterator allPatterns = webApp.patterns.iterator();
                String qualification = pattern.getQualifiedPattern(allPatterns);
                String httpMethods = null;
                Object o2 = pattMeth.get(pattern);
                if (o2 != null) {
                    httpMethods = ((HTTPMethod)o2).getHTTPMethods();
                }
                String actions = transport.equals("") && httpMethods == null ? null : (transport.equals("") || transport.equals("NONE") ? httpMethods : (httpMethods == null ? transport : httpMethods + ":" + transport));
                try {
                    WebUserDataPermission perm = new WebUserDataPermission(qualification, actions);
                    pc.addPermission((Permission)perm, null, false, true);
                }
                catch (Exception e) {}
            }
        }
        webApp.addPattern(new URLPattern("/"));
        Hashtable allPatternsInSCTable = webApp.getMethodsAndPatterns(4);
        for (URLPattern pattern : webApp.patterns) {
            Iterator allPatternsInternal = webApp.patterns.iterator();
            String qualification = pattern.getQualifiedPattern(allPatternsInternal);
            Object o = allPatternsInSCTable.get(pattern);
            String httpMethods = null;
            HTTPMethod inverse = null;
            if (o != null) {
                inverse = ((HTTPMethod)o).getInverseHTTPMethod();
                if (inverse == null) continue;
                httpMethods = ((HTTPMethod)o).getInverseHTTPMethods();
            }
            try {
                pc.updateWebUncheckedPermission(qualification, inverse, httpMethods);
            }
            catch (Exception e) {}
        }
    }

    private class WebResourceCollection {
        private HashSet patterns = null;
        private HTTPMethod methods = new HTTPMethod();

        private WebResourceCollection() {
        }

        private void addPattern(URLPattern pattern) {
            if (this.patterns == null) {
                this.patterns = new HashSet();
            }
            this.patterns.add(pattern);
        }

        private void addMethod(HTTPMethod method) {
            this.methods.merge(method);
        }
    }

    private class SecurityConstraint {
        private HashSet roles = null;
        private HashSet collections = null;
        private String transportGuarantee = "";

        private SecurityConstraint() {
        }

        private void addRole(Role role) {
            if (this.roles == null) {
                this.roles = new HashSet();
            }
            if (role != null) {
                this.roles.add(role);
            }
        }

        private void addCollection(WebResourceCollection collection) {
            if (this.collections == null) {
                this.collections = new HashSet();
            }
            this.collections.add(collection);
        }

        private boolean isExcludingAuthConstraint() {
            return this.roles != null && this.roles.size() == 0;
        }

        private boolean isRoleAuthConstraint() {
            return this.roles != null && this.roles.size() > 0;
        }

        private boolean isUncheckedAuthConstraint() {
            return this.roles == null;
        }

        private void expandRoles(Iterator allRoles) {
            if (this.roles == null) {
                return;
            }
            for (Role role : this.roles) {
                if (!role.getName().equals("*")) continue;
                while (allRoles.hasNext()) {
                    Role innerRole = (Role)allRoles.next();
                    this.addRole(innerRole);
                }
                this.roles.remove(role);
                return;
            }
        }
    }

    private class SecurityRoleRef {
        private String refName;
        private Role role;

        private SecurityRoleRef() {
        }
    }

    private class Servlet {
        private String servletName;
        private HashSet securityRoleRefs = new HashSet();

        private Servlet() {
        }

        private void addSecurityRoleRef(SecurityRoleRef ref) {
            if (this.securityRoleRefs == null) {
                this.securityRoleRefs = new HashSet();
            }
            if (ref != null) {
                this.securityRoleRefs.add(ref);
            }
        }
    }

    private class WebAppType {
        private HashSet servlets = new HashSet();
        private HashSet securityConstraints = new HashSet();
        private HashSet roles = new HashSet();
        private HashSet patterns = new HashSet();
        private Hashtable cache = new Hashtable();

        private WebAppType() {
        }

        private void addServlet(Servlet servlet) {
            if (this.servlets == null) {
                this.servlets = new HashSet();
            }
            if (servlet != null) {
                this.servlets.add(servlet);
            }
        }

        private void addPattern(URLPattern pattern) {
            if (this.patterns == null) {
                this.patterns = new HashSet();
            }
            if (pattern != null) {
                this.patterns.add(pattern);
            }
        }

        private void addSecurityConstraint(SecurityConstraint sc) {
            if (this.securityConstraints == null) {
                this.securityConstraints = new HashSet();
            }
            if (sc != null) {
                this.securityConstraints.add(sc);
            }
        }

        private void addRole(Role role) {
            if (this.roles == null) {
                this.roles = new HashSet();
            }
            if (role != null) {
                this.roles.add(role);
            }
        }

        private Iterator getSecurityConstraints(int type) {
            if (this.securityConstraints == null) {
                return null;
            }
            Iterator iter = this.securityConstraints.iterator();
            Vector<SecurityConstraint> v = new Vector<SecurityConstraint>();
            while (iter.hasNext()) {
                SecurityConstraint sc = (SecurityConstraint)iter.next();
                switch (type) {
                    case 0: {
                        if (!sc.isExcludingAuthConstraint()) break;
                        v.add(sc);
                        break;
                    }
                    case 1: {
                        if (!sc.isUncheckedAuthConstraint()) break;
                        v.add(sc);
                        break;
                    }
                    case 2: {
                        if (!sc.isRoleAuthConstraint()) break;
                        v.add(sc);
                        break;
                    }
                    case 3: {
                        if (!sc.isRoleAuthConstraint() && !sc.isUncheckedAuthConstraint()) break;
                        v.add(sc);
                        break;
                    }
                    case 4: {
                        v.add(sc);
                    }
                }
            }
            return v.iterator();
        }

        private Hashtable getMethodsAndPatterns(int type) {
            Object cachedTable = this.cache.get(new Integer(type));
            if (cachedTable != null) {
                return (Hashtable)cachedTable;
            }
            Iterator scs = this.getSecurityConstraints(type);
            Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
            if (scs != null) {
                while (scs.hasNext()) {
                    SecurityConstraint sc = (SecurityConstraint)scs.next();
                    if (sc.collections == null) continue;
                    for (WebResourceCollection wrc : sc.collections) {
                        if (wrc.patterns == null) continue;
                        Iterator patterns = wrc.patterns.iterator();
                        HTTPMethod httpMethods = wrc.methods;
                        while (patterns.hasNext()) {
                            URLPattern up = (URLPattern)patterns.next();
                            if (type == 2) {
                                if (sc.roles == null) continue;
                                for (Role role : sc.roles) {
                                    Hashtable<URLPattern, HTTPMethod> pattMetHT;
                                    Object o = ht.get(role);
                                    if (o == null) {
                                        pattMetHT = new Hashtable<URLPattern, HTTPMethod>();
                                        ht.put(role, pattMetHT);
                                        pattMetHT.put(up, new HTTPMethod(httpMethods));
                                        continue;
                                    }
                                    pattMetHT = (Hashtable<URLPattern, HTTPMethod>)o;
                                    Object o2 = pattMetHT.get(up);
                                    if (o2 == null) {
                                        pattMetHT.put(up, new HTTPMethod(httpMethods));
                                        continue;
                                    }
                                    HTTPMethod ms = (HTTPMethod)o2;
                                    ms.merge(httpMethods);
                                }
                                continue;
                            }
                            if (type == 3) {
                                Hashtable<URLPattern, HTTPMethod> pattMetHT;
                                String transport = sc.transportGuarantee;
                                Object o = ht.get(transport);
                                if (o == null) {
                                    pattMetHT = new Hashtable<URLPattern, HTTPMethod>();
                                    ht.put(transport, pattMetHT);
                                    pattMetHT.put(up, new HTTPMethod(httpMethods));
                                    continue;
                                }
                                pattMetHT = (Hashtable<URLPattern, HTTPMethod>)o;
                                Object o2 = pattMetHT.get(up);
                                if (o2 == null) {
                                    pattMetHT.put(up, new HTTPMethod(httpMethods));
                                    continue;
                                }
                                HTTPMethod ms = (HTTPMethod)o2;
                                ms.merge(httpMethods);
                                continue;
                            }
                            Object o = ht.get(up);
                            if (o == null) {
                                ht.put(up, new HTTPMethod(httpMethods));
                                continue;
                            }
                            HTTPMethod ms = (HTTPMethod)o;
                            ms.merge(httpMethods);
                        }
                    }
                }
            }
            this.cache.put(new Integer(type), ht);
            return ht;
        }
    }
}

