/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atn;

import java.security.cert.X509Certificate;
import javax.management.ObjectName;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.SystemPassword;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.AuthenticationService;
import jeus.security.spi.CredentialMappingService;
import jeus.security.spi.CredentialVerificationService;
import jeus.security.spi.IdentityAssertionService;
import jeus.security.spi.LoginService;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;

public class DefaultAuthenticationService
extends AuthenticationService {
    protected void doCreate() {
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subject doAuthenticate(Subject subject, boolean trusted) throws ServiceException, SecurityException {
        if (subject == null) {
            throw new ServiceException("Authentication failed: Subject is null");
        }
        if (SystemPassword.checkSystemPassword(subject)) {
            return subject;
        }
        String name = null;
        if (subject.getPrincipal() == null) {
            for (Object cred : subject.getCredentials()) {
                try {
                    name = CredentialMappingService.getSubjectName(cred);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (name != null) break;
                if (cred instanceof X509Certificate) {
                    name = (String)IdentityAssertionService.getIdentity(cred);
                }
                if (name == null) continue;
                break;
            }
            if (name == null) {
                throw new ServiceException("Authentication failed: Subject principal not set and could not be deduced through its credentials");
            }
        } else {
            name = subject.getPrincipal().getName();
        }
        Subject candidate = null;
        boolean loggedIn = false;
        try {
            LoginService.loginCodeSubject(subject.getDomainName());
            loggedIn = true;
            candidate = AuthenticationRepositoryService.getSubject(name);
        }
        catch (ServiceException se) {
            if (!trusted) {
                throw new SecurityException("Authentication failed: incorrect username and/or credentials presented", se);
            }
            candidate = subject;
        }
        finally {
            if (loggedIn) {
                LoginService.logout();
            }
        }
        if (trusted) {
            return candidate;
        }
        if (candidate.getPasswordInfos() == null) {
            try {
                candidate.refresh();
            }
            catch (Exception e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._12_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._12_LEVEL, JeusMessage_Security._12, (Throwable)e);
                }
                throw new ServiceException("Authentication failed: internal error occured");
            }
        } else if (candidate.getPasswordInfos() != null) {
            candidate.addPasswordToPrivateCredentials();
        }
        try {
            CredentialVerificationService.verifyCredentials(candidate, subject);
            return candidate;
        }
        catch (SecurityException se) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._13_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._13_LEVEL, JeusMessage_Security._13, (Throwable)se);
            }
            throw new SecurityException("Authentication failed: incorrect username and/or credentials presented");
        }
    }
}

