/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.io.File;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.management.j2ee.security.SubjectMo;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.atnrep.JeusDistributedMemoryAuthenticationRepositoryService;
import jeus.security.impl.atnrep.XMLAccountConverter;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.NameAndPathUtil;

public class FileRealmAuthenticationRepositoryService
extends JeusDistributedMemoryAuthenticationRepositoryService {
    protected SubjectMo subjectMo = null;
    private File theFile;
    private XMLAccountConverter conv;

    protected void doCreate() throws ServiceException, SecurityException {
        super.doCreate();
        String filename = this.getProperty("filename");
        String baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
        if (filename == null) {
            filename = baseDir + NameAndPathUtil.getPathWithEndingSeparator(this.getDomain().getName()) + "accounts.xml";
        }
        this.theFile = new File(filename);
        if (!this.theFile.exists()) {
            this.theFile = new File(baseDir + NameAndPathUtil.getPathWithEndingSeparator("SYSTEM_DOMAIN") + "accounts.xml");
        }
        try {
            this.conv = new XMLAccountConverter(this.getDomain().getName());
            if (this.subjectManager.isSubjectEmpty()) {
                this.refreshRead();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSave() throws ServiceException {
    }

    protected void doDestroy() {
        super.doDestroy();
    }

    public void doRegisterMBean(ObjectName parent) {
        block2: {
            try {
                this.subjectMo = (SubjectMo)SubjectMo.createMBean("Subject", parent, this);
            }
            catch (InstanceAlreadyExistsException e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._7_LEVEL)) break block2;
                LoggerUtil.logger.log(JeusMessage_Security._7_LEVEL, JeusMessage_Security._7, (Throwable)e);
            }
        }
    }

    public Object readSubjectsInRepository() throws ServiceException {
        if ((this.theFile == null || !this.theFile.exists()) && LoggerUtil.logger.isLoggable(JeusMessage_Security._46_LEVEL)) {
            LoggerUtil.logger.log(JeusMessage_Security._46_LEVEL, JeusMessage_Security._46);
        }
        try {
            return (Subject[])this.conv.unmarshal(this.theFile);
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading accounts.xml XML file: exception occured", e);
        }
    }

    public void writeSubjectsToRepository(Object subjects) throws ServiceException {
        if (this.theFile == null || !this.theFile.exists()) {
            return;
        }
        try {
            if (SecurityInstaller.getEnvironment().master) {
                this.conv.marshal(subjects, this.theFile);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed writing accounts.xml XML file: exception occured", e);
        }
    }

    private void refreshWrite() throws ServiceException {
        if (this.theFile == null || !this.theFile.exists()) {
            return;
        }
        try {
            if (SecurityInstaller.getEnvironment().master) {
                this.conv.marshal((Object)this.subjectManager.getSubjectsAsArray(), this.theFile);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed writing accounts.xml XML file: exception occured", e);
        }
    }

    private void refreshRead() throws ServiceException {
        if ((this.theFile == null || !this.theFile.exists()) && LoggerUtil.logger.isLoggable(JeusMessage_Security._46_LEVEL)) {
            LoggerUtil.logger.log(JeusMessage_Security._46_LEVEL, JeusMessage_Security._46);
        }
        try {
            Subject[] subjects = (Subject[])this.conv.unmarshal(this.theFile);
            this.subjectManager.clear();
            this.subjectManager.addSubjectsFromArray(subjects);
            this.subjectManager.setGroupTable(this.conv.getGroupsTable());
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading accounts.xml XML file: exception occured", e);
        }
    }
}

