/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.io.File;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.atnrep.DistributedMemoryAuthenticationRepositoryService;
import jeus.security.impl.atnrep.XMLAccountConverter;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.NameAndPathUtil;

public class XMLAccountPersistedDistributedMemoryAuthenticationRepositoryService
extends DistributedMemoryAuthenticationRepositoryService {
    private File theFile;
    private XMLAccountConverter conv;

    protected void doCreate() throws ServiceException, SecurityException {
        super.doCreate();
        String filename = this.getProperty("filename");
        String baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
        if (filename == null) {
            filename = baseDir + NameAndPathUtil.getPathWithEndingSeparator(this.getDomain().getName()) + "accounts.xml";
        }
        this.theFile = new File(filename);
        if (!this.theFile.exists()) {
            this.theFile = new File(baseDir + NameAndPathUtil.getPathWithEndingSeparator("SYSTEM_DOMAIN") + "accounts.xml");
        }
        try {
            this.conv = new XMLAccountConverter(this.getDomain().getName());
            if (this.subjectContainer.isSubjectEmpty()) {
                this.refreshRead();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSave() throws ServiceException {
    }

    public Object readSubjectsInRepository() throws ServiceException {
        if ((this.theFile == null || !this.theFile.exists()) && LoggerUtil.logger.isLoggable(JeusMessage_Security._46_LEVEL)) {
            LoggerUtil.logger.log(JeusMessage_Security._46_LEVEL, JeusMessage_Security._46);
        }
        try {
            return (Subject[])this.conv.unmarshal(this.theFile);
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading accounts.xml XML file: exception occured", e);
        }
    }

    public void writeSubjectsToRepository(Object subjects) throws ServiceException {
        if (this.theFile == null || !this.theFile.exists()) {
            return;
        }
        try {
            if (SecurityInstaller.getEnvironment().master) {
                this.conv.marshal(subjects, this.theFile);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed writing accounts.xml XML file: exception occured", e);
        }
    }

    private void refreshWrite() throws ServiceException {
        if (this.theFile == null || !this.theFile.exists()) {
            return;
        }
        try {
            if (SecurityInstaller.getEnvironment().master) {
                this.conv.marshal((Object)this.subjectContainer.getSubjectsAsArray(), this.theFile);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed writing accounts.xml XML file: exception occured", e);
        }
    }

    private void refreshRead() throws ServiceException {
        if ((this.theFile == null || !this.theFile.exists()) && LoggerUtil.logger.isLoggable(JeusMessage_Security._46_LEVEL)) {
            LoggerUtil.logger.log(JeusMessage_Security._46_LEVEL, JeusMessage_Security._46);
        }
        try {
            Subject[] subjects = (Subject[])this.conv.unmarshal(this.theFile);
            this.subjectContainer.clear();
            this.subjectContainer.addSubjectsFromArray(subjects);
            this.subjectContainer.setGroupTable(this.conv.getGroupsTable());
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading accounts.xml XML file: exception occured", e);
        }
    }
}

