/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jeus.security.resource.UserCertInfo;
import jeus.security.util.XMLConverter;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.SecretKeyType;
import jeus.xml.binding.jeusDD.UserCertMapType;
import jeus.xml.binding.jeusDD.UserCertType;

public class XMLUserCertMapConverter
extends XMLConverter {
    private ObjectFactory of;
    private String keyStorePassword;
    private Map userCertMap;
    private List secretKeyNames = new ArrayList();

    public XMLUserCertMapConverter(Map userCertMap, String keyStorePassword) throws Exception {
        super("jeus.xml.binding.jeusDD");
        this.of = new ObjectFactory();
        this.userCertMap = userCertMap;
        this.keyStorePassword = keyStorePassword;
    }

    protected Object fromXMLTree(Object contentTree) throws Exception {
        UserCertMapType data = (UserCertMapType)contentTree;
        Vector<UserCertInfo> v = new Vector<UserCertInfo>();
        List userCertList = data.getUserCert();
        for (UserCertType userToCert : userCertList) {
            String username = userToCert.getUsername();
            String alias = userToCert.getAlias();
            String keyPassword = userToCert.getKeypassword();
            if (keyPassword == null) {
                keyPassword = this.keyStorePassword;
            }
            UserCertInfo certInfo = new UserCertInfo(alias, keyPassword.toCharArray());
            if (userToCert.isSetSecretkey()) {
                SecretKeyType secretKeyType = userToCert.getSecretkey();
                for (int i = 0; i < this.secretKeyNames.size(); ++i) {
                    if (!this.secretKeyNames.get(i).equals(secretKeyType.getKeyname())) continue;
                    throw new Exception("there must not be duplicate secretKey names " + secretKeyType.getKeyname());
                }
                this.secretKeyNames.add(secretKeyType.getKeyname());
                certInfo.setSecretKeyInfo(secretKeyType.getKeyname(), secretKeyType.getKeyalgorithm(), secretKeyType.getKeyvalue());
            }
            this.userCertMap.put(username, certInfo);
            v.add(certInfo);
        }
        return v.toArray(new UserCertInfo[v.size()]);
    }

    protected Object toXMLTree(Object object, Object tree) throws Exception {
        return null;
    }
}

