/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.azn;

import java.security.Permission;
import java.security.Principal;
import javax.management.ObjectName;
import jeus.security.base.JeusDBPolicyImpl;
import jeus.security.base.PolicyFactory;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.aznrep.CustomJeusDBPoliciesConverter;
import jeus.security.spi.AuthorizationService;
import jeus.security.spi.LoginService;
import jeus.security.util.Constants;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.PolicyContainer;

public class CustomJeusDBPolicyAuthorizationService
extends AuthorizationService {
    private CustomJeusDBPoliciesConverter conv;
    private String policyClassName;

    protected void doCreate() throws ServiceException {
        try {
            String password;
            String username;
            String url;
            String driver;
            String vendor = this.getProperty("vendor");
            if (vendor == null || vendor.equals("")) {
                new Exception("vendor is not set");
            }
            if ((driver = this.getProperty("driver")) == null || driver.equals("")) {
                new Exception("driver is not set");
            }
            if ((url = this.getProperty("url")) == null || url.equals("")) {
                new Exception("url is not set");
            }
            if ((username = this.getProperty("username")) == null || username.equals("")) {
                new Exception("username is not set");
            }
            if ((password = this.getProperty("password")) == null || password.equals("")) {
                new Exception("password is not set");
            }
            this.policyClassName = this.getProperty("classname");
            if (this.policyClassName == null || this.policyClassName.equals("")) {
                this.policyClassName = Constants.DEFAULT_POLICY_IMPL_CLASSNAME;
            }
            this.conv = new CustomJeusDBPoliciesConverter(this.getDomain().getName(), vendor, driver, url, username, EncryptionUtil.decryptPassword(password), this.policyClassName);
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating CustomPolicyAuthorizationService: exception occured", e);
        }
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    protected void doAuthorize(String contextId, Permission permission, Subject subject) throws ServiceException, SecurityException {
        JeusDBPolicyImpl policy = null;
        boolean loggedIn = false;
        try {
            LoginService.loginCodeSubject(subject.getDomainName());
            loggedIn = true;
            policy = (JeusDBPolicyImpl)PolicyFactory.getPolicyFactory(this.policyClassName);
        }
        catch (ServiceException e) {
            throw new SecurityException("Authorization failed: exception occured in underlying repository", e);
        }
        finally {
            if (loggedIn) {
                LoginService.logout();
            }
        }
        policy.setConv(this.conv);
        if (PolicyContainer.authorize(contextId, policy, permission, subject.getPrincipals().toArray(new Principal[0]))) {
            return;
        }
        throw new SecurityException("Authorization failed: permission (" + permission.toString() + ") denied : subject (" + subject.getPrincipal().getName() + ")");
    }
}

