/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.azn;

import java.security.Permission;
import java.security.Principal;
import javax.management.ObjectName;
import jeus.security.base.Policy;
import jeus.security.base.PolicyFactory;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.AuthorizationService;
import jeus.security.spi.LoginService;
import jeus.security.util.PolicyContainer;

public class CustomPolicyAuthorizationService
extends AuthorizationService {
    protected String customPolicyClassName;

    protected void doCreate() throws ServiceException {
        this.customPolicyClassName = this.getProperty("classname");
        if (this.customPolicyClassName == null || this.customPolicyClassName.equals("")) {
            this.customPolicyClassName = "jeus.security.base.Policy";
        }
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    protected void doAuthorize(String contextId, Permission permission, Subject subject) throws ServiceException, SecurityException {
        Policy policy = null;
        boolean loggedIn = false;
        try {
            LoginService.loginCodeSubject(subject.getDomainName());
            loggedIn = true;
            policy = PolicyFactory.getPolicyFactory(this.customPolicyClassName);
        }
        catch (ServiceException e) {
            throw new SecurityException("Authorization failed: exception occured in underlying repository", e);
        }
        finally {
            if (loggedIn) {
                LoginService.logout();
            }
        }
        if (PolicyContainer.authorize(contextId, policy, permission, subject.getPrincipals().toArray(new Principal[0]))) {
            return;
        }
        throw new SecurityException("Authorization failed: permission (" + permission.toString() + ") denied : subject (" + subject.getPrincipal().getName() + ")");
    }
}

