/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.util.Enumeration;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.management.j2ee.security.PolicyMo;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.aznrep.JeusDistributedMemoryAuthorizationRepositoryService;
import jeus.security.resource.CustomDBPolicyQuery;
import jeus.security.resource.DBPolicyQuery;
import jeus.security.spi.PolicyNotExistsException;
import jeus.security.util.LoggerUtil;
import jeus.security.util.SQLQueryConstants;
import jeus.util.message.JeusMessage_Security;

public class CustomDBRealmAuthorizationRepositoryService
extends JeusDistributedMemoryAuthorizationRepositoryService {
    protected DBPolicyQuery conv;
    protected PolicyMo policyMo;

    protected void doCreate() throws ServiceException, SecurityException {
        super.doCreate();
        String dsExportName = this.getProperty("export-name");
        try {
            this.conv = new CustomDBPolicyQuery(this.getDomain().getName(), dsExportName);
            SQLQueryConstants queryConstants = new SQLQueryConstants();
            queryConstants.initPolicySQLQuery();
            Enumeration<?> enum1 = this.propertyNames();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                if (!name.startsWith("SQLQuery:")) continue;
                String key = name.substring(9);
                String value = this.getProperty(key);
                queryConstants.setSQLQuery(key, value);
            }
            this.conv.setProp(queryConstants.getSQLQueryProp());
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating DBRealmAuthenticationRepositoryService: exception occured", e);
        }
    }

    protected void doDestroy() {
        this.conv = null;
        super.doDestroy();
    }

    public void doRegisterMBean(ObjectName parent) {
        block2: {
            try {
                this.policyMo = (PolicyMo)PolicyMo.createMBean("Policy", parent, this);
            }
            catch (InstanceAlreadyExistsException e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._7_LEVEL)) break block2;
                LoggerUtil.logger.log(JeusMessage_Security._7_LEVEL, JeusMessage_Security._7, (Throwable)e);
            }
        }
    }

    protected Policy doGetPolicy(String contextId) throws ServiceException, SecurityException {
        Policy policy;
        try {
            policy = super.doGetPolicy(contextId);
        }
        catch (PolicyNotExistsException e) {
            policy = this.conv.queryGetPolicy(contextId);
        }
        if (policy == null) {
            throw new PolicyNotExistsException("Failed getting policy: the Policy does not exist : " + this.getDomain().getName() + "/" + contextId);
        }
        return policy;
    }

    protected Set doGetPolicyIds() throws ServiceException, SecurityException {
        return this.conv.queryGetPolicyIds();
    }

    protected void refreshRepositryService() throws ServiceException {
    }

    protected void doAddPolicy(Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        super.doAddPolicy(policy, localAdd);
        if (!localAdd) {
            this.conv.queryAddPolicy(policy);
        }
    }

    protected void doRemovePolicy(Policy policy, boolean localRemove) throws ServiceException, SecurityException {
        try {
            super.doRemovePolicy(policy, localRemove);
        }
        catch (PolicyNotExistsException e) {
            if (!localRemove) {
                this.conv.queryRemovePolicy(policy);
            }
            return;
        }
        if (!localRemove) {
            this.conv.queryRemovePolicy(policy);
        }
    }

    protected void doRemovePolicy(String contextId, boolean localRemove) throws ServiceException, SecurityException {
        try {
            super.doRemovePolicy(contextId, localRemove);
        }
        catch (PolicyNotExistsException e) {
            if (!localRemove) {
                this.conv.queryRemovePolicy(contextId);
            }
            return;
        }
        if (!localRemove) {
            this.conv.queryRemovePolicy(contextId);
        }
    }

    protected void doSave() throws ServiceException, SecurityException {
        Policy[] policies = super.doGetPoliciesAsArray();
        this.conv.queryPolicySave(policies);
    }
}

