/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.util.Enumeration;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.management.j2ee.security.PolicyMo;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.aznrep.JeusDistributedMemoryAuthorizationRepositoryService;
import jeus.security.resource.DBPolicyQuery;
import jeus.security.spi.PolicyNotExistsException;
import jeus.security.util.DBDriverConverter;
import jeus.security.util.DataSourceConverter;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.SQLQueryConstants;

public class DBRealmAuthorizationRepositoryService
extends JeusDistributedMemoryAuthorizationRepositoryService {
    protected DBPolicyQuery conv;
    protected PolicyMo policyMo;

    protected void doCreate() throws ServiceException, SecurityException {
        super.doCreate();
        String dsExportName = this.getProperty("export-name");
        try {
            if (dsExportName == null) {
                String vendor = this.getProperty("vendor");
                if (vendor == null || vendor.equals("")) {
                    throw new Exception("vendor is not set");
                }
                String driver = this.getProperty("driver");
                if (driver == null || driver.equals("")) {
                    throw new Exception("driver is not set");
                }
                String url = this.getProperty("url");
                if (url == null || url.equals("")) {
                    throw new Exception("url is not set");
                }
                String username = this.getProperty("username");
                if (username == null || username.equals("")) {
                    throw new Exception("username is not set");
                }
                String password = this.getProperty("password");
                if (password == null || password.equals("")) {
                    throw new Exception("password is not set");
                }
                this.conv = new DBDriverConverter(this.getDomain().getName(), vendor, driver, url, username, EncryptionUtil.decryptPassword(password));
            } else {
                this.conv = new DataSourceConverter(this.getDomain().getName(), dsExportName);
            }
            SQLQueryConstants queryConstants = new SQLQueryConstants();
            queryConstants.initPolicySQLQuery();
            Enumeration<?> enum1 = this.propertyNames();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                if (!name.startsWith("SQLQuery:")) continue;
                String key = name.substring(9);
                String value = this.getProperty(key);
                queryConstants.setSQLQuery(key, value);
            }
            this.conv.setProp(queryConstants.getSQLQueryProp());
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating DBRealmAuthenticationRepositoryService: exception occured", e);
        }
    }

    protected void doDestroy() {
        this.conv = null;
        super.doDestroy();
    }

    public void doRegisterMBean(ObjectName parent) {
        block2: {
            try {
                this.policyMo = (PolicyMo)PolicyMo.createMBean("Policy", parent, this);
            }
            catch (InstanceAlreadyExistsException e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._7_LEVEL)) break block2;
                LoggerUtil.logger.log(JeusMessage_Security._7_LEVEL, JeusMessage_Security._7, (Throwable)e);
            }
        }
    }

    protected Policy doGetPolicy(String contextId) throws ServiceException, SecurityException {
        Policy policy;
        try {
            policy = super.doGetPolicy(contextId);
        }
        catch (PolicyNotExistsException e) {
            policy = this.conv.queryGetPolicy(contextId);
        }
        if (policy == null) {
            throw new PolicyNotExistsException("Failed getting policy: the Policy does not exist : " + this.getDomain().getName() + "/" + contextId);
        }
        return policy;
    }

    protected Set doGetPolicyIds() throws ServiceException, SecurityException {
        return this.conv.queryGetPolicyIds();
    }

    protected void refreshRepositryService() throws ServiceException {
    }

    protected void doAddPolicy(Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        super.doAddPolicy(policy, localAdd);
        if (!localAdd) {
            this.conv.queryAddPolicy(policy);
        }
    }

    protected void doRemovePolicy(Policy policy, boolean localRemove) throws ServiceException, SecurityException {
        try {
            super.doRemovePolicy(policy, localRemove);
        }
        catch (PolicyNotExistsException e) {
            if (!localRemove) {
                this.conv.queryRemovePolicy(policy);
            }
            return;
        }
        if (!localRemove) {
            this.conv.queryRemovePolicy(policy);
        }
    }

    protected void doRemovePolicy(String contextId, boolean localRemove) throws ServiceException, SecurityException {
        try {
            super.doRemovePolicy(contextId, localRemove);
        }
        catch (PolicyNotExistsException e) {
            if (!localRemove) {
                this.conv.queryRemovePolicy(contextId);
            }
            return;
        }
        if (!localRemove) {
            this.conv.queryRemovePolicy(contextId);
        }
    }

    protected void doSave() throws ServiceException, SecurityException {
        Policy[] policies = super.doGetPoliciesAsArray();
        this.conv.queryPolicySave(policies);
    }
}

