/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.io.File;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.aznrep.JeusDistributedMemoryAuthorizationRepositoryService;
import jeus.security.impl.aznrep.XMLPoliciesConverter;
import jeus.security.spi.PolicyNotExistsException;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.NameAndPathUtil;

public class FileRealmAuthorizationRepositoryService
extends JeusDistributedMemoryAuthorizationRepositoryService {
    private File theFile;
    private XMLPoliciesConverter conv;

    protected void doCreate() throws ServiceException, SecurityException {
        super.doCreate();
        String filename = this.getProperty("filename");
        String baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
        if (filename == null) {
            filename = baseDir + NameAndPathUtil.getPathWithEndingSeparator(this.getDomain().getName()) + "policies.xml";
        }
        this.theFile = new File(filename);
        if (!this.theFile.exists()) {
            this.theFile = new File(baseDir + NameAndPathUtil.getPathWithEndingSeparator("SYSTEM_DOMAIN") + "policies.xml");
        }
        try {
            this.conv = new XMLPoliciesConverter();
            if (this.policyManager.isEmpty()) {
                this.refreshRead();
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating FileRealmAuthorizationRepositoryService : exception occured", e);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
    }

    protected synchronized void doAddPolicy(Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        super.doAddPolicy(policy, localAdd);
    }

    protected synchronized void doRemovePolicy(Policy policy, boolean localRemove) throws ServiceException, SecurityException {
        super.doRemovePolicy(policy, localRemove);
    }

    protected synchronized void doRemovePolicy(String contextId, boolean localRemove) throws ServiceException, SecurityException {
        super.doRemovePolicy(contextId, localRemove);
    }

    protected void doSave() throws ServiceException {
        this.refreshWrite();
    }

    private void refreshWrite() throws ServiceException {
        block6: {
            if (this.theFile == null || !this.theFile.exists()) {
                return;
            }
            try {
                if (!SecurityInstaller.getEnvironment().master) break block6;
                try {
                    Policy p = this.policyManager.getPolicy("default");
                    if (p != null) {
                        this.conv.marshal((Object)new Policy[]{p}, this.theFile);
                    }
                }
                catch (PolicyNotExistsException p) {
                    return;
                }
            }
            catch (Exception e) {
                throw new ServiceException("Failed writing policies.xml XML file: exception occured", e);
            }
        }
    }

    private void refreshRead() throws ServiceException {
        if ((this.theFile == null || !this.theFile.exists()) && LoggerUtil.logger.isLoggable(JeusMessage_Security._46_LEVEL)) {
            LoggerUtil.logger.log(JeusMessage_Security._46_LEVEL, JeusMessage_Security._46);
        }
        try {
            this.policyManager.clear();
            Policy[] policies = (Policy[])this.conv.unmarshal(this.theFile);
            this.policyManager.addPoliciesFromArray(policies);
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading policies.xml XML file: exception occured", e);
        }
    }
}

