/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.security.Permission;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.management.j2ee.security.PolicyMo;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.PolicyContainer;

public class MemoryAuthorizationRepositoryService
extends AuthorizationRepositoryService {
    protected PolicyContainer policyContainer;
    protected PolicyMo policyMo = null;

    protected void doCreate() throws ServiceException, SecurityException {
        this.policyContainer = new PolicyContainer();
    }

    protected void doDestroy() {
        this.policyContainer.clearPolicies();
        this.policyContainer = null;
    }

    public void doRegisterMBean(ObjectName parent) {
        block2: {
            try {
                this.policyMo = (PolicyMo)PolicyMo.createMBean("Policy", parent, this);
            }
            catch (InstanceAlreadyExistsException e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._7_LEVEL)) break block2;
                LoggerUtil.logger.log(JeusMessage_Security._7_LEVEL, JeusMessage_Security._7, (Throwable)e);
            }
        }
    }

    protected Policy doGetPolicy(String contextId) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_POLICY_PERMISSION);
        return this.policyContainer.getPolicy(contextId);
    }

    protected Set doGetPolicyIds() throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_POLICY_PERMISSION);
        return this.policyContainer.getContextIds();
    }

    protected Policy[] doGetPoliciesAsArray() throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_POLICY_PERMISSION);
        return this.policyContainer.getPoliciesAsArray();
    }

    protected void doAddPolicy(Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)ADD_POLICY_PERMISSION);
        this.policyContainer.addPolicy(policy);
    }

    protected void doRemovePolicy(Policy policy, boolean localRemove) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_POLICY_PERMISSION);
        this.policyContainer.removePolicy(policy);
    }

    protected void doRemovePolicy(String contextId, boolean localRemove) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_POLICY_PERMISSION);
        this.policyContainer.removePolicy(contextId);
    }

    protected void doSave() throws ServiceException {
    }

    protected void refreshRepositryService() throws ServiceException {
    }

    public Object readPoliciesInRepository() throws ServiceException {
        return null;
    }

    public void writePoliciesToRepository(Object policies) throws ServiceException {
    }
}

