/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.io.File;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.aznrep.DistributedMemoryAuthorizationRepositoryService;
import jeus.security.impl.aznrep.XMLPoliciesConverter;
import jeus.security.spi.PolicyNotExistsException;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.NameAndPathUtil;

public class XMLPersistedDistributedMemoryAuthorizationRepositoryService
extends DistributedMemoryAuthorizationRepositoryService {
    private File theFile;
    private XMLPoliciesConverter conv;

    protected void doCreate() throws ServiceException, SecurityException {
        String filename = this.getProperty("filename");
        String baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
        if (filename == null) {
            filename = baseDir + NameAndPathUtil.getPathWithEndingSeparator(this.getDomain().getName()) + "policies.xml";
        }
        this.theFile = new File(filename);
        if (!this.theFile.exists()) {
            this.theFile = new File(baseDir + NameAndPathUtil.getPathWithEndingSeparator("SYSTEM_DOMAIN") + "policies.xml");
        }
        super.doCreate();
        try {
            this.conv = new XMLPoliciesConverter();
            if (this.policyContainer.isEmpty()) {
                this.refreshRead();
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating XMLPersistedDistributedMemoryAuthorizationRepositoryService: exception occured", e);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
    }

    protected synchronized void doAddPolicy(Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        super.doAddPolicy(policy, localAdd);
    }

    protected synchronized void doRemovePolicy(Policy policy, boolean localRemove) throws ServiceException, SecurityException {
        super.doRemovePolicy(policy, localRemove);
    }

    protected synchronized void doRemovePolicy(String contextId, boolean localRemove) throws ServiceException, SecurityException {
        super.doRemovePolicy(contextId, localRemove);
    }

    protected void doSave() throws ServiceException {
    }

    private void refreshWrite() throws ServiceException {
        block6: {
            if (this.theFile == null || !this.theFile.exists()) {
                return;
            }
            try {
                if (!SecurityInstaller.getEnvironment().master) break block6;
                try {
                    Policy p = this.policyContainer.getPolicy("default");
                    if (p != null) {
                        this.conv.marshal((Object)new Policy[]{p}, this.theFile);
                    }
                }
                catch (PolicyNotExistsException p) {}
            }
            catch (Exception e) {
                throw new ServiceException("Failed writing policies.xml XML file: exception occured", e);
            }
        }
    }

    private void refreshRead() throws ServiceException {
        if ((this.theFile == null || !this.theFile.exists()) && LoggerUtil.logger.isLoggable(JeusMessage_Security._46_LEVEL)) {
            LoggerUtil.logger.log(JeusMessage_Security._46_LEVEL, JeusMessage_Security._46);
        }
        try {
            this.policyContainer.clearPolicies();
            Policy[] policies = (Policy[])this.conv.unmarshal(this.theFile);
            this.policyContainer.addPoliciesFromArray(policies);
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading policies.xml XML file: exception occured", e);
        }
    }

    public Object readPoliciesInRepository() throws ServiceException {
        if ((this.theFile == null || !this.theFile.exists()) && LoggerUtil.logger.isLoggable(JeusMessage_Security._46_LEVEL)) {
            LoggerUtil.logger.log(JeusMessage_Security._46_LEVEL, JeusMessage_Security._46);
        }
        try {
            return (Policy[])this.conv.unmarshal(this.theFile);
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading policies.xml XML file: exception occured", e);
        }
    }

    public void writePoliciesToRepository(Object policies) throws ServiceException {
        if (this.theFile == null || !this.theFile.exists()) {
            return;
        }
        try {
            if (SecurityInstaller.getEnvironment().master) {
                this.conv.marshal(policies, this.theFile);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed writing policies.xml XML file: exception occured", e);
        }
    }
}

