/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.credmap;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import javax.management.ObjectName;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.spi.CredentialMappingService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.NameAndPathUtil;

public class JKSCertificateCredentialMappingService
extends CredentialMappingService {
    private KeyStore trustStore;

    protected void doCreate() throws ServiceException, SecurityException {
        try {
            String filename = this.getTrustStore(this.getProperty("truststore"));
            String truststorepwd = this.getTrustStorePass(EncryptionUtil.decryptPassword(this.getProperty("truststore-password")));
            if (filename == null) {
                String baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
                filename = baseDir + NameAndPathUtil.getPathWithEndingSeparator(this.getDomain().getName()) + "truststore";
            }
            FileInputStream fis = new FileInputStream(filename);
            this.trustStore = KeyStore.getInstance("JKS");
            this.trustStore.load(fis, truststorepwd.toCharArray());
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating JKSCertificateCredentialMappingService: failed to obtain reference to file", e);
        }
    }

    private String getTrustStorePass(String password) {
        if ((password == null || password.equals("")) && ((password = System.getProperty("jeus.ssl.trustpass", "jeustrustpass")) == null || password.equals(""))) {
            password = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (password == null) {
            password = "changeit";
        }
        return password;
    }

    private String getTrustStore(String trustStorePath) {
        if (trustStorePath == null && (trustStorePath = System.getProperty("jeus.ssl.truststore")) == null) {
            trustStorePath = System.getProperty("javax.net.ssl.trustStore");
        }
        return trustStorePath;
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    protected String doGetSubjectName(Object credential) throws ServiceException, SecurityException {
        try {
            return this.trustStore.getCertificateAlias((Certificate)credential);
        }
        catch (Exception e) {
            throw new ServiceException("Failed to get username for Certificate", e);
        }
    }

    protected boolean handles(Object credential) {
        return credential instanceof Certificate;
    }
}

