/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.installer;

import java.util.Iterator;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import jeus.security.base.Domain;
import jeus.security.base.Environment;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.impl.atn.ClientAuthenticationService;
import jeus.security.impl.atnrep.ClientAuthenticationRepositoryService;
import jeus.security.impl.azn.ClientAuthorizationService;
import jeus.security.impl.aznrep.ClientAuthorizationRepositoryService;
import jeus.security.impl.installer.CacheManagerService;
import jeus.security.impl.login.ClientLoginService;
import jeus.security.impl.login.NoAuthClientLoginService;
import jeus.security.impl.network.ClientSocketNetworkService;
import jeus.security.impl.subfactory.PasswordSubjectFactoryService;
import jeus.security.impl.validation.ClientSubjectValidationService;
import jeus.security.spi.SecurityInstaller;

public class JeusClientSecurityInstaller
extends SecurityInstaller {
    public Object getMBean() {
        return null;
    }

    protected MBeanInfo getMBeanInfo() {
        return null;
    }

    protected synchronized void doCreate() throws ServiceException, SecurityException {
    }

    public synchronized void doDestroy() {
    }

    protected void doInstallSecurity(Environment config) throws ServiceException, SecurityException {
        this.installSecurityClient(config);
    }

    protected void installSecurityClient(Environment config) throws ServiceException, SecurityException {
        int i;
        if (config.requiresSecurityManagement || config.requiresLocalAuthentication) {
            ClientSocketNetworkService csns = new ClientSocketNetworkService();
            Domain.SHARED_DOMAIN.addService(csns);
        }
        Domain.SHARED_DOMAIN.addService(new CacheManagerService());
        Domain.SHARED_DOMAIN.addService(new PasswordSubjectFactoryService());
        if (config.requiresLocalAuthentication) {
            Domain.SHARED_DOMAIN.addService(new ClientLoginService());
            Domain.SHARED_DOMAIN.addService(new ClientAuthenticationService());
            Domain.SHARED_DOMAIN.addService(new ClientSubjectValidationService());
        } else {
            Domain.SHARED_DOMAIN.addService(new NoAuthClientLoginService());
        }
        Domain.SHARED_DOMAIN.addService(new ClientAuthenticationRepositoryService());
        Domain.SHARED_DOMAIN.addService(new ClientAuthorizationService());
        Domain.SHARED_DOMAIN.addService(new ClientAuthorizationRepositoryService());
        for (i = 0; i < config.domains.length; ++i) {
            String csms;
            Domain d = new Domain(config.domains[i]);
            if (config.clientSubjectFactoryServiceClassnames != null && config.clientSubjectFactoryServiceClassnames.length > i && config.clientSubjectFactoryServiceClassnames[i] != null && (csms = config.clientSubjectFactoryServiceClassnames[i]) != null) {
                Service s;
                try {
                    s = (Service)Class.forName(csms).newInstance();
                }
                catch (Exception e) {
                    throw new ServiceException("Failed to install security system: error while loading a ClientSubjectMakerService", e);
                }
                d.addService(s);
            }
            Domain.addDomain(d);
        }
        Domain.SHARED_DOMAIN.createAll();
        for (i = 0; i < config.domains.length; ++i) {
            Domain.getDomain(config.domains[i]).createAll();
        }
    }

    public synchronized void doUninstallSecurity() {
        this.uninstallSecurityClient();
    }

    public String addDomain(String name) {
        return null;
    }

    public void removeDomain(String name) {
    }

    protected void uninstallSecurityClient() {
        Domain.clearCurrentDomains();
        Iterator domains = Domain.getDomains().iterator();
        while (domains.hasNext()) {
            try {
                Domain d = (Domain)domains.next();
                d.destroyAll();
                d.clearServices();
            }
            catch (Exception exception) {}
        }
        Domain.clearDomains();
        Domain.SHARED_DOMAIN.destroyAll();
        Domain.SHARED_DOMAIN.clearServices();
    }

    public void doRegisterMBean(ObjectName parent) {
    }
}

