/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.jacc;

import java.security.AccessControlException;
import java.security.Permission;
import java.security.SecurityPermission;
import java.util.Hashtable;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import jeus.security.impl.jacc.JACCPolicyConfigurationImpl;

public class JACCPolicyConfigurationFactoryImpl
extends PolicyConfigurationFactory {
    private static Hashtable policyConfigurations = new Hashtable();
    private static final Permission setPolicyPermission = new SecurityPermission("setPolicy");
    static JACCPolicyConfigurationFactoryImpl theFactory;

    public JACCPolicyConfigurationFactoryImpl() {
        theFactory = this;
    }

    public synchronized PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        Object o = policyConfigurations.get(contextID);
        JACCPolicyConfigurationImpl pc = null;
        if (o != null) {
            pc = (JACCPolicyConfigurationImpl)o;
        }
        if (pc == null) {
            pc = new JACCPolicyConfigurationImpl(contextID);
            policyConfigurations.put(contextID, pc);
            return pc;
        }
        if (remove) {
            pc.delete();
        }
        pc.setState(0);
        return pc;
    }

    public boolean inService(String contextID) throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        if (contextID == null) {
            return false;
        }
        Object o = policyConfigurations.get(contextID);
        if (o != null) {
            JACCPolicyConfigurationImpl pc = (JACCPolicyConfigurationImpl)o;
            return pc.inService();
        }
        return false;
    }

    static void checkSetPolicyPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(setPolicyPermission);
            }
            catch (AccessControlException ace) {
                throw new SecurityException("AccessControlContext does not have the setPolicy permission (failure in Tmax Soft's JACC policy provider)");
            }
        }
    }
}

