/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.login;

import java.io.Serializable;
import java.security.Permission;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import jeus.security.base.ClientService;
import jeus.security.base.CodeSubject;
import jeus.security.base.NetworkMessage;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.security.spi.NetworkService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.spi.SubjectFactoryService;
import jeus.util.ArrayListStack;

public class ClientLoginService
extends LoginService
implements ClientService {
    Map cache = new Hashtable();
    private static ThreadLocal subjectStack = new ThreadLocal(){

        protected Object initialValue() {
            return new ArrayListStack();
        }
    };
    private static ThreadLocal currentSubject = new ThreadLocal();

    public Object getMBean() {
        return null;
    }

    protected MBeanInfo getMBeanInfo() {
        return null;
    }

    protected void doCreate() throws ServiceException {
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    public void removeCache(String node) {
        this.cache.remove(node);
    }

    protected void doLogin() throws ServiceException, SecurityException {
        Subject sub = SubjectFactoryService.getSubject();
        this.doLogin(sub, false);
    }

    protected void doLogin(Subject subject, boolean trusted) throws ServiceException, SecurityException {
        try {
            this.doForceLogin(subject);
            if (!trusted) {
                if (this.getCache().get(subject) != null) {
                    return;
                }
                NetworkService.sendMessage(new NetworkMessage(13, LoginService.getCurrentSubject(), null), false);
                this.getCache().put(subject, "true");
            }
        }
        catch (ServiceException se) {
            this.doLogout();
            throw se;
        }
        catch (SecurityException se) {
            this.doLogout();
            throw se;
        }
    }

    protected void doLogin(Subject subject, boolean trusted, String node) throws ServiceException, SecurityException {
        try {
            this.doForceLogin(subject);
            if (!trusted) {
                if (this.getCache(node).get(subject) != null) {
                    return;
                }
                NetworkService.sendMessage(new NetworkMessage(13, LoginService.getCurrentSubject(), null), node);
                this.getCache(node).put(subject, "true");
            }
        }
        catch (ServiceException se) {
            this.doLogout();
            throw se;
        }
        catch (SecurityException se) {
            this.doLogout();
            throw se;
        }
    }

    protected void doForceLogin(Subject subject) {
        this.pushSubject(subject);
    }

    protected void doCheckPermission(String contextId, Permission permission) throws ServiceException, SecurityException {
        String key = contextId + permission.getName();
        if (this.getCache().get(key) != null) {
            return;
        }
        NetworkService.sendMessage(new NetworkMessage(14, LoginService.getCurrentSubject(), new Serializable[]{contextId, permission}), false);
    }

    public Subject doGetCurrentSubject() {
        return this.peekSubject();
    }

    public Subject doGetLatestUserSubject() {
        ArrayListStack stack = (ArrayListStack)subjectStack.get();
        for (int i = stack.size() - 1; i >= 0; --i) {
            Object subject = stack.get(i);
            if (subject instanceof CodeSubject) continue;
            return (Subject)subject;
        }
        return null;
    }

    protected Subject doLogout() {
        return this.popSubject();
    }

    private void pushSubject(Subject subject) {
        if (subject != null) {
            ArrayListStack stack = (ArrayListStack)subjectStack.get();
            stack.push((Object)subject);
            currentSubject.set(subject);
        }
    }

    private Subject peekSubject() {
        return (Subject)currentSubject.get();
    }

    private Subject popSubject() {
        ArrayListStack stack = (ArrayListStack)subjectStack.get();
        if (!stack.isEmpty()) {
            Subject sub = (Subject)stack.pop();
            if (stack.isEmpty()) {
                currentSubject.set(null);
            } else {
                currentSubject.set(stack.peek());
            }
            return sub;
        }
        return null;
    }

    private Hashtable getCache() {
        String node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
        return this.getCache(node);
    }

    private Hashtable getCache(String node) {
        Object hash = this.cache.get(node);
        if (hash == null) {
            hash = new Hashtable();
            this.cache.put(node, hash);
            return (Hashtable)hash;
        }
        return (Hashtable)hash;
    }
}

