/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.login;

import java.io.Serializable;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;

public class LoginModuleInfo
implements Serializable {
    public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
    public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
    private AppConfigurationEntry[] loginModules;
    private CallbackHandler callbackHandler;
    private String callbackClassname;

    public AppConfigurationEntry[] copyAppConfigurationEntry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        AppConfigurationEntry[] copy = new AppConfigurationEntry[this.loginModules.length];
        for (int i = 0; i < this.loginModules.length; ++i) {
            AppConfigurationEntry entry = this.loginModules[i];
            copy[i] = new AppConfigurationEntry(entry.getLoginModuleName(), entry.getControlFlag(), entry.getOptions());
        }
        return copy;
    }

    public AppConfigurationEntry[] getAppConfigurationEntry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        return this.loginModules;
    }

    public void setAppConfigurationEntry(AppConfigurationEntry[] loginModules) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONFIG_ENTRY_PERM);
        }
        this.loginModules = loginModules;
    }

    public CallbackHandler getAppCallbackHandler() {
        return this.callbackHandler;
    }

    public void setAppCallbackHandler(CallbackHandler handler) {
        this.callbackHandler = handler;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AppConfigurationEntry[]:\n");
        for (int i = 0; i < this.loginModules.length; ++i) {
            AppConfigurationEntry entry = this.loginModules[i];
            buffer.append("[" + i + "]");
            buffer.append("\nLoginModule Class: " + entry.getLoginModuleName());
            buffer.append("\nControlFlag: " + entry.getControlFlag());
            buffer.append("\nOptions:");
            Map<String, ?> options = entry.getOptions();
            for (Map.Entry<String, ?> e : options.entrySet()) {
                buffer.append("name=" + e.getKey());
                buffer.append(", value=" + e.getValue());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public String getCallbackClassname() {
        return this.callbackClassname;
    }

    public void setCallbackClassname(String callbackClassname) {
        this.callbackClassname = callbackClassname;
    }
}

