/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.login;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Permission;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import jeus.security.base.Domain;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.login.ClientLoginService;
import jeus.security.impl.login.LoginModuleInfo;
import jeus.security.resource.SystemPassword;
import jeus.security.spi.AuthorizationService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.SubjectActions;
import jeus.util.ArrayListStack;

public class LoginModuleService
extends ClientLoginService {
    private static ThreadLocal activeLoginContextStack = new ThreadLocal(){

        protected Object initialValue() {
            return new ArrayListStack();
        }
    };
    private static ThreadLocal currentLoginContext = new ThreadLocal();

    private void pushLoginContext(LoginContext lc) {
        if (lc != null) {
            ArrayListStack stack = (ArrayListStack)activeLoginContextStack.get();
            stack.push((Object)lc);
            currentLoginContext.set(lc);
        }
    }

    private LoginContext peekLoginContext() {
        return (LoginContext)currentLoginContext.get();
    }

    private LoginContext popLoginContext() {
        ArrayListStack stack = (ArrayListStack)activeLoginContextStack.get();
        if (!stack.isEmpty()) {
            LoginContext lc = (LoginContext)stack.pop();
            if (stack.isEmpty()) {
                currentLoginContext.set(null);
            } else {
                currentLoginContext.set(stack.peek());
            }
            return lc;
        }
        return null;
    }

    public LoginContext doGetCurrentLoginContext() {
        return this.peekLoginContext();
    }

    public Subject doGetCurrentSubject() {
        return super.doGetCurrentSubject();
    }

    protected void doLogin(Subject subject, boolean trusted) throws ServiceException, SecurityException {
        block6: {
            try {
                if (SystemPassword.checkSystemPassword(subject)) {
                    SystemPassword.setSystemPassword(subject);
                    this.doForceLogin(subject);
                    break block6;
                }
                if (this.jaasCallbackHandler != null) {
                    Class[] sig = new Class[]{String.class, Subject.class, Boolean.class};
                    try {
                        Method setSecurityInfo = this.jaasCallbackHandler.getClass().getMethod("setSecurityInfo", sig);
                        Object[] securityInfo = new Object[]{this.getDomain().getName(), subject, trusted};
                        setSecurityInfo.invoke((Object)this.jaasCallbackHandler, securityInfo);
                    }
                    catch (Exception e) {
                        String msg = "Failed to find setSecurityInfo(Princpal, Object) method in handler";
                        throw new UndeclaredThrowableException(e, msg);
                    }
                }
                LoginContext lc = SubjectActions.createLoginContext(this.getDomain().getName(), subject.toJAASSubject(), this.jaasCallbackHandler);
                lc.login();
                subject = Subject.fromJAASSubject(lc.getSubject(), this.getDomain().getName());
                this.pushLoginContext(lc);
                SystemPassword.setSystemPassword(subject);
                this.doForceLogin(subject);
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), e);
            }
        }
    }

    protected void doLogin(Subject subject, boolean trusted, String node) throws ServiceException, SecurityException {
        this.doLogin(subject, trusted, node);
    }

    protected void doForceLogin(Subject subject) {
        super.doForceLogin(subject);
    }

    protected Subject doLogout() {
        LoginContext lc = this.popLoginContext();
        try {
            if (lc != null) {
                lc.logout();
            }
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        return super.doLogout();
    }

    protected void doCheckPermission(String contextId, Permission permission) throws ServiceException, SecurityException {
        AuthorizationService.authorize(contextId, permission, LoginModuleService.getCurrentSubject());
    }

    protected void doCreate() throws ServiceException {
        Domain currentDomain = this.getDomain();
        Map appConfigs = currentDomain.getLoginConfig().getAppConfigs();
        LoginModuleInfo info = (LoginModuleInfo)appConfigs.get(currentDomain.getName());
        if (info != null) {
            this.jaasCallbackHandler = info.getAppCallbackHandler();
        }
        SecurityInstaller.getEnvironment().jaasCallbackHandler = this.jaasCallbackHandler.getClass().getName();
    }
}

