/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.network;

import java.net.Socket;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.protocol.message.ContentHandlerCreator;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.JeusSSLConfiguration;
import jeus.net.ManagerEndpoint;
import jeus.net.SocketID;
import jeus.net.impl.NodeInfo;
import jeus.security.base.NetworkMessage;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.network.AbstractNetworkService;
import jeus.security.impl.network.ServerSecurityConnectionListener;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.Constants;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.JeusSecurityProperties;
import jeus.server.JeusServer;
import jeus.util.JeusPooledExecutorFactory;
import jeus.util.JeusPort;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;

public class ServerSocketNetworkService
extends AbstractNetworkService
implements ConnectionListenerFactory {
    private boolean enableNIO = true;
    private static final String THREAD_NAME_PREFIX = "SecurityNetworkService";
    private int threadPoolMinSize = 10;
    private int threadPoolMaxSize = 20;
    private long threadPoolResizePeriod = 60000L;
    private static Executor pooledExecutor;
    protected static final JeusLogger logger;

    protected void doCreate() throws ServiceException {
        String poolsize;
        this.enableNIO = SecurityInstaller.getEnvironment().enableNIO;
        if (logger.isLoggable(JeusMessage_Security._5_LEVEL)) {
            logger.log(JeusMessage_Security._5_LEVEL, JeusMessage_Security._5, (Object)String.valueOf(this.enableNIO));
        }
        this.threadPoolMaxSize = (poolsize = this.getProperty("threadpool")) == null || poolsize.equals("") ? 5 : Integer.parseInt(poolsize);
        if (this.threadPoolMaxSize <= 0) {
            this.threadPoolMaxSize = 5;
        }
        try {
            SSLContext sslContext;
            NodeInfo nodeInfo;
            pooledExecutor = JeusPooledExecutorFactory.createPooledExecutor((String)THREAD_NAME_PREFIX, (int)this.threadPoolMaxSize);
            if (JeusSecurityProperties.USE_SSL) {
                nodeInfo = JeusServer.clusterInfo.getLocalNode(JeusPort.Security_SSL, 0);
                sslContext = JeusSSLConfiguration.sslContext;
            } else {
                nodeInfo = JeusServer.clusterInfo.getLocalNode(Constants.Security_ID, 0);
                sslContext = null;
            }
            this.endpoint = new ManagerEndpoint("ServerSecurity", this.enableNIO, (SocketID)nodeInfo, (StreamContentHandlerCreator)new ContentHandlerCreator(), this, sslContext, connectPiggybackData);
            this.endpoint.export();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to create ServerSocketNetworkService: unexpected exception occured", e);
        }
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return new ServerSecurityConnectionListener(this, pooledExecutor);
    }

    public static Executor getPooledExecutor() {
        return pooledExecutor;
    }

    protected boolean loginSubject(NetworkMessage message, boolean loggedIn) throws ServiceException, SecurityException {
        LoginService.login(message.getSubject());
        loggedIn = true;
        return loggedIn;
    }

    protected Object processException(Exception e) {
        e.printStackTrace();
        return e;
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.security");
    }
}

