/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Properties;
import jeus.security.base.CredentialFactory;
import jeus.security.base.CredentialFactoryException;
import jeus.security.base.Domain;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.NameAndPathUtil;

public class JKSCertificateFactory
extends Properties
implements CredentialFactory {
    public static final String ALIAS_PROPERTY_KEY = "alias";
    public static final String TRUSTSTORE_PROPERTY_KEY = "truststore";
    public static final String TRUSTSTORE_PASSWORD_PROPERTY_KEY = "truststorepwd";

    public JKSCertificateFactory() {
    }

    public JKSCertificateFactory(String alias) {
        this.setProperty(ALIAS_PROPERTY_KEY, alias);
    }

    public JKSCertificateFactory(String alias, String truststore) {
        this(alias);
        this.setProperty(TRUSTSTORE_PROPERTY_KEY, truststore);
    }

    public JKSCertificateFactory(String alias, String truststore, String truststorepwd) {
        this(alias, truststore);
        this.setProperty(TRUSTSTORE_PASSWORD_PROPERTY_KEY, truststorepwd);
    }

    public String getAlias() {
        return this.getProperty(ALIAS_PROPERTY_KEY);
    }

    public char[] getTrustStorePassword() {
        String keyPwd = this.getProperty(TRUSTSTORE_PASSWORD_PROPERTY_KEY);
        if (keyPwd == null) {
            return null;
        }
        return keyPwd.toCharArray();
    }

    public String getTruststore() {
        try {
            String filename = this.getProperty(TRUSTSTORE_PROPERTY_KEY);
            if (filename == null) {
                String baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
                filename = baseDir + NameAndPathUtil.getPathWithEndingSeparator(Domain.getCurrentDomain().getName()) + TRUSTSTORE_PROPERTY_KEY;
            }
            return filename;
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof JKSCertificateFactory)) {
            return false;
        }
        if (this == another) {
            return true;
        }
        return super.equals(another);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object getCredential() throws CredentialFactoryException {
        try {
            FileInputStream fis = new FileInputStream(this.getTruststore());
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(fis, this.getTrustStorePassword());
            return ks.getCertificate(this.getAlias());
        }
        catch (Throwable t) {
            throw new CredentialFactoryException("Error loading certificate from truststore", t);
        }
    }

    public boolean isPublicCredential() {
        return true;
    }
}

