/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityRuntimeException;
import jeus.util.properties.JeusNetProperties;

public class JeusSecurityManager
extends SecurityManager {
    private SecurityManager securityManager;

    public JeusSecurityManager(SecurityManager security) {
        this.securityManager = security;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public boolean getInCheck() {
        if (this.securityManager == null) {
            return super.getInCheck();
        }
        return false;
    }

    public JeusSecurityManager() {
    }

    public Object getSecurityContext() {
        if (this.securityManager == null) {
            return super.getSecurityContext();
        }
        return this.securityManager.getSecurityContext();
    }

    public void checkPermission(Permission perm) {
        if (this.securityManager != null) {
            this.securityManager.checkPermission(perm);
        }
    }

    public void checkPermission(Permission perm, Object context) {
        if (this.securityManager != null) {
            this.securityManager.checkPermission(perm, context);
        }
    }

    public void checkCreateClassLoader() {
        if (this.securityManager != null) {
            this.securityManager.checkCreateClassLoader();
        }
    }

    public void checkAccess(Thread t) {
        if (this.securityManager != null) {
            this.securityManager.checkAccess(t);
        }
    }

    public void checkAccess(ThreadGroup g) {
        if (this.securityManager != null) {
            this.securityManager.checkAccess(g);
        }
    }

    public void checkExit(int status) {
        if (this.securityManager == null) {
            super.checkExit(status);
            try {
                LoginService.checkCodeSubject();
            }
            catch (SecurityRuntimeException ex) {
                throw new SecurityException("System.exit() call is prohibited by JEUS security manager. Please check the stack trace");
            }
        } else {
            this.securityManager.checkExit(status);
        }
    }

    public void checkExec(String cmd) {
        if (this.securityManager != null) {
            this.securityManager.checkExec(cmd);
        }
    }

    public void checkLink(String lib) {
        if (this.securityManager != null) {
            this.securityManager.checkLink(lib);
        }
    }

    public void checkRead(FileDescriptor fd) {
        if (this.securityManager != null) {
            this.securityManager.checkRead(fd);
        }
    }

    public void checkRead(String file) {
        if (this.securityManager != null) {
            this.securityManager.checkRead(file);
        }
    }

    public void checkRead(String file, Object context) {
        if (this.securityManager != null) {
            this.securityManager.checkRead(file, context);
        }
    }

    public void checkWrite(FileDescriptor fd) {
        if (this.securityManager != null) {
            this.securityManager.checkWrite(fd);
        }
    }

    public void checkWrite(String file) {
        if (this.securityManager != null) {
            this.securityManager.checkWrite(file);
        }
    }

    public void checkDelete(String file) {
        if (this.securityManager != null) {
            this.securityManager.checkDelete(file);
        }
    }

    public void checkConnect(String host, int port) {
        if (this.securityManager != null) {
            this.securityManager.checkConnect(host, port);
        }
        if (JeusNetProperties.LOG_SOCKET_PORT) {
            System.out.println("[Socket] connect host : " + host + ", port : " + port);
            if (JeusNetProperties.LOG_BIND_STACK) {
                new Exception("Socket Connect Stack").printStackTrace();
            }
        }
    }

    public void checkConnect(String host, int port, Object context) {
        if (this.securityManager != null) {
            this.securityManager.checkConnect(host, port, context);
        }
        if (JeusNetProperties.LOG_SOCKET_PORT) {
            System.out.println("[Socket] connect host : " + host + ", port : " + port + ", context : " + context);
            if (JeusNetProperties.LOG_BIND_STACK) {
                new Exception("Socket Connect Stack").printStackTrace();
            }
        }
    }

    public void checkListen(int port) {
        if (this.securityManager != null) {
            this.securityManager.checkListen(port);
        }
        if (JeusNetProperties.LOG_SERVER_SOCKET_PORT) {
            System.out.println("[ServerSocket] listen port : " + port);
            if (JeusNetProperties.LOG_SERVER_BIND_STACK) {
                new Exception("Server Socket Bind Stack").printStackTrace();
            }
        }
    }

    public void checkAccept(String host, int port) {
        if (this.securityManager != null) {
            this.securityManager.checkAccept(host, port);
        }
        if (JeusNetProperties.LOG_SERVER_SOCKET_PORT) {
            System.out.println("[ServerSocket] accept host : " + host + ", port : " + port);
            if (JeusNetProperties.LOG_SERVER_BIND_STACK) {
                new Exception("Server Socket accept Stack").printStackTrace();
            }
        }
    }

    public void checkMulticast(InetAddress maddr) {
        if (this.securityManager != null) {
            this.securityManager.checkMulticast(maddr);
        }
    }

    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (this.securityManager != null) {
            this.securityManager.checkMulticast(maddr, ttl);
        }
    }

    public void checkPropertiesAccess() {
        if (this.securityManager != null) {
            this.securityManager.checkPropertiesAccess();
        }
    }

    public void checkPropertyAccess(String key) {
        if (this.securityManager != null) {
            this.securityManager.checkPropertyAccess(key);
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        if (this.securityManager != null) {
            return this.securityManager.checkTopLevelWindow(window);
        }
        return false;
    }

    public void checkPrintJobAccess() {
        if (this.securityManager != null) {
            this.securityManager.checkPrintJobAccess();
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.securityManager != null) {
            this.securityManager.checkSystemClipboardAccess();
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.securityManager != null) {
            this.securityManager.checkAwtEventQueueAccess();
        }
    }

    public void checkPackageAccess(String pkg) {
        if (this.securityManager != null) {
            this.securityManager.checkPackageAccess(pkg);
        }
    }

    public void checkPackageDefinition(String pkg) {
        if (this.securityManager != null) {
            this.securityManager.checkPackageDefinition(pkg);
        }
    }

    public void checkSetFactory() {
        if (this.securityManager != null) {
            this.securityManager.checkSetFactory();
        }
    }

    public void checkMemberAccess(Class clazz, int which) {
        if (this.securityManager != null) {
            this.securityManager.checkMemberAccess(clazz, which);
        }
    }

    public void checkSecurityAccess(String target) {
        if (this.securityManager != null) {
            this.securityManager.checkSecurityAccess(target);
        }
    }

    public ThreadGroup getThreadGroup() {
        if (this.securityManager != null) {
            return this.securityManager.getThreadGroup();
        }
        return super.getThreadGroup();
    }
}

