/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.security.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jeus.security.resource.ResourcePermission;

public class TreeResourcePermission
extends ResourcePermission {
    private Hashtable actions = new Hashtable();
    private String stringActions;

    public TreeResourcePermission(String name) {
        this(name, "");
    }

    public TreeResourcePermission(String name, String actions) {
        super(name);
        if (actions != null) {
            this.stringActions = actions = actions.trim();
            StringTokenizer st = new StringTokenizer(actions, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int iequal = token.indexOf(61);
                if (iequal <= 0) continue;
                String key = token.substring(0, iequal);
                String value = token.substring(iequal + 1);
                this.actions.put(key, value);
            }
        }
    }

    public TreeResourcePermission(String name, Hashtable keyPropertyList) {
        super(name);
        this.actions.putAll(keyPropertyList);
    }

    public Hashtable getKeyPropertyList() {
        return this.actions;
    }

    public boolean implies(Permission anotherPermission) {
        if (anotherPermission == null) {
            return false;
        }
        if (anotherPermission == this) {
            return true;
        }
        if (anotherPermission instanceof TreeResourcePermission) {
            TreeResourcePermission otherRP = (TreeResourcePermission)((Object)anotherPermission);
            if (this.nameImplies(this.getName(), otherRP.getName()) && this.containsAll(otherRP.getKeyPropertyList())) {
                return true;
            }
        }
        return false;
    }

    private boolean nameImplies(String myName, String otherName) {
        myName = this.extractName(myName);
        otherName = this.extractName(otherName);
        if (myName.equals("*")) {
            return true;
        }
        int starIndex = myName.indexOf("*");
        if (starIndex > -1) {
            String noStar = myName.substring(0, starIndex);
            return otherName.startsWith(noStar);
        }
        return otherName.equals(myName);
    }

    private boolean containsAll(Hashtable otherKP) {
        Hashtable src = this.actions;
        Enumeration keys = src.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!otherKP.containsKey(key)) {
                return false;
            }
            Object value = src.get(key);
            if (value.equals(otherKP.get(key))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object anotherObject) {
        if (anotherObject == null) {
            return false;
        }
        if (anotherObject == this) {
            return true;
        }
        if (anotherObject instanceof TreeResourcePermission) {
            TreeResourcePermission resPerm = (TreeResourcePermission)((Object)anotherObject);
            return this.getName().equals(resPerm.getName()) && this.actions.equals(resPerm.actions);
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getActions().hashCode();
    }

    public String getActions() {
        return this.stringActions;
    }

    public String toString() {
        return "(" + ((Object)((Object)this)).getClass().getName() + " " + this.getName() + " " + this.actions + ")";
    }

    private String extractName(String name) {
        int bl = name.indexOf(91);
        int br = name.indexOf(93);
        if (bl >= 0 && bl <= br) {
            name = name.substring(0, bl);
        }
        return name;
    }
}

