/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import jeus.security.base.Domain;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.spi.SecurityInstaller;

public abstract class CredentialMappingService
extends Service {
    public static String getSubjectName(Object credential) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        for (CredentialMappingService cms : Domain.getCurrentDomain().getZeroOrMoreServices(CredentialMappingService.class)) {
            if (!cms.handles(credential)) continue;
            try {
                return cms.doGetSubjectName(credential);
            }
            catch (ServiceException se) {
            }
            catch (SecurityException securityException) {
            }
        }
        throw new ServiceException("Failed getting the Principal name of a user for the passed credential");
    }

    protected abstract String doGetSubjectName(Object var1) throws ServiceException, SecurityException;

    protected abstract boolean handles(Object var1);

    public final Class getType() {
        return CredentialMappingService.class;
    }
}

