/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import java.security.Permission;
import java.security.Principal;
import java.security.SecurityPermission;
import javax.security.auth.callback.CallbackHandler;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.CodeSubject;
import jeus.security.base.Domain;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.SecurityInstaller;
import jeus.security.spi.SecurityRuntimeException;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.JeusRuntimeException;

public abstract class LoginService
extends Service {
    protected CallbackHandler jaasCallbackHandler;
    private static ThreadLocal currentLoginService = new InheritableThreadLocal();

    public static void loginCodeSubject(String domainName) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        LoginService.loginCodeSubject(Domain.getCodeSubject(domainName));
    }

    public static void loginCodeSubject(Subject codeSubject) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Domain.setCurrentDomain(codeSubject.getDomainName());
        try {
            LoginService ls = (LoginService)currentLoginService.get();
            if (ls == null) {
                ls = (LoginService)Domain.getCurrentDomain().getOneService(LoginService.class);
                currentLoginService.set(ls);
            }
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkPermission(new SecurityPermission("loginCodeSubject"));
            }
            ls.doForceLogin(codeSubject);
        }
        catch (ServiceException se) {
            Domain.unsetCurrentDomain();
            currentLoginService.set(null);
            throw se;
        }
        catch (SecurityException se) {
            Domain.unsetCurrentDomain();
            currentLoginService.set(null);
            throw se;
        }
    }

    public static void loginCodeSubject() throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        LoginService.loginCodeSubject(Domain.getCodeSubject(null));
    }

    public static void loginAnonymousSubject(String domainName) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        LoginService.loginAnonymousSubject(Domain.getAnonymousSubject(domainName));
    }

    public static void loginAnonymousSubject(Subject anonymousSubject) throws ServiceException, SecurityException {
        Domain.setCurrentDomain(anonymousSubject.getDomainName());
        try {
            LoginService ls = (LoginService)currentLoginService.get();
            if (ls == null) {
                ls = (LoginService)Domain.getCurrentDomain().getOneService(LoginService.class);
                currentLoginService.set(ls);
            }
            ls.doForceLogin(anonymousSubject);
        }
        catch (ServiceException se) {
            Domain.unsetCurrentDomain();
            currentLoginService.set(null);
            throw se;
        }
        catch (SecurityException se) {
            Domain.unsetCurrentDomain();
            currentLoginService.set(null);
            throw se;
        }
    }

    public static void loginAnonymousSubject() throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        LoginService.loginAnonymousSubject(Domain.getAnonymousSubject(null));
    }

    public final Class getType() {
        return LoginService.class;
    }

    public static Principal getCurrentPrincipal() throws ServiceException, SecurityException {
        return LoginService.getCurrentSubject().getPrincipal();
    }

    public static Subject getCurrentSubject() throws ServiceException, SecurityException {
        Subject cur;
        if (SecurityInstaller.isSecurityOff()) {
            return LoginService.getAnonymousSubject();
        }
        if (!SecurityInstaller.isSecurityInstalled()) {
            return Domain.getAnonymousSubject();
        }
        LoginService ls = (LoginService)currentLoginService.get();
        if (ls == null) {
            ls = (LoginService)Domain.getCurrentDomain().getOneService(LoginService.class);
            currentLoginService.set(ls);
        }
        if ((cur = ls.doGetCurrentSubject()) == null) {
            return Domain.getAnonymousSubject();
        }
        return cur;
    }

    public static Subject getLatestUserSubject() throws ServiceException, SecurityException {
        Subject cur;
        if (!SecurityInstaller.isSecurityInstalled()) {
            return Domain.getAnonymousSubject();
        }
        LoginService ls = (LoginService)currentLoginService.get();
        if (ls == null) {
            ls = (LoginService)Domain.getCurrentDomain().getOneService(LoginService.class);
            currentLoginService.set(ls);
        }
        if ((cur = ls.doGetLatestUserSubject()) == null) {
            return Domain.getAnonymousSubject();
        }
        return cur;
    }

    public abstract Subject doGetCurrentSubject() throws ServiceException;

    public abstract Subject doGetLatestUserSubject() throws ServiceException;

    public static void login() throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        LoginService.login((String)null);
    }

    public static void login(String domainName) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        if (domainName == null) {
            try {
                Domain.setCurrentDomain(Domain.getCurrentDomain());
            }
            catch (Exception e) {
                Domain.setCurrentDomain(SecurityInstaller.getEnvironment().defaultDomainName);
            }
        } else {
            Domain.setCurrentDomain(domainName);
        }
        try {
            LoginService ls = (LoginService)currentLoginService.get();
            if (ls == null) {
                ls = (LoginService)Domain.getCurrentDomain().getOneService(LoginService.class);
                currentLoginService.set(ls);
            }
            ls.doLogin();
        }
        catch (ServiceException se) {
            Domain.unsetCurrentDomain();
            currentLoginService.set(null);
            throw se;
        }
        catch (SecurityException se) {
            Domain.unsetCurrentDomain();
            currentLoginService.set(null);
            throw se;
        }
    }

    protected abstract void doLogin() throws ServiceException, SecurityException;

    public static void login(Subject subject) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        LoginService.login(subject, false);
    }

    public static void login(Subject subject, boolean trusted) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        if (subject == null) {
            throw new ServiceException("Login failed since Subject is null");
        }
        if (trusted && System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new SecurityPermission("runTrustedLogin"));
        }
        Domain.setCurrentDomain(subject.getDomainName());
        try {
            Service s = Domain.getCurrentDomain().getOneService(LoginService.class);
            LoginService ls = (LoginService)s;
            currentLoginService.set(ls);
            if (AnonymousSubject.isAnonymous(subject)) {
                ls.doForceLogin(subject);
            } else if (CodeSubject.isCode(subject)) {
                if (System.getSecurityManager() != null) {
                    System.getSecurityManager().checkPermission(new SecurityPermission("loginCodeSubject"));
                }
                ls.doForceLogin(subject);
            } else {
                ls.doLogin(subject, trusted);
            }
        }
        catch (ServiceException se) {
            Domain.unsetCurrentDomain();
            currentLoginService.set(null);
            throw se;
        }
        catch (SecurityException se) {
            Domain.unsetCurrentDomain();
            currentLoginService.set(null);
            throw se;
        }
    }

    protected abstract void doLogin(Subject var1, boolean var2) throws ServiceException, SecurityException;

    protected abstract void doLogin(Subject var1, boolean var2, String var3) throws ServiceException, SecurityException;

    protected abstract void doForceLogin(Subject var1) throws ServiceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subject logout() throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return LoginService.getAnonymousSubject();
        }
        if (!SecurityInstaller.isSecurityInstalled()) {
            return LoginService.getAnonymousSubject();
        }
        try {
            Subject sub;
            LoginService ls = (LoginService)currentLoginService.get();
            if (ls == null) {
                ls = (LoginService)Domain.getCurrentDomain().getOneService(LoginService.class);
                currentLoginService.set(ls);
            }
            if ((sub = ls.doLogout()) != null) {
                Domain.unsetCurrentDomain();
            }
            Subject subject = sub;
            return subject;
        }
        finally {
            currentLoginService.set(null);
        }
    }

    public static Subject getAnonymousSubject() {
        if (JeusBootstrapPropertyValues.isUpperJDK4()) {
            return AnonymousSubject.singleton;
        }
        return null;
    }

    protected abstract Subject doLogout() throws ServiceException;

    public static void checkPermission(String contextId, Permission permission) throws ServiceException, SecurityException {
        Subject subject;
        LoginService ls;
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        if (contextId == null) {
            contextId = "default";
        }
        if ((ls = (LoginService)currentLoginService.get()) == null) {
            ls = (LoginService)Domain.getCurrentDomain().getOneService(LoginService.class);
            currentLoginService.set(ls);
        }
        if ((subject = ls.doGetCurrentSubject()) == null) {
            subject = Domain.getAnonymousSubject();
        } else if (CodeSubject.isCode(subject)) {
            return;
        }
        ls.doCheckPermission(contextId, permission);
    }

    public static void checkPermission(Permission permission) throws ServiceException, SecurityException {
        LoginService.checkPermission("default", permission);
    }

    protected abstract void doCheckPermission(String var1, Permission var2) throws ServiceException, SecurityException;

    public static byte[] getCurrentSubjectSerialized() throws SecurityException, ServiceException {
        return LoginService.getCurrentSubject().serialize();
    }

    public static void checkCodeSubject() {
        if (!LoginService.isCodeSubject()) {
            throw new SecurityRuntimeException("Current subject is not code subject");
        }
    }

    public static boolean isCodeSubject() {
        if (SecurityInstaller.isSecurityOff()) {
            return true;
        }
        try {
            return CodeSubject.isCode(LoginService.getCurrentSubject());
        }
        catch (JeusRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JeusRuntimeException(e);
        }
    }
}

