/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import jeus.security.base.Domain;
import jeus.security.base.SKI;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.resource.ResourcePermission;
import jeus.security.resource.SecretKeyInfo;
import jeus.security.spi.SecurityInstaller;

public abstract class UserCertMappingService
extends Service {
    public static final ResourcePermission USER_CERT_MAPPING_PERMISSION = new ResourcePermission(UserCertMappingService.class.getName(), "X509API");
    protected Map keyStoreToCertMap;
    protected Map trustStoreToCertMap;
    protected Map userCertMap;
    protected Map certUserMap;
    protected Map privateKeyMap;
    protected KeyStore keyStore;
    protected KeyStore trustStore;

    protected void doCreate() throws ServiceException, SecurityException {
        this.keyStoreToCertMap = new HashMap();
        this.trustStoreToCertMap = new HashMap();
        this.privateKeyMap = new HashMap();
        this.userCertMap = new HashMap();
        this.certUserMap = new HashMap();
        this.keyStore = this.getDomain().getKeyStore();
        this.trustStore = this.getDomain().getTrustStore();
    }

    protected void doDestroy() {
        this.keyStoreToCertMap.clear();
        this.trustStoreToCertMap.clear();
        this.privateKeyMap.clear();
        this.userCertMap.clear();
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    public Map getPrivateKeyMap() {
        return this.privateKeyMap;
    }

    public void setPrivateKeyMap(Map privateKeyMap) {
        this.privateKeyMap = privateKeyMap;
    }

    public static KeyStore getTrustStore() throws ServiceException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        return Domain.getCurrentDomain().getTrustStore();
    }

    public static KeyStore getKeyStore() throws ServiceException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        return Domain.getCurrentDomain().getKeyStore();
    }

    public static X509Certificate getCertInTrustStore(Principal subjectDN) throws SecurityException, ServiceException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        try {
            return ucms.doGetCertInTrustStore(subjectDN);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public static X509Certificate getCertInTrustStore(SKI ski) throws SecurityException, ServiceException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        try {
            return ucms.doGetCertInTrustStore(ski);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public static X509Certificate getCertInTrustStore(Principal issuerDN, BigInteger serial) throws SecurityException, ServiceException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        try {
            return ucms.doGetCertInTrustStore(issuerDN, serial);
        }
        catch (KeyStoreException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public static X509Certificate getCertInKeyStore(Principal subjectDN) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        try {
            return ucms.doGetCertInKeyStore(subjectDN);
        }
        catch (KeyStoreException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public static X509Certificate getCertInKeyStore(SKI ski) throws SecurityException, ServiceException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        try {
            return ucms.doGetCertInKeyStore(ski);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public static X509Certificate getCertInKeyStore(Principal issuerDN, BigInteger serial) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        try {
            return ucms.doGetCertInKeyStore(issuerDN, serial);
        }
        catch (KeyStoreException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public static PrivateKey getPrivateKey(Principal subjectDN) throws ServiceException, SecurityException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetPrivateKey(subjectDN);
    }

    public static PrivateKey getPrivateKey(SKI ski) throws Exception, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetPrivateKey(ski);
    }

    public static PrivateKey getPrivateKey(Principal issuerDN, BigInteger serial) throws ServiceException, SecurityException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetPrivateKey(issuerDN, serial);
    }

    public static boolean isValid(X509Certificate cert, boolean checkCRL) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return false;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        try {
            return ucms.doIsValid(cert, checkCRL);
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public static String getSubjectInTrustStore(Principal subjectDN) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetSubjectInTrustStore(subjectDN);
    }

    public static String getSubjectInTrustStore(SKI ski) throws Exception, ServiceException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetSubjectInTrustStore(ski);
    }

    public static String getSubjectInTrustStore(Principal issuerDN, BigInteger serial) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetSubjectInTrustStore(issuerDN, serial);
    }

    public static String getSubjectInTrustStore(byte[] thumbprint) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetSubjectInTrustStore(thumbprint);
    }

    public static String getSubjectInKeyStore(Principal subjectDN) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetSubjectInKeyStore(subjectDN);
    }

    public static String getSubjectInKeyStore(SKI ski) throws Exception {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetSubjectInKeyStore(ski);
    }

    public static String getSubjectInKeyStore(Principal issuerDN, BigInteger serial) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetSubjectInKeyStore(issuerDN, serial);
    }

    public static String getSubjectInKeyStore(byte[] thumbprint) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetSubjectInKeyStore(thumbprint);
    }

    public static X509Certificate getCertInTrustStore(String subject) throws ServiceException, SecurityException, KeyStoreException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetCertInTrustStore(subject);
    }

    public static X509Certificate getCertInKeyStore(String subject) throws ServiceException, SecurityException, KeyStoreException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetCertInKeyStore(subject);
    }

    public static PrivateKey getPrivateKey(String subject) throws ServiceException, SecurityException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetPrivateKey(subject);
    }

    public static SecretKeyInfo getSecretKeyWithKeyName(String keyName) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetSecretKeyWithKeyName(keyName);
    }

    public static SecretKeyInfo getSecretKeyWithKeyUser(String user) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetSecretKeyWithKeyUser(user);
    }

    public static String getUserInCert(String key) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetUserInCert(key);
    }

    public static List getCertificates(String subject) throws ServiceException, SecurityException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(UserCertMappingService.class);
        UserCertMappingService ucms = (UserCertMappingService)s;
        return ucms.doGetCertificates(subject);
    }

    protected abstract X509Certificate doGetCertInTrustStore(Principal var1) throws KeyStoreException;

    protected abstract X509Certificate doGetCertInTrustStore(SKI var1) throws Exception;

    protected abstract X509Certificate doGetCertInTrustStore(Principal var1, BigInteger var2) throws KeyStoreException;

    protected abstract X509Certificate doGetCertInKeyStore(Principal var1) throws KeyStoreException;

    protected abstract X509Certificate doGetCertInKeyStore(SKI var1) throws Exception;

    protected abstract X509Certificate doGetCertInKeyStore(Principal var1, BigInteger var2) throws KeyStoreException;

    protected abstract PrivateKey doGetPrivateKey(Principal var1) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, SecurityException, ServiceException;

    protected abstract PrivateKey doGetPrivateKey(SKI var1) throws Exception;

    protected abstract PrivateKey doGetPrivateKey(Principal var1, BigInteger var2) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, SecurityException, ServiceException;

    protected abstract boolean doIsValid(X509Certificate var1, boolean var2) throws KeyStoreException;

    protected abstract String doGetSubjectInTrustStore(SKI var1) throws Exception;

    protected abstract String doGetSubjectInTrustStore(Principal var1) throws SecurityException;

    protected abstract String doGetSubjectInTrustStore(Principal var1, BigInteger var2) throws SecurityException;

    protected abstract String doGetSubjectInTrustStore(byte[] var1) throws SecurityException;

    protected abstract String doGetSubjectInKeyStore(SKI var1) throws Exception;

    protected abstract String doGetSubjectInKeyStore(Principal var1) throws SecurityException;

    protected abstract String doGetSubjectInKeyStore(Principal var1, BigInteger var2) throws SecurityException;

    protected abstract String doGetSubjectInKeyStore(byte[] var1) throws SecurityException;

    protected abstract X509Certificate doGetCertInKeyStore(String var1) throws KeyStoreException, SecurityException;

    protected abstract PrivateKey doGetPrivateKey(String var1) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, ServiceException, SecurityException;

    protected abstract X509Certificate doGetCertInTrustStore(String var1) throws KeyStoreException, SecurityException;

    protected abstract SecretKeyInfo doGetSecretKeyWithKeyName(String var1) throws ServiceException, SecurityException;

    protected abstract SecretKeyInfo doGetSecretKeyWithKeyUser(String var1) throws ServiceException, SecurityException;

    protected abstract String doGetUserInCert(String var1) throws SecurityException, ServiceException;

    protected abstract List doGetCertificates(String var1) throws SecurityException, ServiceException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException;

    public Class getType() {
        return UserCertMappingService.class;
    }
}

