/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ConcurrentHashSetReadOnlyIterator
extends HashSet {
    private HashSet hashSet;
    private Class valueType;
    private Object[] values;

    public ConcurrentHashSetReadOnlyIterator(Class valueType) {
        this.hashSet = new HashSet();
        this.valueType = valueType;
    }

    public ConcurrentHashSetReadOnlyIterator(Class valueType, HashSet _hashSet) {
        this.hashSet = _hashSet;
        this.valueType = valueType;
    }

    public Iterator iterator() {
        return new ReadOnlyIterator(this.getValues());
    }

    public synchronized boolean add(Object o) {
        this.values = null;
        return this.hashSet.add(o);
    }

    public synchronized boolean remove(Object o) {
        this.values = null;
        return this.hashSet.remove(o);
    }

    public synchronized boolean removeAll(Collection c) {
        this.values = null;
        return this.hashSet.removeAll(c);
    }

    public synchronized boolean addAll(Collection c) {
        this.values = null;
        return this.hashSet.addAll(c);
    }

    public synchronized boolean retainAll(Collection c) {
        this.values = null;
        return this.hashSet.retainAll(c);
    }

    public synchronized boolean contains(Object o) {
        return this.hashSet.contains(o);
    }

    public synchronized boolean containsAll(Collection c) {
        return this.hashSet.containsAll(c);
    }

    public synchronized int size() {
        return this.hashSet.size();
    }

    public synchronized void clear() {
        this.values = null;
        this.hashSet.clear();
    }

    public synchronized boolean isEmpty() {
        return this.hashSet.isEmpty();
    }

    public synchronized Object[] toArray() {
        return this.hashSet.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return this.hashSet.toArray(a);
    }

    public synchronized Object clone() {
        return new ConcurrentHashSetReadOnlyIterator(this.valueType, this);
    }

    private synchronized Object[] getValues() {
        if (this.values == null) {
            this.values = (Object[])Array.newInstance(this.valueType, this.size());
            Iterator it = this.hashSet.iterator();
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = it.next();
            }
        }
        return this.values;
    }

    private class ReadOnlyIterator
    implements Iterator {
        private int index;
        private Object[] values;

        public ReadOnlyIterator(Object[] values) {
            this.values = values;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index < this.values.length;
        }

        public Object next() {
            if (this.index >= this.values.length) {
                throw new NoSuchElementException();
            }
            return this.values[this.index++];
        }
    }
}

