/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class CopyOnWriteLinkedHashSet
implements Set,
Serializable {
    private LinkedHashSet hashSet;
    private boolean isShared;

    public CopyOnWriteLinkedHashSet() {
        this.hashSet = new LinkedHashSet();
    }

    public CopyOnWriteLinkedHashSet(LinkedHashSet _hashSet) {
        this.hashSet = _hashSet;
    }

    public CopyOnWriteLinkedHashSet(Collection c) {
        this.hashSet = new LinkedHashSet(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public CopyOnWriteLinkedHashSet(int initialCapacity, float loadFactor) {
        this.hashSet = new LinkedHashSet(initialCapacity, loadFactor);
    }

    public CopyOnWriteLinkedHashSet(int initialCapacity) {
        this.hashSet = new LinkedHashSet(initialCapacity);
    }

    private synchronized LinkedHashSet getHashSet() {
        return this.hashSet;
    }

    public Iterator iterator() {
        this.isShared = true;
        LinkedHashSet _hashSet = this.getHashSet();
        return new ReadOnlyIterator(_hashSet.iterator());
    }

    public int size() {
        LinkedHashSet _hashSet = this.getHashSet();
        return _hashSet.size();
    }

    public boolean isEmpty() {
        LinkedHashSet _hashSet = this.getHashSet();
        return _hashSet.isEmpty();
    }

    public boolean contains(Object o) {
        LinkedHashSet _hashSet = this.getHashSet();
        return _hashSet.contains(o);
    }

    public synchronized boolean add(Object o) {
        if (this.isShared) {
            this.hashSet = (LinkedHashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.add(o);
    }

    public synchronized boolean remove(Object o) {
        if (this.isShared) {
            this.hashSet = (LinkedHashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.remove(o);
    }

    public synchronized boolean removeAll(Collection c) {
        if (this.isShared) {
            this.hashSet = (LinkedHashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (this.isShared) {
            this.hashSet = (LinkedHashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.retainAll(c);
    }

    public synchronized boolean addAll(Collection c) {
        if (this.isShared) {
            this.hashSet = (LinkedHashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.addAll(c);
    }

    public boolean containsAll(Collection c) {
        if (this.isShared) {
            this.hashSet = (LinkedHashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.containsAll(c);
    }

    public void clear() {
        this.hashSet = new LinkedHashSet();
    }

    public Object clone() {
        this.isShared = true;
        CopyOnWriteLinkedHashSet newSet = new CopyOnWriteLinkedHashSet(this.hashSet);
        newSet.isShared = true;
        return newSet;
    }

    public Object[] toArray() {
        LinkedHashSet hashSet = this.getHashSet();
        return hashSet.toArray();
    }

    public Object[] toArray(Object[] a) {
        LinkedHashSet hashSet = this.getHashSet();
        return hashSet.toArray(a);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        LinkedHashSet _hashSet = this.getHashSet();
        s.writeObject(_hashSet);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.hashSet = (LinkedHashSet)s.readObject();
    }

    class ReadOnlyIterator
    implements Iterator {
        private Iterator iterator;

        public ReadOnlyIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }
    }
}

