/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.security.Permission;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.base.Role;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.DBPolicyQuery;
import jeus.security.resource.DBSubjectQuery;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.resource.Password;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.RoleImpl;
import jeus.security.util.Constants;
import jeus.security.util.DBRealmConverter;
import jeus.security.util.InstanceMaker;
import jeus.security.util.PermissionMaker;

public abstract class DBRealmSQLQueryConverter
extends DBRealmConverter
implements DBSubjectQuery,
DBPolicyQuery {
    public Properties getinitProp() {
        return this.prop;
    }

    public void setProp(Properties userProp) {
        this.prop = userProp;
    }

    public Subject queryGetSubject(String name) throws ServiceException, SecurityException {
        String queryString = this.prop.getProperty("sql-get-user");
        String queryGroupMemString = this.prop.getProperty("sql-get-groups-memnberships");
        String queryGroupString = this.prop.getProperty("sql-get-group");
        ResultSet userResultSet = this.executeQuery(queryString, new String[]{this.domainName, name});
        try {
            if (userResultSet == null || userResultSet.getFetchSize() <= 0) {
                throw new ServiceException("user does not exist");
            }
            Subject cur = null;
            if (userResultSet.next()) {
                String password = userResultSet.getString("password");
                Principal thePrince = (Principal)InstanceMaker.makeInstance(Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME, new Object[]{name});
                cur = new Subject(this.domainName, thePrince);
                ResultSet groupMemResultSet = this.executeQuery(queryGroupMemString, new String[]{this.domainName, name});
                while (groupMemResultSet.next()) {
                    ResultSet groupResultSet = this.executeQuery(queryGroupString, new String[]{this.domainName, groupMemResultSet.getString("groupname")});
                    if (groupResultSet == null || groupResultSet.getFetchSize() <= 0) {
                        throw new Exception(groupMemResultSet.getString("groupname") + " group is not defined in database");
                    }
                    while (groupResultSet.next()) {
                        String groupName = groupResultSet.getString("groupname");
                        String grClazz = Constants.DEFAULT_GROUP_PRINCIPAL_IMPL_CLASSNAME;
                        GroupPrincipalImpl groupImpl = (GroupPrincipalImpl)InstanceMaker.makeInstance(grClazz, new Object[]{groupName});
                        String subgroups = groupResultSet.getString("subgroups");
                        if (subgroups != null) {
                            StringTokenizer token = new StringTokenizer(subgroups, ",");
                            while (token.hasMoreElements()) {
                                groupImpl.addMember(new GroupPrincipalImpl((String)token.nextElement()));
                            }
                        }
                        groupImpl.setDescription(groupResultSet.getString("description"));
                        cur.getPrincipals().add(groupImpl);
                    }
                }
                if (password != null) {
                    cur.addPasswordInfo(password);
                }
                groupMemResultSet.close();
            }
            userResultSet.close();
            return cur;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public Set queryGetSubjectNames() throws ServiceException {
        String queryString = this.prop.getProperty("sql-get-users");
        ResultSet userResultSet = this.executeQuery(queryString, new String[]{this.domainName});
        HashSet<String> result = new HashSet<String>();
        try {
            while (userResultSet.next()) {
                result.add(userResultSet.getString("username"));
            }
        }
        catch (SQLException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        return result;
    }

    public void queryAddSubject(Subject subject) {
        String queryString = this.prop.getProperty("sql-add-user");
        String queryGroupString = this.prop.getProperty("sql-add-group");
        String username = subject.getPrincipal().getName();
        Password password = subject.getPasswordObject();
        if (password.getAlgorithm() == null) {
            this.executeUpdateQuery(queryString, new String[]{this.domainName, username, password.getPassword()});
        } else {
            this.executeUpdateQuery(queryString, new String[]{this.domainName, username, "{" + password.getAlgorithm() + "}" + password.getPassword()});
        }
        for (Object obj : subject.getPrincipals()) {
            if (!(obj instanceof Group)) continue;
            this.executeUpdateQuery(queryGroupString, new String[]{this.domainName, ((GroupPrincipalImpl)obj).getName(), username});
        }
    }

    public void queryRemoveSubject(Subject subject) {
        this.queryRemoveSubject(subject.getPrincipal().getName());
    }

    public void queryAddSubject(Subject subject, boolean localAdd) {
        this.queryAddSubject(subject);
    }

    public void queryRemoveSubject(Subject subject, boolean localRemove) {
        this.queryRemoveSubject(subject.getPrincipal().getName());
    }

    public void queryRemoveSubject(String name) {
        String queryString = this.prop.getProperty("sql-remove-memberships");
        this.executeUpdateQuery(queryString, new String[]{this.domainName, name});
        queryString = this.prop.getProperty("sql-remove-user");
        this.executeUpdateQuery(queryString, new String[]{this.domainName, name});
    }

    public void querySubjectSave(Subject[] subjects) {
        for (int i = 0; i < subjects.length; ++i) {
            this.queryAddSubject(subjects[i]);
        }
    }

    public boolean queryUserExists(String userName) {
        String queryString = this.prop.getProperty("sql-get-user");
        ResultSet userResultSet = this.executeQuery(queryString, new String[]{this.domainName, userName});
        try {
            if (userResultSet.getFetchSize() > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean queryGroupExist(String groupName) {
        String queryString = this.prop.getProperty("sql-get-group");
        ResultSet groupResultSet = this.executeQuery(queryString, new String[]{this.domainName, groupName});
        try {
            if (groupResultSet.getFetchSize() > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void queryAddGroup(Group group) {
        GroupPrincipalImpl groupImpl = (GroupPrincipalImpl)group;
        Principal[] subgImpl = groupImpl.getSubGroups();
        String subgroups = null;
        if (subgImpl.length > 0) {
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < subgImpl.length; ++j) {
                buf.append(subgImpl[j].getName()).append(", ");
            }
            buf.deleteCharAt(buf.toString().lastIndexOf(","));
            subgroups = buf.toString();
        }
        String queryString = this.prop.getProperty("sql-add-group");
        this.executeUpdateQuery(queryString, new String[]{this.domainName, groupImpl.getName(), subgroups, groupImpl.getDescription()});
    }

    public void queryAddUserToGroup(String groupName, Principal principal) throws ServiceException {
        String queryString = this.prop.getProperty("sql-get-member-from-membership");
        ResultSet groupMemResultSet = this.executeQuery(queryString, new String[]{this.domainName, groupName, principal.getName()});
        try {
            if (groupMemResultSet.getFetchSize() <= 0) {
                queryString = this.prop.getProperty("sql-add-membership");
                this.executeUpdateQuery(queryString, new String[]{this.domainName, groupName, principal.getName()});
            }
        }
        catch (SQLException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public Group queryGetGroup(String groupName) throws ServiceException {
        String queryString = this.prop.getProperty("sql-get-group");
        ResultSet groupResultSet = this.executeQuery(queryString, new String[]{this.domainName, groupName});
        GroupPrincipalImpl groupImpl = null;
        try {
            while (groupResultSet.next()) {
                groupImpl = new GroupPrincipalImpl(groupName);
                String subgroups = groupResultSet.getString("subgroups");
                StringTokenizer tokens = new StringTokenizer(subgroups, ",");
                while (tokens.hasMoreTokens()) {
                    groupImpl.addMember((Principal)this.queryGetGroup(tokens.nextToken()));
                }
                groupImpl.setDescription(groupResultSet.getString("description"));
            }
        }
        catch (SQLException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        return groupImpl;
    }

    public Set queryGetGroupNames() throws ServiceException {
        String queryString = this.prop.getProperty("sql-get-groups");
        ResultSet groupResultSet = this.executeQuery(queryString, new String[]{this.domainName});
        HashSet<String> result = new HashSet<String>();
        try {
            while (groupResultSet.next()) {
                result.add(groupResultSet.getString("groupname"));
            }
        }
        catch (SQLException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        return result;
    }

    public Group[] queryGetGroupList() throws ServiceException {
        Set groupNames = this.queryGetGroupNames();
        Group[] groups = new Group[groupNames.size()];
        Iterator iterator = groupNames.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            groups[i] = this.queryGetGroup((String)iterator.next());
            ++i;
        }
        return groups;
    }

    public void queryRemoveGroup(String groupName) {
        String queryString = this.prop.getProperty("sql-remove-group-from-membership");
        this.executeUpdateQuery(queryString, new String[]{this.domainName, groupName});
        queryString = this.prop.getProperty("sql-remove-group");
        this.executeUpdateQuery(queryString, new String[]{this.domainName, groupName});
    }

    public void queryRemoveUserFromGroup(String groupName, Principal principal) {
        String queryString = this.prop.getProperty("sql-remove-membership");
        this.executeUpdateQuery(queryString, new String[]{this.domainName, groupName, principal.getName()});
    }

    public boolean queryIsMember(String groupName, Principal principal) throws ServiceException {
        String queryString = this.prop.getProperty("sql-get-member-from-membership");
        ResultSet groupMemResultSet = this.executeQuery(queryString, new String[]{this.domainName, groupName, principal.getName()});
        try {
            if (groupMemResultSet.getFetchSize() > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        return false;
    }

    public Enumeration queryGetMembersFromGroup(String groupName) throws ServiceException {
        String queryString = this.prop.getProperty("sql-get-members-from-membership");
        ResultSet groupResultSet = this.executeQuery(queryString, new String[]{this.domainName, groupName});
        Vector<String> members = new Vector<String>();
        try {
            while (groupResultSet.next()) {
                String username = groupResultSet.getString("username");
                members.add(username);
            }
        }
        catch (SQLException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        return members.elements();
    }

    public Policy queryGetPolicy(String contextId) throws ServiceException, java.lang.SecurityException {
        String queryString = this.prop.getProperty("sql-get-rolepermissionid");
        String queryRoleString = this.prop.getProperty("sql-get-rolepermission");
        Policy dpc = new Policy();
        ResultSet rolePermissionsResultSet = this.executeQuery(queryString, new String[]{this.domainName});
        try {
            while (rolePermissionsResultSet.next()) {
                ResultSet rolePermissionResultSet = this.executeQuery(queryRoleString, new String[]{rolePermissionsResultSet.getString("rolepermissionid")});
                dpc.getRolePolicy().add(this.loadRolePermissions(rolePermissionResultSet));
                rolePermissionResultSet.close();
            }
            rolePermissionsResultSet.close();
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        queryString = this.prop.getProperty("sql-get-resourcepermissionid");
        String queryResourceString = this.prop.getProperty("sql-get-resourcepermission");
        ResultSet resourcePermissionsResultSet = this.executeQuery(queryString, new String[]{this.domainName, contextId});
        try {
            while (resourcePermissionsResultSet.next()) {
                ResultSet resourcePermissionResultSet = this.executeQuery(queryResourceString, new String[]{resourcePermissionsResultSet.getString("resourcepermissionid")});
                while (resourcePermissionResultSet.next()) {
                    dpc.getResourcePolicy(contextId, true).add(this.loadResourcePermissions(resourcePermissionResultSet));
                }
                resourcePermissionResultSet.close();
            }
            resourcePermissionsResultSet.close();
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        return dpc;
    }

    public Set queryGetPolicyIds() throws ServiceException, java.lang.SecurityException {
        String queryString = this.prop.getProperty("sql-get-resourcepermissions");
        ResultSet resourcePermissionsResultSet = this.executeQuery(queryString, new String[]{this.domainName});
        HashSet<String> result = new HashSet<String>();
        try {
            while (resourcePermissionsResultSet.next()) {
                result.add(resourcePermissionsResultSet.getString("contextid"));
            }
        }
        catch (SQLException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        return result;
    }

    public void queryAddPolicy(Policy policy) throws ServiceException {
        Vector querys = new Vector();
        try {
            this.savePolicy(policy, querys);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        String[] queryList = new String[querys.size()];
        querys.toArray(queryList);
        this.executeUpdate(queryList);
    }

    public void queryRemovePolicy(Policy policy) throws ServiceException, java.lang.SecurityException {
        for (String id : policy.getResourcePolicyIds()) {
            this.queryRemovePolicy(id);
        }
    }

    public void queryRemovePolicy(String contextId) throws ServiceException, java.lang.SecurityException {
        String queryString = this.prop.getProperty("sql-get-resourcepermissionid");
        ResultSet resourcePermissionsResultSet = this.executeQuery(queryString, new String[]{this.domainName, contextId});
        Vector<String> querys = new Vector<String>();
        try {
            resourcePermissionsResultSet.next();
            String permissionid = resourcePermissionsResultSet.getString("resourcepermissionid");
            querys.add(this.getDeleteQuery("jeus_resource_role", new String[]{"resourcepermissionid"}, new String[]{permissionid}));
            querys.add(this.getDeleteQuery("jeus_resource_permission", new String[]{"resourcepermissionid"}, new String[]{permissionid}));
            querys.add(this.getDeleteQuery("jeus_resource_permissions", new String[]{"resourcepermissionid"}, new String[]{permissionid}));
        }
        catch (SQLException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        String[] queryList = new String[querys.size()];
        querys.toArray(queryList);
        this.executeUpdate(queryList);
    }

    public void queryPolicySave(Policy[] policies) throws ServiceException {
        Vector querys = new Vector();
        for (int i = 0; i < policies.length; ++i) {
            try {
                this.savePolicy(policies[i], querys);
                continue;
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), e);
            }
        }
        String[] queryList = new String[querys.size()];
        querys.toArray(queryList);
        this.executeUpdate(queryList);
    }

    private PermissionMap loadRolePermissions(ResultSet rolePermissionResultSet) throws Exception {
        String queryString = this.prop.getProperty("sql-get-role-to-principal");
        PermissionMap pc = new PermissionMap();
        while (rolePermissionResultSet.next()) {
            Permission p = PermissionMaker.makePermission((String)rolePermissionResultSet.getString("classname"), (String)rolePermissionResultSet.getString("role"), (String)rolePermissionResultSet.getString("actions"));
            boolean excluded = Boolean.getBoolean(rolePermissionResultSet.getString("excluded"));
            boolean unchecked = Boolean.getBoolean(rolePermissionResultSet.getString("unchecked"));
            Vector<PrincipalImpl> principals = new Vector<PrincipalImpl>();
            ResultSet rolePrincipalResultSet = this.executeQuery(queryString, new String[]{this.domainName, rolePermissionResultSet.getString("rolepermissionid")});
            while (rolePrincipalResultSet.next()) {
                principals.add(new PrincipalImpl(rolePrincipalResultSet.getString("username")));
            }
            rolePrincipalResultSet.close();
            Object[] princes = principals.toArray();
            pc.addPermission(p, princes, excluded, unchecked);
        }
        return pc;
    }

    private PermissionMap loadResourcePermissions(ResultSet resourcePermissionResultSet) throws Exception {
        String queryString = this.prop.getProperty("sql-get-resource-to-role");
        String queryRoleString = this.prop.getProperty("sql-get-rolepermission");
        PermissionMap pc = new PermissionMap(true);
        Permission p = PermissionMaker.makePermission((String)resourcePermissionResultSet.getString("classname"), (String)resourcePermissionResultSet.getString("res"), (String)resourcePermissionResultSet.getString("actions"));
        boolean excluded = Boolean.getBoolean(resourcePermissionResultSet.getString("excluded"));
        boolean unchecked = Boolean.getBoolean(resourcePermissionResultSet.getString("unchecked"));
        Vector<RoleImpl> roles = new Vector<RoleImpl>();
        ResultSet resourceRoleResultSet = this.executeQuery(queryString, new String[]{this.domainName, resourcePermissionResultSet.getString("resourcepermissionid")});
        while (resourceRoleResultSet.next()) {
            ResultSet roleResultSet = this.executeQuery(queryRoleString, new String[]{resourceRoleResultSet.getString("rolepermissionid")});
            while (roleResultSet.next()) {
                roles.add(new RoleImpl(roleResultSet.getString("role")));
            }
            roleResultSet.close();
        }
        resourceRoleResultSet.close();
        Object[] rls = roles.toArray();
        pc.addPermission(p, rls, excluded, unchecked);
        return pc;
    }

    private void savePolicy(Policy ap, Vector querys) throws Exception {
        String queryString = this.prop.getProperty("sql-get-seqno");
        ResultSet seqNoResultSet = this.executeQuery(queryString, new String[]{"jeus_role_permission"});
        int currentSeqno = Integer.parseInt(seqNoResultSet.getString("currentseqno"));
        PermissionMap prPC = ap.getRolePolicy();
        this.saveRolePermission(++currentSeqno, prPC, querys);
        querys.add(this.getUpDateQuery("JEUS_SEQNO", new String[]{"currentseqno"}, new String[]{String.valueOf(currentSeqno - 1)}, new String[]{"tablename"}, new String[]{"jeus_role_permission"}));
        seqNoResultSet = this.executeQuery(queryString, new String[]{"jeus_resource_permission"});
        currentSeqno = Integer.parseInt(seqNoResultSet.getString("currentseqno"));
        ++currentSeqno;
        seqNoResultSet.close();
        for (String contextId : ap.getResourcePolicyIds()) {
            PermissionMap pm = ap.getResourcePolicy(contextId);
            if (pm == null) continue;
            this.saveResourcePermission(currentSeqno, pm, contextId, querys);
        }
        querys.add(this.getUpDateQuery("JEUS_SEQNO", new String[]{"currentseqno"}, new String[]{String.valueOf(currentSeqno - 1)}, new String[]{"tablename"}, new String[]{"jeus_resource_permission"}));
    }

    private void saveRolePermission(int currentIdx, PermissionMap pc, Vector querys) throws Exception {
        String queryString = this.prop.getProperty("sql-get-rolepermission");
        for (Permission p : pc.getAllPermissions()) {
            boolean isExcluded = false;
            boolean isUnchecked = false;
            if (pc.getExcludedPermissions().contains(p)) {
                isExcluded = true;
            }
            if (pc.getUncheckedPermissions().contains(p)) {
                isUnchecked = true;
            }
            ResultSet roleIdResultSet = this.executeQuery(queryString, new String[]{String.valueOf(currentIdx)});
            String rolePermissionId = null;
            if (roleIdResultSet.getRow() == 0) {
                querys.add(this.getInsertQuery("jeus-role-permission", new String[]{"rolepermissionid", "role", "actions", "classname", "excluded", "unchecked"}, new String[]{String.valueOf(currentIdx), p.getName(), p.getActions(), p.getClass().getName(), String.valueOf(isExcluded), String.valueOf(isUnchecked)}));
                querys.add(this.getInsertQuery("jeus_role_permissions", new String[]{"domain", "rolepermissionid", "description"}, new String[]{this.domainName, String.valueOf(currentIdx), "JEUS Role Permissions Table"}));
                rolePermissionId = Integer.toString(currentIdx);
                this.setRolePrincipalMapping(rolePermissionId, pc, p, querys);
                ++currentIdx;
            } else {
                while (roleIdResultSet.next()) {
                    rolePermissionId = roleIdResultSet.getString("rolepermissionid");
                    querys.add(this.getInsertQuery("jeus-role-permission", new String[]{"rolepermissionid", "role", "actions", "classname", "excluded", "unchecked"}, new String[]{rolePermissionId, p.getName(), p.getActions(), p.getClass().getName(), String.valueOf(isExcluded), String.valueOf(isUnchecked)}));
                    this.setRolePrincipalMapping(rolePermissionId, pc, p, querys);
                }
            }
            roleIdResultSet.close();
        }
    }

    private void setRolePrincipalMapping(String rolePermissionId, PermissionMap pc, Permission p, Vector querys) throws SQLException {
        String queryString = this.prop.getProperty("sql-get-isexist-role-to-principal");
        for (Principal prince : pc.getCheckedPermissionOwners(p)) {
            ResultSet rolePrincipalResultSet = this.executeQuery(queryString, new String[]{this.domainName, rolePermissionId, prince.getName()});
            if (rolePrincipalResultSet.getRow() != 0) continue;
            querys.add(this.getInsertQuery("jeus-role-principal", new String[]{"domain", "rolepermissionid", "username"}, new String[]{this.domainName, rolePermissionId, prince.getName()}));
        }
    }

    private void setResourceRoleMapping(String resourcePermissionId, PermissionMap pc, Permission p, Vector querys) throws SQLException {
        String queryString = this.prop.getProperty("sql-get-isexist-role-from-rolepermission");
        String queryResourceRoleString = this.prop.getProperty("sql-get-isexist-resource-to-role");
        for (Role role : pc.getCheckedPermissionOwners(p)) {
            ResultSet roleIdResultSet = this.executeQuery(queryString, new String[]{role.getName()});
            while (roleIdResultSet.next()) {
                ResultSet resourceRoleResultSet = this.executeQuery(queryResourceRoleString, new String[]{this.domainName, roleIdResultSet.getString("rolepermissionid"), resourcePermissionId});
                if (resourceRoleResultSet.getRow() != 0) continue;
                querys.add(this.getInsertQuery("jeus-resource-role", new String[]{"domain", "rolepermissionid", "resourcepermissionid"}, new String[]{this.domainName, roleIdResultSet.getString("rolepermissionid"), resourcePermissionId}));
            }
            roleIdResultSet.close();
        }
    }

    private void saveResourcePermission(int currentIdx, PermissionMap pc, String contextId, Vector querys) throws Exception {
        String queryString = this.prop.getProperty("sql-get-resourcepermission");
        for (Permission p : pc.getAllPermissions()) {
            String resourcePermissionId;
            ResultSet resourceIdResultSet;
            boolean isExcluded = false;
            boolean isUnchecked = false;
            if (pc.getExcludedPermissions().contains(p)) {
                isExcluded = true;
            }
            if (pc.getUncheckedPermissions().contains(p)) {
                isUnchecked = true;
            }
            if ((resourceIdResultSet = this.executeQuery(queryString, new String[]{String.valueOf(currentIdx)})).getRow() == 0) {
                querys.add(this.getInsertQuery("jeus-resource-permission", new String[]{"resourcepermissionid", "res", "actions", "classname", "excluded", "unchecked"}, new String[]{String.valueOf(currentIdx), p.getName(), p.getActions(), p.getClass().getName(), String.valueOf(isExcluded), String.valueOf(isUnchecked)}));
                querys.add(this.getInsertQuery("jeus_resource_permissions", new String[]{"domain", "contextid", "resourcepermissionid", "description"}, new String[]{this.domainName, contextId, String.valueOf(currentIdx), "JEUS Resource Permissions Table"}));
                resourcePermissionId = Integer.toString(currentIdx);
                this.setResourceRoleMapping(resourcePermissionId, pc, p, querys);
                ++currentIdx;
            } else {
                while (resourceIdResultSet.next()) {
                    resourcePermissionId = resourceIdResultSet.getString("resourcepermissionid");
                    querys.add(this.getInsertQuery("jeus-resource-permission", new String[]{"resourcepermissionid", "res", "actions", "classname", "excluded", "unchecked"}, new String[]{resourcePermissionId, p.getName(), p.getActions(), p.getClass().getName(), String.valueOf(isExcluded), String.valueOf(isUnchecked)}));
                    this.setResourceRoleMapping(resourcePermissionId, pc, p, querys);
                }
            }
            resourceIdResultSet.close();
        }
    }
}

