/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.util.ArrayList;
import jeus.security.util.SQLBuilder;
import jeus.security.util.SQLGeneratorException;

public abstract class DBRepositoryTable {
    protected SQLBuilder builder;
    protected String createquery;
    protected String insertquery;
    protected String selectquery;
    protected String dropquery;
    protected String updatequery;
    protected String deletequery;
    protected String checkquery;
    protected ArrayList list = new ArrayList();
    protected String table;
    protected String[] columns;
    protected String[] columnsType;
    protected String[] otherColumnsType;
    protected String[] whereColumns;
    protected String[] primaryKeyColumns;
    protected String columnType_varchar2 = "varchar2";
    protected String columnType_varchar = "varchar";

    protected void initSQLBuilder(String vendor) {
        try {
            this.builder = SQLBuilder.createSQLBuilder(vendor);
        }
        catch (SQLGeneratorException e) {
            e.printStackTrace();
        }
        if (!vendor.equals("oracle")) {
            this.columnsType = this.otherColumnsType;
        }
        this.makeCreateQuery();
        this.makeInsertQuery();
        this.makeSelectQuery();
        this.makeDropQuery();
        this.makeUpDateQuery();
        this.makeDeleteQuery();
        this.initQuery();
    }

    protected String convertNull(String str) {
        if (str == null) {
            return "null";
        }
        return "'" + str + "'";
    }

    protected void makeCreateQuery() {
        int i;
        this.builder.initCreateTableSQL();
        this.builder.setTableName(this.table);
        this.builder.beginColumnDeclaration();
        for (i = 0; i < this.columns.length; ++i) {
            this.builder.addColumnDeclaration(this.columns[i], this.columnsType[i]);
            for (int j = 0; j < this.primaryKeyColumns.length; ++j) {
                if (!this.columns[i].equals(this.primaryKeyColumns[j])) continue;
                this.builder.addNotNullConstraint();
            }
        }
        this.builder.beginPrimaryKeyConstraint();
        for (i = 0; i < this.primaryKeyColumns.length; ++i) {
            this.builder.addColumnName(this.primaryKeyColumns[i]);
        }
        this.builder.finishPrimaryKeyConstraint();
        this.builder.finishColumnDeclaration();
        this.createquery = this.builder.getSQL();
    }

    private void typeReplace(String vendor) {
        if (!vendor.equalsIgnoreCase("oracle")) {
            String[] newColumnsType = new String[this.columnsType.length];
            for (int i = 0; i < this.columnsType.length; ++i) {
                String colums = this.columnsType[i];
                colums.replaceAll(this.columnType_varchar2, this.columnType_varchar);
                newColumnsType[i] = colums;
            }
            this.columnsType = newColumnsType;
        }
    }

    protected void makeInsertQuery() {
        this.builder.initInsertSQL();
        this.builder.setTableName(this.table);
        this.builder.beginColumnName();
        this.builder.addColumnName(this.columns);
        this.builder.finishColumnName();
        this.builder.beginValues();
        this.builder.addValueList(this.columns.length, "? ");
        this.builder.finishValues();
        this.insertquery = this.builder.getSQL();
    }

    protected void makeSelectQuery() {
        this.builder.initSelectSQL();
        this.builder.addColumnName(this.columns);
        this.builder.beginFromClause();
        this.builder.setTableName(this.table);
        this.builder.finishFromClause();
        this.builder.beginWhereClause();
        this.builder.addWhereQuestion(this.whereColumns);
        this.builder.finishWhereClause();
        this.selectquery = this.builder.getSQL();
    }

    protected void makeDropQuery() {
        this.builder.initDeleteTableSQL();
        this.builder.setTableName(this.table);
        this.builder.addString("cascade constraints");
        this.dropquery = this.builder.getSQL();
    }

    protected void makeUpDateQuery() {
        this.builder.initUpdateSQL();
        this.builder.setTableName(this.table);
        this.builder.beginSetClause();
        for (int i = 1; i < this.columns.length; ++i) {
            this.builder.addSetColumn(this.columns[i]);
        }
        this.builder.finishSetClause();
        this.builder.beginWhereClause();
        this.builder.addWhereQuestion(this.whereColumns);
        this.builder.finishWhereClause();
        this.updatequery = this.builder.getSQL();
    }

    protected void makeDeleteQuery() {
        this.builder.initDeleteSQL();
        this.builder.setTableName(this.table);
        this.deletequery = this.builder.getSQL();
    }

    public String getCreateQuery() {
        return this.createquery;
    }

    public String getInsertQuery() {
        return this.insertquery;
    }

    public String getSelectQuery() {
        return this.selectquery;
    }

    public String getDropQuery() {
        return this.dropquery;
    }

    public String getUpdateQuery() {
        return this.updatequery;
    }

    public String getDeleteQuery() {
        return this.deletequery;
    }

    public ArrayList getInitQuery() {
        return this.list;
    }

    public String getCheckquery() {
        this.checkquery = "select * from " + this.table + " where domain = ?";
        return this.checkquery;
    }

    protected abstract void initQuery();

    protected String getColumnType() {
        return null;
    }
}

