/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import jeus.security.util.Base64Coder;
import jeus.util.logging.JeusLogger;

public class MessageDigestUtil {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.security.util");
    private static final int HASH_LEN = 20;
    public static final String BASE64_ENCODING = "BASE64";
    public static final String BASE16_ENCODING = "HEX";
    private static SecureRandom psuedoRng;
    private static MessageDigest sha1Digest;
    private static boolean initialized;

    public static void init() throws NoSuchAlgorithmException {
        if (initialized) {
            return;
        }
        MessageDigestUtil.init(null);
    }

    public static void init(byte[] prngSeed) throws NoSuchAlgorithmException {
        sha1Digest = MessageDigest.getInstance("SHA");
        psuedoRng = SecureRandom.getInstance("SHA1PRNG");
        if (prngSeed != null) {
            psuedoRng.setSeed(prngSeed);
        }
        initialized = true;
    }

    public static MessageDigest newDigest() {
        MessageDigest md = null;
        try {
            md = (MessageDigest)sha1Digest.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return md;
    }

    public static MessageDigest copy(MessageDigest md) {
        MessageDigest copy = null;
        try {
            copy = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public static Random getPRNG() {
        return psuedoRng;
    }

    public static double nextDouble() {
        return psuedoRng.nextDouble();
    }

    public static long nextLong() {
        return psuedoRng.nextLong();
    }

    public static void nextBytes(byte[] bytes) {
        psuedoRng.nextBytes(bytes);
    }

    public static byte[] generateSeed(int numBytes) {
        return psuedoRng.generateSeed(numBytes);
    }

    public static byte[] calculatePasswordHash(String username, char[] password, byte[] salt) {
        MessageDigest xd = MessageDigestUtil.newDigest();
        byte[] user = null;
        byte[] colon = new byte[]{};
        try {
            user = username.getBytes("UTF-8");
            colon = ":".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("Failed to convert username to byte[] using UTF-8", (Throwable)e);
            user = username.getBytes();
            colon = ":".getBytes();
        }
        byte[] passBytes = new byte[2 * password.length];
        int passBytesLength = 0;
        for (int p = 0; p < password.length; ++p) {
            int c = password[p] & 0xFFFF;
            byte b0 = (byte)(c & 0xFF);
            byte b1 = (byte)((c & 0xFF00) >> 8);
            passBytes[passBytesLength++] = b0;
            if (c <= 255) continue;
            passBytes[passBytesLength++] = b1;
        }
        xd.update(user);
        xd.update(colon);
        xd.update(passBytes, 0, passBytesLength);
        byte[] h = xd.digest();
        xd.reset();
        xd.update(salt);
        xd.update(h);
        byte[] xb = xd.digest();
        return xb;
    }

    public static byte[] calculateVerifier(String username, char[] password, byte[] salt, byte[] Nb, byte[] gb) {
        BigInteger g = new BigInteger(1, gb);
        BigInteger N = new BigInteger(1, Nb);
        return MessageDigestUtil.calculateVerifier(username, password, salt, N, g);
    }

    public static byte[] calculateVerifier(String username, char[] password, byte[] salt, BigInteger N, BigInteger g) {
        byte[] xb = MessageDigestUtil.calculatePasswordHash(username, password, salt);
        BigInteger x = new BigInteger(1, xb);
        BigInteger v = g.modPow(x, N);
        return v.toByteArray();
    }

    public static byte[] sessionKeyHash(byte[] number) {
        int i;
        int offset;
        for (offset = 0; offset < number.length && number[offset] == 0; ++offset) {
        }
        byte[] key = new byte[40];
        int klen = (number.length - offset) / 2;
        byte[] hbuf = new byte[klen];
        for (i = 0; i < klen; ++i) {
            hbuf[i] = number[number.length - 2 * i - 1];
        }
        byte[] hout = MessageDigestUtil.newDigest().digest(hbuf);
        for (i = 0; i < 20; ++i) {
            key[2 * i] = hout[i];
        }
        for (i = 0; i < klen; ++i) {
            hbuf[i] = number[number.length - 2 * i - 2];
        }
        hout = MessageDigestUtil.newDigest().digest(hbuf);
        for (i = 0; i < 20; ++i) {
            key[2 * i + 1] = hout[i];
        }
        return key;
    }

    public static byte[] trim(byte[] in) {
        int i;
        if (in.length == 0 || in[0] != 0) {
            return in;
        }
        int len = in.length;
        for (i = 1; in[i] == 0 && i < len; ++i) {
        }
        byte[] ret = new byte[len - i];
        System.arraycopy(in, i, ret, 0, len - i);
        return ret;
    }

    public static byte[] xor(byte[] b1, byte[] b2, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)(b1[i] ^ b2[i]);
        }
        return result;
    }

    public static String encodeBase16(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            char c = (char)(b >> 4 & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
            c = (char)(b & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String encodeBase64(byte[] bytes) {
        String base64 = null;
        try {
            base64 = new String(Base64Coder.encode(bytes));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return base64;
    }

    public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String username, String password) {
        byte[] passBytes;
        String passwordHash = null;
        try {
            passBytes = hashCharset == null ? password.getBytes() : password.getBytes(hashCharset);
        }
        catch (UnsupportedEncodingException uee) {
            logger.debug("charset " + hashCharset + " not found. Using platform default.", (Throwable)uee);
            passBytes = password.getBytes();
        }
        try {
            byte[] hash = MessageDigest.getInstance(hashAlgorithm).digest(passBytes);
            if (hashEncoding.equalsIgnoreCase(BASE64_ENCODING)) {
                passwordHash = MessageDigestUtil.encodeBase64(hash);
            } else if (hashEncoding.equalsIgnoreCase(BASE16_ENCODING)) {
                passwordHash = MessageDigestUtil.encodeBase16(hash);
            } else {
                logger.debug("Unsupported hash encoding format " + hashEncoding);
            }
        }
        catch (Exception e) {
            logger.debug("Password hash calculation failed ", (Throwable)e);
        }
        return passwordHash;
    }

    public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String password) {
        byte[] passBytes;
        String passwordHash = null;
        try {
            passBytes = hashCharset == null ? password.getBytes() : password.getBytes(hashCharset);
        }
        catch (UnsupportedEncodingException uee) {
            logger.debug("charset " + hashCharset + " not found. Using platform default.", (Throwable)uee);
            passBytes = password.getBytes();
        }
        try {
            byte[] hash = MessageDigest.getInstance(hashAlgorithm).digest(passBytes);
            if (hashEncoding.equalsIgnoreCase(BASE64_ENCODING)) {
                passwordHash = MessageDigestUtil.encodeBase64(hash);
            } else if (hashEncoding.equalsIgnoreCase(BASE16_ENCODING)) {
                passwordHash = MessageDigestUtil.encodeBase16(hash);
            } else {
                logger.debug("Unsupported hash encoding format " + hashEncoding);
            }
        }
        catch (Exception e) {
            logger.debug("Password hash calculation failed ", (Throwable)e);
        }
        return passwordHash;
    }

    public static String tob64(byte[] buffer) {
        return Base64Coder.byteArrayToBase64(buffer);
    }

    public static byte[] fromb64(String str) throws NumberFormatException {
        return Base64Coder.base64ToByteArray(str);
    }

    public static boolean hasUnlimitedCrypto() {
        boolean hasUnlimitedCrypto = false;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cipherClass = loader.loadClass("javax.crypto.Cipher");
            Class[] sig = new Class[]{String.class};
            Class[] sig2 = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{"Blowfish"};
            Object[] args2 = new Object[]{new Integer(256)};
            Method getInstance = cipherClass.getDeclaredMethod("getInstance", sig);
            Method init = cipherClass.getDeclaredMethod("init", sig2);
            Object cipher = getInstance.invoke(null, args);
            init.invoke(cipher, args2);
            hasUnlimitedCrypto = true;
        }
        catch (Throwable e) {
            logger.debug("hasUnlimitedCrypto error", e);
        }
        return hasUnlimitedCrypto;
    }

    public static Object createSecretKey(String cipherAlgorithm, Object key) throws KeyException {
        Class[] signature = new Class[]{key.getClass(), String.class};
        Object[] args = new Object[]{key, cipherAlgorithm};
        Object secretKey = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> secretKeySpecClass = loader.loadClass("javax.crypto.spec.SecretKeySpec");
            Constructor<?> ctor = secretKeySpecClass.getDeclaredConstructor(signature);
            secretKey = ctor.newInstance(args);
        }
        catch (Exception e) {
            throw new KeyException("Failed to create SecretKeySpec from session key, msg=" + e.getMessage());
        }
        catch (Throwable e) {
            throw new KeyException("Unexpected exception during SecretKeySpec creation, msg=" + e.getMessage());
        }
        return secretKey;
    }

    public static Object createSealedObject(String cipherAlgorithm, Object key, byte[] cipherIV, Serializable data) throws GeneralSecurityException {
        SealedObject sealedObject = null;
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            SecretKey skey = (SecretKey)key;
            IvParameterSpec iv = new IvParameterSpec(cipherIV);
            cipher.init(1, (Key)skey, iv);
            sealedObject = new SealedObject(data, cipher);
        }
        catch (GeneralSecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GeneralSecurityException("Failed to create SealedObject, msg=" + e.getMessage());
        }
        return sealedObject;
    }

    public static Object accessSealedObject(String cipherAlgorithm, Object key, byte[] cipherIV, Object obj) throws GeneralSecurityException {
        Object data = null;
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            SecretKey skey = (SecretKey)key;
            IvParameterSpec iv = new IvParameterSpec(cipherIV);
            cipher.init(2, (Key)skey, iv);
            SealedObject sealedObj = (SealedObject)obj;
            data = sealedObj.getObject(cipher);
        }
        catch (GeneralSecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GeneralSecurityException("Failed to access SealedObject, msg=" + e.getMessage());
        }
        return data;
    }
}

