/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import jeus.security.util.Constants;

public class NetworkUtil {
    public static final byte SUBJECT_TYPE_ANONYMOUS = 1;
    public static final byte SUBJECT_TYPE_CODESUBJECT = 2;
    public static final byte SUBJECT_TYPE_STRING = 3;
    public static final byte SUBJECT_TYPE_OBJECT = 4;
    public static final byte SUBJECT_TYPE_NULL = 5;
    public static final byte PASSWORD_ALGORITHM_TYPE_NULL = 6;
    public static final byte PASSWORD_ALGORITHM_TYPE_BASE64 = 7;
    public static final byte PASSWORD_ALGORITHM_TYPE_SHA = 8;
    public static final byte PASSWORD_ALGORITHM_TYPE_DES = 9;
    public static final byte PASSWORD_ALGORITHM_TYPE_DESEDE = 10;
    public static final byte PASSWORD_ALGORITHM_TYPE_AES = 11;
    public static final byte PASSWORD_ALGORITHM_TYPE_SEED = 12;
    public static final byte PASSWORD_ALGORITHM_TYPE_BLOWFISH = 13;
    public static final byte OPCODE_AUTHENTICATE = 1;
    public static final byte OPCODE_GETSUBJECT = 2;
    public static final byte OPCODE_GETSUBJECTNAMES = 3;
    public static final byte OPCODE_ADDSUBJECT = 4;
    public static final byte OPCODE_REMOVESUBJECT_BY_SUBJECT = 5;
    public static final byte OPCODE_REMOVESUBJECT_BY_NAME = 6;
    public static final byte OPCODE_AUTHORIZE = 7;
    public static final byte OPCODE_GETPOLICY = 8;
    public static final byte OPCODE_GETPOLICYIDS = 9;
    public static final byte OPCODE_ADDPOLICY = 10;
    public static final byte OPCODE_REMOVEPOLICY_BY_POLICY = 11;
    public static final byte OPCODE_REMOVEPOLICY_BY_NAME = 12;
    public static final byte OPCODE_LOGINTEST = 13;
    public static final byte OPCODE_CHECKPERMISSION = 14;
    public static final byte OPCODE_CHECKVALIDITY = 15;
    public static final byte OPCODE_SUBJECT_SAVE = 16;
    public static final byte OPCODE_POLICY_SAVE = 17;
    public static final byte OPCODE_GETGROUP = 18;
    public static final byte OPCODE_GETGROUPLIST = 19;
    public static final byte OPCODE_GETGROUPNAMES = 20;
    public static final byte OPCODE_ADDGROUP = 21;
    public static final byte OPCODE_ADDGROUP_TOUSER = 22;
    public static final byte OPCODE_REMOVE_GROUP = 23;
    public static final byte OPCODE_REMOVEGROUP_TOUSER = 24;
    public static final byte OPCODE_GETMEMBERS_FROMGROUP = 25;
    public static final byte OPCODE_REPLY_SUBJECT = 64;
    public static final byte OPCODE_REPLY_SEREALIZABLE = 65;
    public static final byte OPCODE_REPLY_NULL = 66;
    public static final byte OPCODE_EXCEPTION = -1;
    public static final int BROADCAST_NONE = 0;
    public static final int BROADCAST_MASTER_TO_SLAVE = 1;
    public static final int BROADCAST_SLAVE = 2;
    public static final int BROADCAST_ALL = 3;

    public static String getClassName(byte opcode) {
        if (opcode == 1) {
            return "jeus.security.spi.AuthenticationService";
        }
        if (opcode == 2 || opcode == 3 || opcode == 4 || opcode == 5 || opcode == 6) {
            return "jeus.security.spi.AuthenticationRepositoryService";
        }
        if (opcode == 7) {
            return "jeus.security.spi.AuthenticationService";
        }
        if (opcode == 8 || opcode == 9 || opcode == 10 || opcode == 11 || opcode == 12) {
            return "jeus.security.spi.AuthorizationRepositoryService";
        }
        if (opcode == 13 || opcode == 14) {
            return "jeus.security.spi.LoginService";
        }
        if (opcode == 15) {
            return "jeus.security.spi.SubjectValidationService";
        }
        return null;
    }

    public static String getMethodName(byte opcode) {
        if (opcode == 1) {
            return "authenticate";
        }
        if (opcode == 2) {
            return "getSubject";
        }
        if (opcode == 3) {
            return "getSubjectNames";
        }
        if (opcode == 4) {
            return "addSubject";
        }
        if (opcode == 5) {
            return "removeSubject";
        }
        if (opcode == 6) {
            return "removeSubject";
        }
        if (opcode == 7) {
            return "authorize";
        }
        if (opcode == 8) {
            return "getPolicy";
        }
        if (opcode == 9) {
            return "getPolicyIds";
        }
        if (opcode == 10) {
            return "addPolicy";
        }
        if (opcode == 11) {
            return "removePolicy";
        }
        if (opcode == 12) {
            return "removePolicy";
        }
        if (opcode == 13) {
            return "loginTest";
        }
        if (opcode == 14) {
            return "checkPermission";
        }
        if (opcode == 15) {
            return "checkValidity";
        }
        return null;
    }

    public static byte getAlgorithmType(String algorithm) {
        int i;
        if (algorithm == null) {
            return 6;
        }
        String[] supportAlgorithmValues = Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES;
        for (i = 0; i < supportAlgorithmValues.length && !supportAlgorithmValues[i].equalsIgnoreCase(algorithm); ++i) {
        }
        switch (i) {
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 13;
            }
        }
        return 6;
    }

    public static String getAlgorithmType(byte algorithm) {
        switch (algorithm) {
            case 7: {
                return Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES[0];
            }
            case 8: {
                return Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES[1];
            }
            case 9: {
                return Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES[2];
            }
            case 10: {
                return Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES[3];
            }
            case 11: {
                return Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES[4];
            }
            case 12: {
                return Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES[5];
            }
            case 13: {
                return Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES[6];
            }
        }
        return null;
    }
}

