/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jeus.security.util.CopyOnWriteHashSet;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;

public class OneToManyMap
implements Cloneable,
Serializable {
    private ConcurrentHashMap ht;
    private Class containerType;
    private static final Class DEFAULT_CONTAINER_TYPE = CopyOnWriteArrayList.class;
    private static final HashSet emptyHashSet = new HashSet();

    public OneToManyMap() {
        this(null);
    }

    public void clear() {
        this.ht.clear();
    }

    public OneToManyMap(Class containerType) {
        this.containerType = containerType == null ? DEFAULT_CONTAINER_TYPE : containerType;
        this.ht = new ConcurrentHashMap();
    }

    public Collection put(Object key, Object value) {
        Collection c;
        if (key == null) {
            return null;
        }
        Object o = this.ht.get(key);
        if (o != null) {
            c = (Collection)o;
        } else {
            try {
                c = (Collection)this.containerType.newInstance();
                this.ht.put(key, c);
            }
            catch (Exception e) {
                return null;
            }
        }
        c.add(value);
        return c;
    }

    public Collection get(Object key) {
        if (key == null) {
            return null;
        }
        Object o = this.ht.get(key);
        if (o == null) {
            return emptyHashSet;
        }
        return (Collection)o;
    }

    public Collection remove(Object key) {
        if (key == null) {
            return null;
        }
        Object o = this.ht.remove(key);
        if (o == null) {
            return null;
        }
        return (Collection)o;
    }

    public boolean isEmpty() {
        return this.ht.isEmpty();
    }

    public void remove(OneToManyMap map) {
        if (map == null || map == this) {
            return;
        }
        for (Object key : map.keys()) {
            for (Object value : map.get(key)) {
                this.removeValue(key, value);
            }
        }
    }

    public String toString() {
        Iterator keys = this.keys().iterator();
        StringBuffer strBuf = new StringBuffer("OneToManyMap\n\n");
        while (keys.hasNext()) {
            Object key = keys.next();
            strBuf.append("Key: ");
            strBuf.append(key);
            strBuf.append("\n");
            Iterator values = this.get(key).iterator();
            if (values != null) {
                strBuf.append("Values: ");
                while (values.hasNext()) {
                    Object value = values.next();
                    strBuf.append(value);
                    strBuf.append("\n");
                }
            }
            strBuf.append("\n\n");
        }
        return strBuf.toString();
    }

    public boolean removeValue(Object key, Object value) {
        if (key == null) {
            return false;
        }
        Object o = this.ht.get(key);
        if (o == null) {
            return false;
        }
        Collection c = (Collection)o;
        boolean result = c.remove(value);
        if (c.size() == 0) {
            this.remove(key);
        }
        return result;
    }

    public boolean containsKey(Object key) {
        return this.ht.keySet().contains(key);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return this.values().contains(value);
    }

    public Set keys() {
        return this.ht.keySet();
    }

    public int numValues() {
        Collection c = this.values();
        return c == null ? 0 : c.size();
    }

    public int numKeys() {
        return this.keys().size();
    }

    public Set keys(Object value) {
        if (value == null) {
            return new CopyOnWriteHashSet();
        }
        try {
            CopyOnWriteHashSet result = new CopyOnWriteHashSet();
            for (Object key : this.keys()) {
                Collection values = this.get(key);
                if (!values.contains(value)) continue;
                result.add(key);
            }
            return result;
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._34_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._34_LEVEL, JeusMessage_Security._34, (Throwable)e);
            }
            return new CopyOnWriteHashSet();
        }
    }

    public Collection values() {
        Collection allValues;
        try {
            allValues = (Collection)this.containerType.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        for (Object key : this.keys()) {
            Collection values = this.get(key);
            if (values == null) continue;
            allValues.addAll(values);
        }
        return allValues;
    }

    public OneToManyMap merge(OneToManyMap mapToMerge) {
        Iterator keys;
        if (mapToMerge != null && mapToMerge != this && (keys = mapToMerge.keys().iterator()) != null) {
            while (keys.hasNext()) {
                Object key = keys.next();
                Iterator values = mapToMerge.get(key).iterator();
                if (values == null) continue;
                while (values.hasNext()) {
                    Object value = values.next();
                    this.put(key, value);
                }
            }
        }
        return this;
    }

    public boolean contains(Object object) {
        return this.containsValue(object) || this.containsKey(object);
    }

    public int hashCode() {
        int hash = Integer.MIN_VALUE;
        for (Object key : this.keys()) {
            Iterator values = this.get(key).iterator();
            int sum = 0;
            if (values != null) {
                while (values.hasNext()) {
                    Object value = values.next();
                    sum += value.hashCode();
                }
            }
            hash += key.hashCode() ^ sum;
        }
        return hash;
    }

    public Object clone() {
        OneToManyMap newMap = new OneToManyMap(this.containerType);
        return newMap.merge(this);
    }

    public boolean equals(Object anotherObject) {
        if (anotherObject == null) {
            return false;
        }
        if (this == anotherObject) {
            return true;
        }
        if (anotherObject instanceof OneToManyMap) {
            Set thisMapsKeys;
            OneToManyMap otherMap = (OneToManyMap)anotherObject;
            if (otherMap.containerType != this.containerType) {
                return false;
            }
            Set otherMapsKeys = otherMap.ht.keySet();
            if (((Object)otherMapsKeys).equals(thisMapsKeys = this.ht.keySet())) {
                for (Object key : this.keys()) {
                    Collection thisMapsObjects;
                    Collection otherMapsObjects = (Collection)otherMap.ht.get(key);
                    if (((Object)otherMapsObjects).equals(thisMapsObjects = (Collection)this.ht.get(key))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void addAll(Map map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            this.put(key, value);
        }
    }
}

