/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import jeus.security.util.StringSerializer;

public class ReflectionUtil {
    public static Object invokeConstructorWithStrings(String classname, Object[] stringArguments) throws Exception {
        return ReflectionUtil.invokeConstructorWithStrings(Class.forName(classname), stringArguments);
    }

    public static Object invokeConstructorWithStrings(Class type, Object[] stringArguments) throws Exception {
        Constructor<?>[] cons = type.getConstructors();
        Object[] args = stringArguments == null ? new Object[]{} : stringArguments;
        Exception ex = null;
        for (int i = 0; i < cons.length; ++i) {
            Class[] types = cons[i].getParameterTypes();
            if (types.length != args.length) continue;
            try {
                return ReflectionUtil.invokeConstructor(type, ReflectionUtil.getObjectsForStrings(args, types));
            }
            catch (Exception e) {
                ex = e;
            }
        }
        throw new Exception("Failed to invoke constructor for class " + type.getName() + " in invokeConstructorWithStrings()", ex);
    }

    public static Object invokeConstructor(String classname) throws Exception {
        return ReflectionUtil.invokeConstructor(Class.forName(classname), new Object[0]);
    }

    public static Object invokeConstructor(Class type) throws Exception {
        return ReflectionUtil.invokeConstructor(type, new Object[0]);
    }

    public static Object invokeConstructor(String classname, Object[] arguments) throws Exception {
        return ReflectionUtil.invokeConstructor(Class.forName(classname), arguments);
    }

    public static Object invokeConstructor(Class type, Object[] arguments) throws Exception {
        Constructor<?>[] cons = type.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            try {
                return cons[i].newInstance(arguments);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new Exception("No constructor found for type " + type + " that matches the given arguments");
    }

    public static Object invokeMethodWithStrings(Object instance, String methodName, Object[] stringArguments) throws Exception {
        Method[] methods = instance.getClass().getMethods();
        Object[] args = stringArguments == null ? new Object[]{} : stringArguments;
        for (int i = 0; i < methods.length; ++i) {
            Class[] types = methods[i].getParameterTypes();
            String name = methods[i].getName();
            if (!name.equals(methodName) || types.length != args.length) continue;
            try {
                return ReflectionUtil.invokeMethod(instance, methodName, ReflectionUtil.getObjectsForStrings(args, types));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new Exception("Failed to invoke method " + methodName + " in invokeMethodWithStrings");
    }

    public static Object invokeMethodForString(Object instance, String methodName) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return ReflectionUtil.invokeMethodForString(instance, methodName, new Object[0]);
    }

    public static Object invokeMethodForString(Object instance, String methodName, Object[] args) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return ReflectionUtil.invokeMethodForString(instance, methodName, args, ReflectionUtil.getTypes(args));
    }

    public static Object invokeMethodForString(Object instance, String methodName, Object[] args, Class[] types) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object o = ReflectionUtil.invokeMethod(instance, methodName, args, types);
        if (o != null) {
            if (o.getClass().isArray()) {
                return StringSerializer.toStringFromArray((Object[])o);
            }
            return StringSerializer.toString(o);
        }
        return null;
    }

    public static Object invokeMethod(Object instance, String methodName) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return ReflectionUtil.invokeMethod(instance, methodName, new Object[0]);
    }

    public static Object invokeMethod(Object instance, String methodName, Object[] args) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return ReflectionUtil.invokeMethod(instance, methodName, args, ReflectionUtil.getTypes(args));
    }

    public static Object invokeMethod(Object instance, String methodName, Object[] args, Class[] types) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (instance instanceof Class) {
            Method m = ((Class)instance).getMethod(methodName, types);
            return m.invoke(null, args);
        }
        Method m = instance.getClass().getMethod(methodName, types);
        return m.invoke(instance, args);
    }

    private static Class[] getTypes(Object[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return new Class[0];
        }
        Class[] classes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) {
                classes[i] = null;
            }
            classes[i] = arguments[i].getClass();
        }
        return classes;
    }

    private static Object[] getObjectsForStrings(Object[] stringValues, Class[] types) {
        if (stringValues == null || stringValues.length == 0) {
            return null;
        }
        Object[] result = new Object[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            Object[] values;
            Object o = stringValues[i];
            if (o == null) {
                result[i] = null;
                continue;
            }
            if (o instanceof String) {
                Object value;
                result[i] = value = StringSerializer.fromString((String)o, types[i]);
                continue;
            }
            if (!(o instanceof String[])) continue;
            result[i] = values = StringSerializer.fromString((String[])o, types[i]);
        }
        return result;
    }

    public static Map getAttributeMethods(Class c) {
        Method[] methods = c.getMethods();
        Hashtable<String, Method> getters = new Hashtable<String, Method>();
        Hashtable<String, Method> setters = new Hashtable<String, Method>();
        Hashtable<String, Method> result = new Hashtable<String, Method>();
        for (int i = 0; i < methods.length; ++i) {
            String name;
            if (ReflectionUtil.isGetter(methods[i])) {
                name = methods[i].getName().substring(3);
                getters.put(name, methods[i]);
                continue;
            }
            if (!ReflectionUtil.isSetter(methods[i])) continue;
            name = methods[i].getName().substring(3);
            setters.put(name, methods[i]);
        }
        for (String name : getters.keySet()) {
            Object o = setters.get(name);
            if (o == null) continue;
            Method getter = (Method)getters.get(name);
            Method setter = (Method)o;
            result.put("get" + name, getter);
            result.put("set" + name, setter);
        }
        return result;
    }

    public static boolean isGetter(Method m) {
        return m.getName().startsWith("get") && m.getParameterTypes().length == 0 && ReflectionUtil.isWrapperType(m.getReturnType());
    }

    public static boolean isSetter(Method m) {
        return m.getName().startsWith("set") && m.getParameterTypes().length == 1 && ReflectionUtil.isWrapperType(m.getParameterTypes()[0]);
    }

    public static boolean isWrapperType(Class c) {
        if (c.isArray()) {
            c = c.getComponentType();
        }
        return c == String.class || c == Integer.class || c == Long.class || c == Boolean.class || c == Short.class || c == Byte.class || c == Character.class || c == Double.class || c == Float.class;
    }
}

